// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the properties of a solution update. For a complete listing, call the [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html) API.
 */
public class SolutionUpdateSummary private constructor(builder: Builder) {
    /**
     * The date and time (in Unix format) that the solution update was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * If a solution update fails, the reason behind the failure.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The date and time (in Unix time) that the solution update was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * Whether the solution automatically creates solution versions.
     */
    public val performAutoTraining: kotlin.Boolean? = builder.performAutoTraining
    /**
     * The configuration details of the solution.
     */
    public val solutionUpdateConfig: aws.sdk.kotlin.services.personalize.model.SolutionUpdateConfig? = builder.solutionUpdateConfig
    /**
     * The status of the solution update. A solution update can be in one of the following states:
     *
     * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.SolutionUpdateSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SolutionUpdateSummary(")
        append("creationDateTime=$creationDateTime,")
        append("failureReason=$failureReason,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("performAutoTraining=$performAutoTraining,")
        append("solutionUpdateConfig=$solutionUpdateConfig,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (performAutoTraining?.hashCode() ?: 0)
        result = 31 * result + (solutionUpdateConfig?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SolutionUpdateSummary

        if (creationDateTime != other.creationDateTime) return false
        if (failureReason != other.failureReason) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (performAutoTraining != other.performAutoTraining) return false
        if (solutionUpdateConfig != other.solutionUpdateConfig) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.SolutionUpdateSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time (in Unix format) that the solution update was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If a solution update fails, the reason behind the failure.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The date and time (in Unix time) that the solution update was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Whether the solution automatically creates solution versions.
         */
        public var performAutoTraining: kotlin.Boolean? = null
        /**
         * The configuration details of the solution.
         */
        public var solutionUpdateConfig: aws.sdk.kotlin.services.personalize.model.SolutionUpdateConfig? = null
        /**
         * The status of the solution update. A solution update can be in one of the following states:
         *
         * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.SolutionUpdateSummary) : this() {
            this.creationDateTime = x.creationDateTime
            this.failureReason = x.failureReason
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.performAutoTraining = x.performAutoTraining
            this.solutionUpdateConfig = x.solutionUpdateConfig
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.SolutionUpdateSummary = SolutionUpdateSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.SolutionUpdateConfig] inside the given [block]
         */
        public fun solutionUpdateConfig(block: aws.sdk.kotlin.services.personalize.model.SolutionUpdateConfig.Builder.() -> kotlin.Unit) {
            this.solutionUpdateConfig = aws.sdk.kotlin.services.personalize.model.SolutionUpdateConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
