// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the configuration properties for the solution.
 */
public class SolutionConfig private constructor(builder: Builder) {
    /**
     * Lists the algorithm hyperparameters and their values.
     */
    public val algorithmHyperParameters: Map<String, String>? = builder.algorithmHyperParameters
    /**
     * The [AutoMLConfig](https://docs.aws.amazon.com/personalize/latest/dg/API_AutoMLConfig.html) object containing a list of recipes to search when AutoML is performed.
     */
    public val autoMlConfig: aws.sdk.kotlin.services.personalize.model.AutoMlConfig? = builder.autoMlConfig
    /**
     * Specifies the automatic training configuration to use.
     */
    public val autoTrainingConfig: aws.sdk.kotlin.services.personalize.model.AutoTrainingConfig? = builder.autoTrainingConfig
    /**
     * Only events with a value greater than or equal to this threshold are used for training a model.
     */
    public val eventValueThreshold: kotlin.String? = builder.eventValueThreshold
    /**
     * Lists the feature transformation parameters.
     */
    public val featureTransformationParameters: Map<String, String>? = builder.featureTransformationParameters
    /**
     * Describes the properties for hyperparameter optimization (HPO).
     */
    public val hpoConfig: aws.sdk.kotlin.services.personalize.model.HpoConfig? = builder.hpoConfig
    /**
     * Describes the additional objective for the solution, such as maximizing streaming minutes or increasing revenue. For more information see [Optimizing a solution](https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html).
     */
    public val optimizationObjective: aws.sdk.kotlin.services.personalize.model.OptimizationObjective? = builder.optimizationObjective
    /**
     * Specifies the training data configuration to use when creating a custom solution version (trained model).
     */
    public val trainingDataConfig: aws.sdk.kotlin.services.personalize.model.TrainingDataConfig? = builder.trainingDataConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.SolutionConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SolutionConfig(")
        append("algorithmHyperParameters=$algorithmHyperParameters,")
        append("autoMlConfig=$autoMlConfig,")
        append("autoTrainingConfig=$autoTrainingConfig,")
        append("eventValueThreshold=$eventValueThreshold,")
        append("featureTransformationParameters=$featureTransformationParameters,")
        append("hpoConfig=$hpoConfig,")
        append("optimizationObjective=$optimizationObjective,")
        append("trainingDataConfig=$trainingDataConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmHyperParameters?.hashCode() ?: 0
        result = 31 * result + (autoMlConfig?.hashCode() ?: 0)
        result = 31 * result + (autoTrainingConfig?.hashCode() ?: 0)
        result = 31 * result + (eventValueThreshold?.hashCode() ?: 0)
        result = 31 * result + (featureTransformationParameters?.hashCode() ?: 0)
        result = 31 * result + (hpoConfig?.hashCode() ?: 0)
        result = 31 * result + (optimizationObjective?.hashCode() ?: 0)
        result = 31 * result + (trainingDataConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SolutionConfig

        if (algorithmHyperParameters != other.algorithmHyperParameters) return false
        if (autoMlConfig != other.autoMlConfig) return false
        if (autoTrainingConfig != other.autoTrainingConfig) return false
        if (eventValueThreshold != other.eventValueThreshold) return false
        if (featureTransformationParameters != other.featureTransformationParameters) return false
        if (hpoConfig != other.hpoConfig) return false
        if (optimizationObjective != other.optimizationObjective) return false
        if (trainingDataConfig != other.trainingDataConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.SolutionConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Lists the algorithm hyperparameters and their values.
         */
        public var algorithmHyperParameters: Map<String, String>? = null
        /**
         * The [AutoMLConfig](https://docs.aws.amazon.com/personalize/latest/dg/API_AutoMLConfig.html) object containing a list of recipes to search when AutoML is performed.
         */
        public var autoMlConfig: aws.sdk.kotlin.services.personalize.model.AutoMlConfig? = null
        /**
         * Specifies the automatic training configuration to use.
         */
        public var autoTrainingConfig: aws.sdk.kotlin.services.personalize.model.AutoTrainingConfig? = null
        /**
         * Only events with a value greater than or equal to this threshold are used for training a model.
         */
        public var eventValueThreshold: kotlin.String? = null
        /**
         * Lists the feature transformation parameters.
         */
        public var featureTransformationParameters: Map<String, String>? = null
        /**
         * Describes the properties for hyperparameter optimization (HPO).
         */
        public var hpoConfig: aws.sdk.kotlin.services.personalize.model.HpoConfig? = null
        /**
         * Describes the additional objective for the solution, such as maximizing streaming minutes or increasing revenue. For more information see [Optimizing a solution](https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html).
         */
        public var optimizationObjective: aws.sdk.kotlin.services.personalize.model.OptimizationObjective? = null
        /**
         * Specifies the training data configuration to use when creating a custom solution version (trained model).
         */
        public var trainingDataConfig: aws.sdk.kotlin.services.personalize.model.TrainingDataConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.SolutionConfig) : this() {
            this.algorithmHyperParameters = x.algorithmHyperParameters
            this.autoMlConfig = x.autoMlConfig
            this.autoTrainingConfig = x.autoTrainingConfig
            this.eventValueThreshold = x.eventValueThreshold
            this.featureTransformationParameters = x.featureTransformationParameters
            this.hpoConfig = x.hpoConfig
            this.optimizationObjective = x.optimizationObjective
            this.trainingDataConfig = x.trainingDataConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.SolutionConfig = SolutionConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.AutoMlConfig] inside the given [block]
         */
        public fun autoMlConfig(block: aws.sdk.kotlin.services.personalize.model.AutoMlConfig.Builder.() -> kotlin.Unit) {
            this.autoMlConfig = aws.sdk.kotlin.services.personalize.model.AutoMlConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.AutoTrainingConfig] inside the given [block]
         */
        public fun autoTrainingConfig(block: aws.sdk.kotlin.services.personalize.model.AutoTrainingConfig.Builder.() -> kotlin.Unit) {
            this.autoTrainingConfig = aws.sdk.kotlin.services.personalize.model.AutoTrainingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.HpoConfig] inside the given [block]
         */
        public fun hpoConfig(block: aws.sdk.kotlin.services.personalize.model.HpoConfig.Builder.() -> kotlin.Unit) {
            this.hpoConfig = aws.sdk.kotlin.services.personalize.model.HpoConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.OptimizationObjective] inside the given [block]
         */
        public fun optimizationObjective(block: aws.sdk.kotlin.services.personalize.model.OptimizationObjective.Builder.() -> kotlin.Unit) {
            this.optimizationObjective = aws.sdk.kotlin.services.personalize.model.OptimizationObjective.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.TrainingDataConfig] inside the given [block]
         */
        public fun trainingDataConfig(block: aws.sdk.kotlin.services.personalize.model.TrainingDataConfig.Builder.() -> kotlin.Unit) {
            this.trainingDataConfig = aws.sdk.kotlin.services.personalize.model.TrainingDataConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
