// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration details of an Amazon S3 input or output bucket.
 */
public class S3DataConfig private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key that Amazon Personalize uses to encrypt or decrypt the input and output files.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The file path of the Amazon S3 bucket.
     */
    public val path: kotlin.String = requireNotNull(builder.path) { "A non-null value must be provided for path" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.S3DataConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3DataConfig(")
        append("kmsKeyArn=$kmsKeyArn,")
        append("path=$path")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyArn?.hashCode() ?: 0
        result = 31 * result + (path.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3DataConfig

        if (kmsKeyArn != other.kmsKeyArn) return false
        if (path != other.path) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.S3DataConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key that Amazon Personalize uses to encrypt or decrypt the input and output files.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The file path of the Amazon S3 bucket.
         */
        public var path: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.S3DataConfig) : this() {
            this.kmsKeyArn = x.kmsKeyArn
            this.path = x.path
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.S3DataConfig = S3DataConfig(this)

        internal fun correctErrors(): Builder {
            if (path == null) path = ""
            return this
        }
    }
}
