// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The output configuration details for a metric attribution.
 */
public class MetricAttributionOutput private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output Amazon S3 bucket and add metrics to Amazon CloudWatch. For more information, see [Measuring impact of recommendations](https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html).
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The configuration details of an Amazon S3 input or output bucket.
     */
    public val s3DataDestination: aws.sdk.kotlin.services.personalize.model.S3DataConfig? = builder.s3DataDestination

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.MetricAttributionOutput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricAttributionOutput(")
        append("roleArn=$roleArn,")
        append("s3DataDestination=$s3DataDestination")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn.hashCode()
        result = 31 * result + (s3DataDestination?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricAttributionOutput

        if (roleArn != other.roleArn) return false
        if (s3DataDestination != other.s3DataDestination) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.MetricAttributionOutput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output Amazon S3 bucket and add metrics to Amazon CloudWatch. For more information, see [Measuring impact of recommendations](https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html).
         */
        public var roleArn: kotlin.String? = null
        /**
         * The configuration details of an Amazon S3 input or output bucket.
         */
        public var s3DataDestination: aws.sdk.kotlin.services.personalize.model.S3DataConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.MetricAttributionOutput) : this() {
            this.roleArn = x.roleArn
            this.s3DataDestination = x.s3DataDestination
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.MetricAttributionOutput = MetricAttributionOutput(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.S3DataConfig] inside the given [block]
         */
        public fun s3DataDestination(block: aws.sdk.kotlin.services.personalize.model.S3DataConfig.Builder.() -> kotlin.Unit) {
            this.s3DataDestination = aws.sdk.kotlin.services.personalize.model.S3DataConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
