// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateSolutionVersionRequest private constructor(builder: Builder) {
    /**
     * The name of the solution version.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the solution containing the training configuration information.
     */
    public val solutionArn: kotlin.String? = builder.solutionArn
    /**
     * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) to apply to the solution version.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The scope of training to be performed when creating the solution version. The default is `FULL`. This creates a completely new model based on the entirety of the training data from the datasets in your dataset group.
     *
     * If you use [User-Personalization](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html), you can specify a training mode of `UPDATE`. This updates the model to consider new items for recommendations. It is not a full retraining. You should still complete a full retraining weekly. If you specify `UPDATE`, Amazon Personalize will stop automatic updates for the solution version. To resume updates, create a new solution with training mode set to `FULL` and deploy it in a campaign. For more information about automatic updates, see [Automatic updates](https://docs.aws.amazon.com/personalize/latest/dg/use-case-recipe-features.html#maintaining-with-automatic-updates).
     *
     * The `UPDATE` option can only be used when you already have an active solution version created from the input solution using the `FULL` option and the input solution was trained with the [User-Personalization](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html) recipe or the legacy [HRNN-Coldstart](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html) recipe.
     */
    public val trainingMode: aws.sdk.kotlin.services.personalize.model.TrainingMode? = builder.trainingMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.CreateSolutionVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSolutionVersionRequest(")
        append("name=$name,")
        append("solutionArn=$solutionArn,")
        append("tags=$tags,")
        append("trainingMode=$trainingMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (solutionArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trainingMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSolutionVersionRequest

        if (name != other.name) return false
        if (solutionArn != other.solutionArn) return false
        if (tags != other.tags) return false
        if (trainingMode != other.trainingMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.CreateSolutionVersionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the solution version.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the solution containing the training configuration information.
         */
        public var solutionArn: kotlin.String? = null
        /**
         * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) to apply to the solution version.
         */
        public var tags: List<Tag>? = null
        /**
         * The scope of training to be performed when creating the solution version. The default is `FULL`. This creates a completely new model based on the entirety of the training data from the datasets in your dataset group.
         *
         * If you use [User-Personalization](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html), you can specify a training mode of `UPDATE`. This updates the model to consider new items for recommendations. It is not a full retraining. You should still complete a full retraining weekly. If you specify `UPDATE`, Amazon Personalize will stop automatic updates for the solution version. To resume updates, create a new solution with training mode set to `FULL` and deploy it in a campaign. For more information about automatic updates, see [Automatic updates](https://docs.aws.amazon.com/personalize/latest/dg/use-case-recipe-features.html#maintaining-with-automatic-updates).
         *
         * The `UPDATE` option can only be used when you already have an active solution version created from the input solution using the `FULL` option and the input solution was trained with the [User-Personalization](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html) recipe or the legacy [HRNN-Coldstart](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html) recipe.
         */
        public var trainingMode: aws.sdk.kotlin.services.personalize.model.TrainingMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.CreateSolutionVersionRequest) : this() {
            this.name = x.name
            this.solutionArn = x.solutionArn
            this.tags = x.tags
            this.trainingMode = x.trainingMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.CreateSolutionVersionRequest = CreateSolutionVersionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
