// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateRecommenderRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the destination domain dataset group for the recommender.
     */
    public val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * The name of the recommender.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the recipe that the recommender will use. For a recommender, a recipe is a Domain dataset group use case. Only Domain dataset group use cases can be used to create a recommender. For information about use cases see [Choosing recommender use cases](https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html).
     */
    public val recipeArn: kotlin.String? = builder.recipeArn
    /**
     * The configuration details of the recommender.
     */
    public val recommenderConfig: aws.sdk.kotlin.services.personalize.model.RecommenderConfig? = builder.recommenderConfig
    /**
     * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) to apply to the recommender.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.CreateRecommenderRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRecommenderRequest(")
        append("datasetGroupArn=$datasetGroupArn,")
        append("name=$name,")
        append("recipeArn=$recipeArn,")
        append("recommenderConfig=$recommenderConfig,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = datasetGroupArn?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (recipeArn?.hashCode() ?: 0)
        result = 31 * result + (recommenderConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRecommenderRequest

        if (datasetGroupArn != other.datasetGroupArn) return false
        if (name != other.name) return false
        if (recipeArn != other.recipeArn) return false
        if (recommenderConfig != other.recommenderConfig) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.CreateRecommenderRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the destination domain dataset group for the recommender.
         */
        public var datasetGroupArn: kotlin.String? = null
        /**
         * The name of the recommender.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the recipe that the recommender will use. For a recommender, a recipe is a Domain dataset group use case. Only Domain dataset group use cases can be used to create a recommender. For information about use cases see [Choosing recommender use cases](https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html).
         */
        public var recipeArn: kotlin.String? = null
        /**
         * The configuration details of the recommender.
         */
        public var recommenderConfig: aws.sdk.kotlin.services.personalize.model.RecommenderConfig? = null
        /**
         * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) to apply to the recommender.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.CreateRecommenderRequest) : this() {
            this.datasetGroupArn = x.datasetGroupArn
            this.name = x.name
            this.recipeArn = x.recipeArn
            this.recommenderConfig = x.recommenderConfig
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.CreateRecommenderRequest = CreateRecommenderRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.RecommenderConfig] inside the given [block]
         */
        public fun recommenderConfig(block: aws.sdk.kotlin.services.personalize.model.RecommenderConfig.Builder.() -> kotlin.Unit) {
            this.recommenderConfig = aws.sdk.kotlin.services.personalize.model.RecommenderConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
