// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateBatchInferenceJobRequest private constructor(builder: Builder) {
    /**
     * The configuration details of a batch inference job.
     */
    public val batchInferenceJobConfig: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobConfig? = builder.batchInferenceJobConfig
    /**
     * The mode of the batch inference job. To generate descriptive themes for groups of similar items, set the job mode to `THEME_GENERATION`. If you don't want to generate themes, use the default `BATCH_INFERENCE`.
     *
     *  When you get batch recommendations with themes, you will incur additional costs. For more information, see [Amazon Personalize pricing](https://aws.amazon.com/personalize/pricing/).
     */
    public val batchInferenceJobMode: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobMode? = builder.batchInferenceJobMode
    /**
     * The ARN of the filter to apply to the batch inference job. For more information on using filters, see [Filtering batch recommendations](https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html).
     */
    public val filterArn: kotlin.String? = builder.filterArn
    /**
     * The Amazon S3 path that leads to the input file to base your recommendations on. The input material must be in JSON format.
     */
    public val jobInput: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobInput? = builder.jobInput
    /**
     * The name of the batch inference job to create.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The path to the Amazon S3 bucket where the job's output will be stored.
     */
    public val jobOutput: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobOutput? = builder.jobOutput
    /**
     * The number of recommendations to retrieve.
     */
    public val numResults: kotlin.Int? = builder.numResults
    /**
     * The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input and output Amazon S3 buckets respectively.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The Amazon Resource Name (ARN) of the solution version that will be used to generate the batch inference recommendations.
     */
    public val solutionVersionArn: kotlin.String? = builder.solutionVersionArn
    /**
     * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) to apply to the batch inference job.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * For theme generation jobs, specify the name of the column in your Items dataset that contains each item's name.
     */
    public val themeGenerationConfig: aws.sdk.kotlin.services.personalize.model.ThemeGenerationConfig? = builder.themeGenerationConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.CreateBatchInferenceJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBatchInferenceJobRequest(")
        append("batchInferenceJobConfig=$batchInferenceJobConfig,")
        append("batchInferenceJobMode=$batchInferenceJobMode,")
        append("filterArn=$filterArn,")
        append("jobInput=$jobInput,")
        append("jobName=$jobName,")
        append("jobOutput=$jobOutput,")
        append("numResults=$numResults,")
        append("roleArn=$roleArn,")
        append("solutionVersionArn=$solutionVersionArn,")
        append("tags=$tags,")
        append("themeGenerationConfig=$themeGenerationConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchInferenceJobConfig?.hashCode() ?: 0
        result = 31 * result + (batchInferenceJobMode?.hashCode() ?: 0)
        result = 31 * result + (filterArn?.hashCode() ?: 0)
        result = 31 * result + (jobInput?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobOutput?.hashCode() ?: 0)
        result = 31 * result + (numResults ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (solutionVersionArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (themeGenerationConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBatchInferenceJobRequest

        if (batchInferenceJobConfig != other.batchInferenceJobConfig) return false
        if (batchInferenceJobMode != other.batchInferenceJobMode) return false
        if (filterArn != other.filterArn) return false
        if (jobInput != other.jobInput) return false
        if (jobName != other.jobName) return false
        if (jobOutput != other.jobOutput) return false
        if (numResults != other.numResults) return false
        if (roleArn != other.roleArn) return false
        if (solutionVersionArn != other.solutionVersionArn) return false
        if (tags != other.tags) return false
        if (themeGenerationConfig != other.themeGenerationConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.CreateBatchInferenceJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration details of a batch inference job.
         */
        public var batchInferenceJobConfig: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobConfig? = null
        /**
         * The mode of the batch inference job. To generate descriptive themes for groups of similar items, set the job mode to `THEME_GENERATION`. If you don't want to generate themes, use the default `BATCH_INFERENCE`.
         *
         *  When you get batch recommendations with themes, you will incur additional costs. For more information, see [Amazon Personalize pricing](https://aws.amazon.com/personalize/pricing/).
         */
        public var batchInferenceJobMode: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobMode? = null
        /**
         * The ARN of the filter to apply to the batch inference job. For more information on using filters, see [Filtering batch recommendations](https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html).
         */
        public var filterArn: kotlin.String? = null
        /**
         * The Amazon S3 path that leads to the input file to base your recommendations on. The input material must be in JSON format.
         */
        public var jobInput: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobInput? = null
        /**
         * The name of the batch inference job to create.
         */
        public var jobName: kotlin.String? = null
        /**
         * The path to the Amazon S3 bucket where the job's output will be stored.
         */
        public var jobOutput: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobOutput? = null
        /**
         * The number of recommendations to retrieve.
         */
        public var numResults: kotlin.Int? = null
        /**
         * The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input and output Amazon S3 buckets respectively.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the solution version that will be used to generate the batch inference recommendations.
         */
        public var solutionVersionArn: kotlin.String? = null
        /**
         * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) to apply to the batch inference job.
         */
        public var tags: List<Tag>? = null
        /**
         * For theme generation jobs, specify the name of the column in your Items dataset that contains each item's name.
         */
        public var themeGenerationConfig: aws.sdk.kotlin.services.personalize.model.ThemeGenerationConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.CreateBatchInferenceJobRequest) : this() {
            this.batchInferenceJobConfig = x.batchInferenceJobConfig
            this.batchInferenceJobMode = x.batchInferenceJobMode
            this.filterArn = x.filterArn
            this.jobInput = x.jobInput
            this.jobName = x.jobName
            this.jobOutput = x.jobOutput
            this.numResults = x.numResults
            this.roleArn = x.roleArn
            this.solutionVersionArn = x.solutionVersionArn
            this.tags = x.tags
            this.themeGenerationConfig = x.themeGenerationConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.CreateBatchInferenceJobRequest = CreateBatchInferenceJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.BatchInferenceJobConfig] inside the given [block]
         */
        public fun batchInferenceJobConfig(block: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobConfig.Builder.() -> kotlin.Unit) {
            this.batchInferenceJobConfig = aws.sdk.kotlin.services.personalize.model.BatchInferenceJobConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.BatchInferenceJobInput] inside the given [block]
         */
        public fun jobInput(block: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobInput.Builder.() -> kotlin.Unit) {
            this.jobInput = aws.sdk.kotlin.services.personalize.model.BatchInferenceJobInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.BatchInferenceJobOutput] inside the given [block]
         */
        public fun jobOutput(block: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobOutput.Builder.() -> kotlin.Unit) {
            this.jobOutput = aws.sdk.kotlin.services.personalize.model.BatchInferenceJobOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.ThemeGenerationConfig] inside the given [block]
         */
        public fun themeGenerationConfig(block: aws.sdk.kotlin.services.personalize.model.ThemeGenerationConfig.Builder.() -> kotlin.Unit) {
            this.themeGenerationConfig = aws.sdk.kotlin.services.personalize.model.ThemeGenerationConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
