// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * After you create a solution, you can’t change its configuration. By default, all new solutions use automatic training. With automatic training, you incur training costs while your solution is active. You can't stop automatic training for a solution. To avoid unnecessary costs, make sure to delete the solution when you are finished. For information about training costs, see [Amazon Personalize pricing](https://aws.amazon.com/personalize/pricing/).
 *
 * An object that provides information about a solution. A solution includes the custom recipe, customized parameters, and trained models (Solution Versions) that Amazon Personalize uses to generate recommendations.
 *
 * After you create a solution, you can’t change its configuration. If you need to make changes, you can [clone the solution](https://docs.aws.amazon.com/personalize/latest/dg/cloning-solution.html) with the Amazon Personalize console or create a new one.
 */
public class Solution private constructor(builder: Builder) {
    /**
     * When `performAutoML` is true, specifies the best recipe found.
     */
    public val autoMlResult: aws.sdk.kotlin.services.personalize.model.AutoMlResult? = builder.autoMlResult
    /**
     * The creation date and time (in Unix time) of the solution.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
     */
    public val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * The event type (for example, 'click' or 'like') that is used for training the model. If no `eventType` is provided, Amazon Personalize uses all interactions for training with equal weight regardless of type.
     */
    public val eventType: kotlin.String? = builder.eventType
    /**
     * The date and time (in Unix time) that the solution was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * Describes the latest version of the solution, including the status and the ARN.
     */
    public val latestSolutionVersion: aws.sdk.kotlin.services.personalize.model.SolutionVersionSummary? = builder.latestSolutionVersion
    /**
     * The name of the solution.
     */
    public val name: kotlin.String? = builder.name
    /**
     * We don't recommend enabling automated machine learning. Instead, match your use case to the available Amazon Personalize recipes. For more information, see [Determining your use case.](https://docs.aws.amazon.com/personalize/latest/dg/determining-use-case.html)
     *
     * When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration (`recipeArn` must not be specified). When false (the default), Amazon Personalize uses `recipeArn` for training.
     */
    public val performAutoMl: kotlin.Boolean = builder.performAutoMl
    /**
     * Specifies whether the solution automatically creates solution versions. The default is `True` and the solution automatically creates new solution versions every 7 days.
     *
     * For more information about auto training, see [Creating and configuring a solution](https://docs.aws.amazon.com/personalize/latest/dg/customizing-solution-config.html).
     */
    public val performAutoTraining: kotlin.Boolean? = builder.performAutoTraining
    /**
     * Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is `false`.
     */
    public val performHpo: kotlin.Boolean = builder.performHpo
    /**
     * The ARN of the recipe used to create the solution. This is required when `performAutoML` is false.
     */
    public val recipeArn: kotlin.String? = builder.recipeArn
    /**
     * The ARN of the solution.
     */
    public val solutionArn: kotlin.String? = builder.solutionArn
    /**
     * Describes the configuration properties for the solution.
     */
    public val solutionConfig: aws.sdk.kotlin.services.personalize.model.SolutionConfig? = builder.solutionConfig
    /**
     * The status of the solution.
     *
     * A solution can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.Solution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Solution(")
        append("autoMlResult=$autoMlResult,")
        append("creationDateTime=$creationDateTime,")
        append("datasetGroupArn=$datasetGroupArn,")
        append("eventType=$eventType,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("latestSolutionVersion=$latestSolutionVersion,")
        append("name=$name,")
        append("performAutoMl=$performAutoMl,")
        append("performAutoTraining=$performAutoTraining,")
        append("performHpo=$performHpo,")
        append("recipeArn=$recipeArn,")
        append("solutionArn=$solutionArn,")
        append("solutionConfig=$solutionConfig,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoMlResult?.hashCode() ?: 0
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (datasetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (eventType?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (latestSolutionVersion?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (performAutoMl.hashCode())
        result = 31 * result + (performAutoTraining?.hashCode() ?: 0)
        result = 31 * result + (performHpo.hashCode())
        result = 31 * result + (recipeArn?.hashCode() ?: 0)
        result = 31 * result + (solutionArn?.hashCode() ?: 0)
        result = 31 * result + (solutionConfig?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Solution

        if (autoMlResult != other.autoMlResult) return false
        if (creationDateTime != other.creationDateTime) return false
        if (datasetGroupArn != other.datasetGroupArn) return false
        if (eventType != other.eventType) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (latestSolutionVersion != other.latestSolutionVersion) return false
        if (name != other.name) return false
        if (performAutoMl != other.performAutoMl) return false
        if (performAutoTraining != other.performAutoTraining) return false
        if (performHpo != other.performHpo) return false
        if (recipeArn != other.recipeArn) return false
        if (solutionArn != other.solutionArn) return false
        if (solutionConfig != other.solutionConfig) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.Solution = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When `performAutoML` is true, specifies the best recipe found.
         */
        public var autoMlResult: aws.sdk.kotlin.services.personalize.model.AutoMlResult? = null
        /**
         * The creation date and time (in Unix time) of the solution.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
         */
        public var datasetGroupArn: kotlin.String? = null
        /**
         * The event type (for example, 'click' or 'like') that is used for training the model. If no `eventType` is provided, Amazon Personalize uses all interactions for training with equal weight regardless of type.
         */
        public var eventType: kotlin.String? = null
        /**
         * The date and time (in Unix time) that the solution was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Describes the latest version of the solution, including the status and the ARN.
         */
        public var latestSolutionVersion: aws.sdk.kotlin.services.personalize.model.SolutionVersionSummary? = null
        /**
         * The name of the solution.
         */
        public var name: kotlin.String? = null
        /**
         * We don't recommend enabling automated machine learning. Instead, match your use case to the available Amazon Personalize recipes. For more information, see [Determining your use case.](https://docs.aws.amazon.com/personalize/latest/dg/determining-use-case.html)
         *
         * When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration (`recipeArn` must not be specified). When false (the default), Amazon Personalize uses `recipeArn` for training.
         */
        public var performAutoMl: kotlin.Boolean = false
        /**
         * Specifies whether the solution automatically creates solution versions. The default is `True` and the solution automatically creates new solution versions every 7 days.
         *
         * For more information about auto training, see [Creating and configuring a solution](https://docs.aws.amazon.com/personalize/latest/dg/customizing-solution-config.html).
         */
        public var performAutoTraining: kotlin.Boolean? = null
        /**
         * Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is `false`.
         */
        public var performHpo: kotlin.Boolean = false
        /**
         * The ARN of the recipe used to create the solution. This is required when `performAutoML` is false.
         */
        public var recipeArn: kotlin.String? = null
        /**
         * The ARN of the solution.
         */
        public var solutionArn: kotlin.String? = null
        /**
         * Describes the configuration properties for the solution.
         */
        public var solutionConfig: aws.sdk.kotlin.services.personalize.model.SolutionConfig? = null
        /**
         * The status of the solution.
         *
         * A solution can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         * + DELETE PENDING > DELETE IN_PROGRESS
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.Solution) : this() {
            this.autoMlResult = x.autoMlResult
            this.creationDateTime = x.creationDateTime
            this.datasetGroupArn = x.datasetGroupArn
            this.eventType = x.eventType
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.latestSolutionVersion = x.latestSolutionVersion
            this.name = x.name
            this.performAutoMl = x.performAutoMl
            this.performAutoTraining = x.performAutoTraining
            this.performHpo = x.performHpo
            this.recipeArn = x.recipeArn
            this.solutionArn = x.solutionArn
            this.solutionConfig = x.solutionConfig
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.Solution = Solution(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.AutoMlResult] inside the given [block]
         */
        public fun autoMlResult(block: aws.sdk.kotlin.services.personalize.model.AutoMlResult.Builder.() -> kotlin.Unit) {
            this.autoMlResult = aws.sdk.kotlin.services.personalize.model.AutoMlResult.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.SolutionVersionSummary] inside the given [block]
         */
        public fun latestSolutionVersion(block: aws.sdk.kotlin.services.personalize.model.SolutionVersionSummary.Builder.() -> kotlin.Unit) {
            this.latestSolutionVersion = aws.sdk.kotlin.services.personalize.model.SolutionVersionSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.SolutionConfig] inside the given [block]
         */
        public fun solutionConfig(block: aws.sdk.kotlin.services.personalize.model.SolutionConfig.Builder.() -> kotlin.Unit) {
            this.solutionConfig = aws.sdk.kotlin.services.personalize.model.SolutionConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
