// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information on a metric that a metric attribution reports on. For more information, see [Measuring impact of recommendations](https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html).
 */
public class MetricAttribute private constructor(builder: Builder) {
    /**
     * The metric's event type.
     */
    public val eventType: kotlin.String = requireNotNull(builder.eventType) { "A non-null value must be provided for eventType" }
    /**
     * The attribute's expression. Available functions are `SUM()` or `SAMPLECOUNT()`. For SUM() functions, provide the dataset type (either Interactions or Items) and column to sum as a parameter. For example SUM(Items.PRICE).
     */
    public val expression: kotlin.String = requireNotNull(builder.expression) { "A non-null value must be provided for expression" }
    /**
     * The metric's name. The name helps you identify the metric in Amazon CloudWatch or Amazon S3.
     */
    public val metricName: kotlin.String = requireNotNull(builder.metricName) { "A non-null value must be provided for metricName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.MetricAttribute = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricAttribute(")
        append("eventType=$eventType,")
        append("expression=$expression,")
        append("metricName=$metricName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventType.hashCode()
        result = 31 * result + (expression.hashCode())
        result = 31 * result + (metricName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricAttribute

        if (eventType != other.eventType) return false
        if (expression != other.expression) return false
        if (metricName != other.metricName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.MetricAttribute = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The metric's event type.
         */
        public var eventType: kotlin.String? = null
        /**
         * The attribute's expression. Available functions are `SUM()` or `SAMPLECOUNT()`. For SUM() functions, provide the dataset type (either Interactions or Items) and column to sum as a parameter. For example SUM(Items.PRICE).
         */
        public var expression: kotlin.String? = null
        /**
         * The metric's name. The name helps you identify the metric in Amazon CloudWatch or Amazon S3.
         */
        public var metricName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.MetricAttribute) : this() {
            this.eventType = x.eventType
            this.expression = x.expression
            this.metricName = x.metricName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.MetricAttribute = MetricAttribute(this)

        internal fun correctErrors(): Builder {
            if (eventType == null) eventType = ""
            if (expression == null) expression = ""
            if (metricName == null) metricName = ""
            return this
        }
    }
}
