// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a job that imports training data from a data source (Amazon S3 bucket) to an Amazon Personalize dataset. For more information, see [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html).
 *
 * A dataset import job can be in one of the following states:
 * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
 */
public class DatasetImportJob private constructor(builder: Builder) {
    /**
     * The creation date and time (in Unix time) of the dataset import job.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The Amazon S3 bucket that contains the training data to import.
     */
    public val dataSource: aws.sdk.kotlin.services.personalize.model.DataSource? = builder.dataSource
    /**
     * The Amazon Resource Name (ARN) of the dataset that receives the imported data.
     */
    public val datasetArn: kotlin.String? = builder.datasetArn
    /**
     * The ARN of the dataset import job.
     */
    public val datasetImportJobArn: kotlin.String? = builder.datasetImportJobArn
    /**
     * If a dataset import job fails, provides the reason why.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The import mode used by the dataset import job to import new records.
     */
    public val importMode: aws.sdk.kotlin.services.personalize.model.ImportMode? = builder.importMode
    /**
     * The name of the import job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The date and time (in Unix time) the dataset was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * Whether the job publishes metrics to Amazon S3 for a metric attribution.
     */
    public val publishAttributionMetricsToS3: kotlin.Boolean? = builder.publishAttributionMetricsToS3
    /**
     * The ARN of the IAM role that has permissions to read from the Amazon S3 data source.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The status of the dataset import job.
     *
     * A dataset import job can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.DatasetImportJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetImportJob(")
        append("creationDateTime=$creationDateTime,")
        append("dataSource=$dataSource,")
        append("datasetArn=$datasetArn,")
        append("datasetImportJobArn=$datasetImportJobArn,")
        append("failureReason=$failureReason,")
        append("importMode=$importMode,")
        append("jobName=$jobName,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("publishAttributionMetricsToS3=$publishAttributionMetricsToS3,")
        append("roleArn=$roleArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (datasetArn?.hashCode() ?: 0)
        result = 31 * result + (datasetImportJobArn?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (importMode?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (publishAttributionMetricsToS3?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetImportJob

        if (creationDateTime != other.creationDateTime) return false
        if (dataSource != other.dataSource) return false
        if (datasetArn != other.datasetArn) return false
        if (datasetImportJobArn != other.datasetImportJobArn) return false
        if (failureReason != other.failureReason) return false
        if (importMode != other.importMode) return false
        if (jobName != other.jobName) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (publishAttributionMetricsToS3 != other.publishAttributionMetricsToS3) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.DatasetImportJob = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The creation date and time (in Unix time) of the dataset import job.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon S3 bucket that contains the training data to import.
         */
        public var dataSource: aws.sdk.kotlin.services.personalize.model.DataSource? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset that receives the imported data.
         */
        public var datasetArn: kotlin.String? = null
        /**
         * The ARN of the dataset import job.
         */
        public var datasetImportJobArn: kotlin.String? = null
        /**
         * If a dataset import job fails, provides the reason why.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The import mode used by the dataset import job to import new records.
         */
        public var importMode: aws.sdk.kotlin.services.personalize.model.ImportMode? = null
        /**
         * The name of the import job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The date and time (in Unix time) the dataset was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Whether the job publishes metrics to Amazon S3 for a metric attribution.
         */
        public var publishAttributionMetricsToS3: kotlin.Boolean? = null
        /**
         * The ARN of the IAM role that has permissions to read from the Amazon S3 data source.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The status of the dataset import job.
         *
         * A dataset import job can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.DatasetImportJob) : this() {
            this.creationDateTime = x.creationDateTime
            this.dataSource = x.dataSource
            this.datasetArn = x.datasetArn
            this.datasetImportJobArn = x.datasetImportJobArn
            this.failureReason = x.failureReason
            this.importMode = x.importMode
            this.jobName = x.jobName
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.publishAttributionMetricsToS3 = x.publishAttributionMetricsToS3
            this.roleArn = x.roleArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.DatasetImportJob = DatasetImportJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.DataSource] inside the given [block]
         */
        public fun dataSource(block: aws.sdk.kotlin.services.personalize.model.DataSource.Builder.() -> kotlin.Unit) {
            this.dataSource = aws.sdk.kotlin.services.personalize.model.DataSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
