// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the data source that contains the data to upload to a dataset, or the list of records to delete from Amazon Personalize.
 */
public class DataSource private constructor(builder: Builder) {
    /**
     * For dataset import jobs, the path to the Amazon S3 bucket where the data that you want to upload to your dataset is stored. For data deletion jobs, the path to the Amazon S3 bucket that stores the list of records to delete.
     *
     *  For example:
     *
     * `s3://bucket-name/folder-name/fileName.csv`
     *
     * If your CSV files are in a folder in your Amazon S3 bucket and you want your import job or data deletion job to consider multiple files, you can specify the path to the folder. With a data deletion job, Amazon Personalize uses all files in the folder and any sub folder. Use the following syntax with a `/` after the folder name:
     *
     * `s3://bucket-name/folder-name/`
     */
    public val dataLocation: kotlin.String? = builder.dataLocation

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.DataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSource(")
        append("dataLocation=$dataLocation")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataLocation?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSource

        if (dataLocation != other.dataLocation) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.DataSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * For dataset import jobs, the path to the Amazon S3 bucket where the data that you want to upload to your dataset is stored. For data deletion jobs, the path to the Amazon S3 bucket that stores the list of records to delete.
         *
         *  For example:
         *
         * `s3://bucket-name/folder-name/fileName.csv`
         *
         * If your CSV files are in a folder in your Amazon S3 bucket and you want your import job or data deletion job to consider multiple files, you can specify the path to the folder. With a data deletion job, Amazon Personalize uses all files in the folder and any sub folder. Use the following syntax with a `/` after the folder name:
         *
         * `s3://bucket-name/folder-name/`
         */
        public var dataLocation: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.DataSource) : this() {
            this.dataLocation = x.dataLocation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.DataSource = DataSource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
