// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the properties of a data deletion job. For a complete listing, call the [DescribeDataDeletionJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataDeletionJob.html) API operation.
 */
public class DataDeletionJobSummary private constructor(builder: Builder) {
    /**
     * The creation date and time (in Unix time) of the data deletion job.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The Amazon Resource Name (ARN) of the data deletion job.
     */
    public val dataDeletionJobArn: kotlin.String? = builder.dataDeletionJobArn
    /**
     * The Amazon Resource Name (ARN) of the dataset group the job deleted records from.
     */
    public val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * If a data deletion job fails, provides the reason why.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The name of the data deletion job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The date and time (in Unix time) the data deletion job was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The status of the data deletion job.
     *
     * A data deletion job can have one of the following statuses:
     * + PENDING > IN_PROGRESS > COMPLETED -or- FAILED
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.DataDeletionJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataDeletionJobSummary(")
        append("creationDateTime=$creationDateTime,")
        append("dataDeletionJobArn=$dataDeletionJobArn,")
        append("datasetGroupArn=$datasetGroupArn,")
        append("failureReason=$failureReason,")
        append("jobName=$jobName,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (dataDeletionJobArn?.hashCode() ?: 0)
        result = 31 * result + (datasetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataDeletionJobSummary

        if (creationDateTime != other.creationDateTime) return false
        if (dataDeletionJobArn != other.dataDeletionJobArn) return false
        if (datasetGroupArn != other.datasetGroupArn) return false
        if (failureReason != other.failureReason) return false
        if (jobName != other.jobName) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.DataDeletionJobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The creation date and time (in Unix time) of the data deletion job.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the data deletion job.
         */
        public var dataDeletionJobArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset group the job deleted records from.
         */
        public var datasetGroupArn: kotlin.String? = null
        /**
         * If a data deletion job fails, provides the reason why.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The name of the data deletion job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The date and time (in Unix time) the data deletion job was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the data deletion job.
         *
         * A data deletion job can have one of the following statuses:
         * + PENDING > IN_PROGRESS > COMPLETED -or- FAILED
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.DataDeletionJobSummary) : this() {
            this.creationDateTime = x.creationDateTime
            this.dataDeletionJobArn = x.dataDeletionJobArn
            this.datasetGroupArn = x.datasetGroupArn
            this.failureReason = x.failureReason
            this.jobName = x.jobName
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.DataDeletionJobSummary = DataDeletionJobSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
