// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a job that deletes all references to specific users from an Amazon Personalize dataset group in batches. For information about creating a data deletion job, see [Deleting users](https://docs.aws.amazon.com/personalize/latest/dg/delete-records.html).
 */
public class DataDeletionJob private constructor(builder: Builder) {
    /**
     * The creation date and time (in Unix time) of the data deletion job.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The Amazon Resource Name (ARN) of the data deletion job.
     */
    public val dataDeletionJobArn: kotlin.String? = builder.dataDeletionJobArn
    /**
     * Describes the data source that contains the data to upload to a dataset, or the list of records to delete from Amazon Personalize.
     */
    public val dataSource: aws.sdk.kotlin.services.personalize.model.DataSource? = builder.dataSource
    /**
     * The Amazon Resource Name (ARN) of the dataset group the job deletes records from.
     */
    public val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * If a data deletion job fails, provides the reason why.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The name of the data deletion job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The date and time (in Unix time) the data deletion job was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The number of records deleted by a COMPLETED job.
     */
    public val numDeleted: kotlin.Int? = builder.numDeleted
    /**
     * The Amazon Resource Name (ARN) of the IAM role that has permissions to read from the Amazon S3 data source.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The status of the data deletion job.
     *
     * A data deletion job can have one of the following statuses:
     * + PENDING > IN_PROGRESS > COMPLETED -or- FAILED
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.DataDeletionJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataDeletionJob(")
        append("creationDateTime=$creationDateTime,")
        append("dataDeletionJobArn=$dataDeletionJobArn,")
        append("dataSource=$dataSource,")
        append("datasetGroupArn=$datasetGroupArn,")
        append("failureReason=$failureReason,")
        append("jobName=$jobName,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("numDeleted=$numDeleted,")
        append("roleArn=$roleArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (dataDeletionJobArn?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (datasetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (numDeleted ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataDeletionJob

        if (creationDateTime != other.creationDateTime) return false
        if (dataDeletionJobArn != other.dataDeletionJobArn) return false
        if (dataSource != other.dataSource) return false
        if (datasetGroupArn != other.datasetGroupArn) return false
        if (failureReason != other.failureReason) return false
        if (jobName != other.jobName) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (numDeleted != other.numDeleted) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.DataDeletionJob = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The creation date and time (in Unix time) of the data deletion job.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the data deletion job.
         */
        public var dataDeletionJobArn: kotlin.String? = null
        /**
         * Describes the data source that contains the data to upload to a dataset, or the list of records to delete from Amazon Personalize.
         */
        public var dataSource: aws.sdk.kotlin.services.personalize.model.DataSource? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset group the job deletes records from.
         */
        public var datasetGroupArn: kotlin.String? = null
        /**
         * If a data deletion job fails, provides the reason why.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The name of the data deletion job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The date and time (in Unix time) the data deletion job was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of records deleted by a COMPLETED job.
         */
        public var numDeleted: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that has permissions to read from the Amazon S3 data source.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The status of the data deletion job.
         *
         * A data deletion job can have one of the following statuses:
         * + PENDING > IN_PROGRESS > COMPLETED -or- FAILED
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.DataDeletionJob) : this() {
            this.creationDateTime = x.creationDateTime
            this.dataDeletionJobArn = x.dataDeletionJobArn
            this.dataSource = x.dataSource
            this.datasetGroupArn = x.datasetGroupArn
            this.failureReason = x.failureReason
            this.jobName = x.jobName
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.numDeleted = x.numDeleted
            this.roleArn = x.roleArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.DataDeletionJob = DataDeletionJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.DataSource] inside the given [block]
         */
        public fun dataSource(block: aws.sdk.kotlin.services.personalize.model.DataSource.Builder.() -> kotlin.Unit) {
            this.dataSource = aws.sdk.kotlin.services.personalize.model.DataSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
