// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateSolutionRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
     */
    public val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * When your have multiple event types (using an `EVENT_TYPE` schema field), this parameter specifies which event type (for example, 'click' or 'like') is used for training the model.
     *
     * If you do not provide an `eventType`, Amazon Personalize will use all interactions for training with equal weight regardless of type.
     */
    public val eventType: kotlin.String? = builder.eventType
    /**
     * The name for the solution.
     */
    public val name: kotlin.String? = builder.name
    /**
     * We don't recommend enabling automated machine learning. Instead, match your use case to the available Amazon Personalize recipes. For more information, see [Choosing a recipe](https://docs.aws.amazon.com/personalize/latest/dg/working-with-predefined-recipes.html).
     *
     * Whether to perform automated machine learning (AutoML). The default is `false`. For this case, you must specify `recipeArn`.
     *
     * When set to `true`, Amazon Personalize analyzes your training data and selects the optimal USER_PERSONALIZATION recipe and hyperparameters. In this case, you must omit `recipeArn`. Amazon Personalize determines the optimal recipe by running tests with different values for the hyperparameters. AutoML lengthens the training process as compared to selecting a specific recipe.
     */
    public val performAutoMl: kotlin.Boolean? = builder.performAutoMl
    /**
     * Whether the solution uses automatic training to create new solution versions (trained models). The default is `True` and the solution automatically creates new solution versions every 7 days. You can change the training frequency by specifying a `schedulingExpression` in the `AutoTrainingConfig` as part of solution configuration. For more information about automatic training, see [Configuring automatic training](https://docs.aws.amazon.com/personalize/latest/dg/solution-config-auto-training.html).
     *
     *  Automatic solution version creation starts one hour after the solution is ACTIVE. If you manually create a solution version within the hour, the solution skips the first automatic training.
     *
     *  After training starts, you can get the solution version's Amazon Resource Name (ARN) with the [ListSolutionVersions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html) API operation. To get its status, use the [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html).
     */
    public val performAutoTraining: kotlin.Boolean? = builder.performAutoTraining
    /**
     * Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe. The default is `false`.
     *
     * When performing AutoML, this parameter is always `true` and you should not set it to `false`.
     */
    public val performHpo: kotlin.Boolean? = builder.performHpo
    /**
     * The Amazon Resource Name (ARN) of the recipe to use for model training. This is required when `performAutoML` is false. For information about different Amazon Personalize recipes and their ARNs, see [Choosing a recipe](https://docs.aws.amazon.com/personalize/latest/dg/working-with-predefined-recipes.html).
     */
    public val recipeArn: kotlin.String? = builder.recipeArn
    /**
     * The configuration to use with the solution. When `performAutoML` is set to true, Amazon Personalize only evaluates the `autoMLConfig` section of the solution configuration.
     *
     * Amazon Personalize doesn't support configuring the `hpoObjective` at this time.
     */
    public val solutionConfig: aws.sdk.kotlin.services.personalize.model.SolutionConfig? = builder.solutionConfig
    /**
     * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) to apply to the solution.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.CreateSolutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSolutionRequest(")
        append("datasetGroupArn=$datasetGroupArn,")
        append("eventType=$eventType,")
        append("name=$name,")
        append("performAutoMl=$performAutoMl,")
        append("performAutoTraining=$performAutoTraining,")
        append("performHpo=$performHpo,")
        append("recipeArn=$recipeArn,")
        append("solutionConfig=$solutionConfig,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = datasetGroupArn?.hashCode() ?: 0
        result = 31 * result + (eventType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (performAutoMl?.hashCode() ?: 0)
        result = 31 * result + (performAutoTraining?.hashCode() ?: 0)
        result = 31 * result + (performHpo?.hashCode() ?: 0)
        result = 31 * result + (recipeArn?.hashCode() ?: 0)
        result = 31 * result + (solutionConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSolutionRequest

        if (datasetGroupArn != other.datasetGroupArn) return false
        if (eventType != other.eventType) return false
        if (name != other.name) return false
        if (performAutoMl != other.performAutoMl) return false
        if (performAutoTraining != other.performAutoTraining) return false
        if (performHpo != other.performHpo) return false
        if (recipeArn != other.recipeArn) return false
        if (solutionConfig != other.solutionConfig) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.CreateSolutionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
         */
        public var datasetGroupArn: kotlin.String? = null
        /**
         * When your have multiple event types (using an `EVENT_TYPE` schema field), this parameter specifies which event type (for example, 'click' or 'like') is used for training the model.
         *
         * If you do not provide an `eventType`, Amazon Personalize will use all interactions for training with equal weight regardless of type.
         */
        public var eventType: kotlin.String? = null
        /**
         * The name for the solution.
         */
        public var name: kotlin.String? = null
        /**
         * We don't recommend enabling automated machine learning. Instead, match your use case to the available Amazon Personalize recipes. For more information, see [Choosing a recipe](https://docs.aws.amazon.com/personalize/latest/dg/working-with-predefined-recipes.html).
         *
         * Whether to perform automated machine learning (AutoML). The default is `false`. For this case, you must specify `recipeArn`.
         *
         * When set to `true`, Amazon Personalize analyzes your training data and selects the optimal USER_PERSONALIZATION recipe and hyperparameters. In this case, you must omit `recipeArn`. Amazon Personalize determines the optimal recipe by running tests with different values for the hyperparameters. AutoML lengthens the training process as compared to selecting a specific recipe.
         */
        public var performAutoMl: kotlin.Boolean? = null
        /**
         * Whether the solution uses automatic training to create new solution versions (trained models). The default is `True` and the solution automatically creates new solution versions every 7 days. You can change the training frequency by specifying a `schedulingExpression` in the `AutoTrainingConfig` as part of solution configuration. For more information about automatic training, see [Configuring automatic training](https://docs.aws.amazon.com/personalize/latest/dg/solution-config-auto-training.html).
         *
         *  Automatic solution version creation starts one hour after the solution is ACTIVE. If you manually create a solution version within the hour, the solution skips the first automatic training.
         *
         *  After training starts, you can get the solution version's Amazon Resource Name (ARN) with the [ListSolutionVersions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html) API operation. To get its status, use the [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html).
         */
        public var performAutoTraining: kotlin.Boolean? = null
        /**
         * Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe. The default is `false`.
         *
         * When performing AutoML, this parameter is always `true` and you should not set it to `false`.
         */
        public var performHpo: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the recipe to use for model training. This is required when `performAutoML` is false. For information about different Amazon Personalize recipes and their ARNs, see [Choosing a recipe](https://docs.aws.amazon.com/personalize/latest/dg/working-with-predefined-recipes.html).
         */
        public var recipeArn: kotlin.String? = null
        /**
         * The configuration to use with the solution. When `performAutoML` is set to true, Amazon Personalize only evaluates the `autoMLConfig` section of the solution configuration.
         *
         * Amazon Personalize doesn't support configuring the `hpoObjective` at this time.
         */
        public var solutionConfig: aws.sdk.kotlin.services.personalize.model.SolutionConfig? = null
        /**
         * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) to apply to the solution.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.CreateSolutionRequest) : this() {
            this.datasetGroupArn = x.datasetGroupArn
            this.eventType = x.eventType
            this.name = x.name
            this.performAutoMl = x.performAutoMl
            this.performAutoTraining = x.performAutoTraining
            this.performHpo = x.performHpo
            this.recipeArn = x.recipeArn
            this.solutionConfig = x.solutionConfig
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.CreateSolutionRequest = CreateSolutionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.SolutionConfig] inside the given [block]
         */
        public fun solutionConfig(block: aws.sdk.kotlin.services.personalize.model.SolutionConfig.Builder.() -> kotlin.Unit) {
            this.solutionConfig = aws.sdk.kotlin.services.personalize.model.SolutionConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
