// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the properties of a campaign update. For a complete listing, call the [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html) API.
 */
public class CampaignUpdateSummary private constructor(builder: Builder) {
    /**
     * The configuration details of a campaign.
     */
    public val campaignConfig: aws.sdk.kotlin.services.personalize.model.CampaignConfig? = builder.campaignConfig
    /**
     * The date and time (in Unix time) that the campaign update was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * If a campaign update fails, the reason behind the failure.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The date and time (in Unix time) that the campaign update was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize will support.
     */
    public val minProvisionedTps: kotlin.Int? = builder.minProvisionedTps
    /**
     * The Amazon Resource Name (ARN) of the deployed solution version.
     */
    public val solutionVersionArn: kotlin.String? = builder.solutionVersionArn
    /**
     * The status of the campaign update.
     *
     * A campaign update can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.CampaignUpdateSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CampaignUpdateSummary(")
        append("campaignConfig=$campaignConfig,")
        append("creationDateTime=$creationDateTime,")
        append("failureReason=$failureReason,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("minProvisionedTps=$minProvisionedTps,")
        append("solutionVersionArn=$solutionVersionArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = campaignConfig?.hashCode() ?: 0
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (minProvisionedTps ?: 0)
        result = 31 * result + (solutionVersionArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CampaignUpdateSummary

        if (campaignConfig != other.campaignConfig) return false
        if (creationDateTime != other.creationDateTime) return false
        if (failureReason != other.failureReason) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (minProvisionedTps != other.minProvisionedTps) return false
        if (solutionVersionArn != other.solutionVersionArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.CampaignUpdateSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration details of a campaign.
         */
        public var campaignConfig: aws.sdk.kotlin.services.personalize.model.CampaignConfig? = null
        /**
         * The date and time (in Unix time) that the campaign update was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If a campaign update fails, the reason behind the failure.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The date and time (in Unix time) that the campaign update was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize will support.
         */
        public var minProvisionedTps: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the deployed solution version.
         */
        public var solutionVersionArn: kotlin.String? = null
        /**
         * The status of the campaign update.
         *
         * A campaign update can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         * + DELETE PENDING > DELETE IN_PROGRESS
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.CampaignUpdateSummary) : this() {
            this.campaignConfig = x.campaignConfig
            this.creationDateTime = x.creationDateTime
            this.failureReason = x.failureReason
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.minProvisionedTps = x.minProvisionedTps
            this.solutionVersionArn = x.solutionVersionArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.CampaignUpdateSummary = CampaignUpdateSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.CampaignConfig] inside the given [block]
         */
        public fun campaignConfig(block: aws.sdk.kotlin.services.personalize.model.CampaignConfig.Builder.() -> kotlin.Unit) {
            this.campaignConfig = aws.sdk.kotlin.services.personalize.model.CampaignConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
