// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration details of a campaign.
 */
public class CampaignConfig private constructor(builder: Builder) {
    /**
     * Whether metadata with recommendations is enabled for the campaign. If enabled, you can specify the columns from your Items dataset in your request for recommendations. Amazon Personalize returns this data for each item in the recommendation response. For information about enabling metadata for a campaign, see [Enabling metadata in recommendations for a campaign](https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata).
     *
     *  If you enable metadata in recommendations, you will incur additional costs. For more information, see [Amazon Personalize pricing](https://aws.amazon.com/personalize/pricing/).
     */
    public val enableMetadataWithRecommendations: kotlin.Boolean? = builder.enableMetadataWithRecommendations
    /**
     * Specifies the exploration configuration hyperparameters, including `explorationWeight` and `explorationItemAgeCutOff`, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide `itemExplorationConfig` data only if your solution uses the [User-Personalization](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html) recipe.
     */
    public val itemExplorationConfig: Map<String, String>? = builder.itemExplorationConfig
    /**
     * Whether the campaign automatically updates to use the latest solution version (trained model) of a solution. If you specify `True`, you must specify the ARN of your *solution* for the `SolutionVersionArn` parameter. It must be in `SolutionArn/$LATEST` format. The default is `False` and you must manually update the campaign to deploy the latest solution version.
     *
     *  For more information about automatic campaign updates, see [Enabling automatic campaign updates](https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update).
     */
    public val syncWithLatestSolutionVersion: kotlin.Boolean? = builder.syncWithLatestSolutionVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.CampaignConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CampaignConfig(")
        append("enableMetadataWithRecommendations=$enableMetadataWithRecommendations,")
        append("itemExplorationConfig=$itemExplorationConfig,")
        append("syncWithLatestSolutionVersion=$syncWithLatestSolutionVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableMetadataWithRecommendations?.hashCode() ?: 0
        result = 31 * result + (itemExplorationConfig?.hashCode() ?: 0)
        result = 31 * result + (syncWithLatestSolutionVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CampaignConfig

        if (enableMetadataWithRecommendations != other.enableMetadataWithRecommendations) return false
        if (itemExplorationConfig != other.itemExplorationConfig) return false
        if (syncWithLatestSolutionVersion != other.syncWithLatestSolutionVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.CampaignConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether metadata with recommendations is enabled for the campaign. If enabled, you can specify the columns from your Items dataset in your request for recommendations. Amazon Personalize returns this data for each item in the recommendation response. For information about enabling metadata for a campaign, see [Enabling metadata in recommendations for a campaign](https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata).
         *
         *  If you enable metadata in recommendations, you will incur additional costs. For more information, see [Amazon Personalize pricing](https://aws.amazon.com/personalize/pricing/).
         */
        public var enableMetadataWithRecommendations: kotlin.Boolean? = null
        /**
         * Specifies the exploration configuration hyperparameters, including `explorationWeight` and `explorationItemAgeCutOff`, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide `itemExplorationConfig` data only if your solution uses the [User-Personalization](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html) recipe.
         */
        public var itemExplorationConfig: Map<String, String>? = null
        /**
         * Whether the campaign automatically updates to use the latest solution version (trained model) of a solution. If you specify `True`, you must specify the ARN of your *solution* for the `SolutionVersionArn` parameter. It must be in `SolutionArn/$LATEST` format. The default is `False` and you must manually update the campaign to deploy the latest solution version.
         *
         *  For more information about automatic campaign updates, see [Enabling automatic campaign updates](https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update).
         */
        public var syncWithLatestSolutionVersion: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.CampaignConfig) : this() {
            this.enableMetadataWithRecommendations = x.enableMetadataWithRecommendations
            this.itemExplorationConfig = x.itemExplorationConfig
            this.syncWithLatestSolutionVersion = x.syncWithLatestSolutionVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.CampaignConfig = CampaignConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
