// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model



/**
 * The configuration details of the recommender.
 */
public class RecommenderConfig private constructor(builder: Builder) {
    /**
     * Whether metadata with recommendations is enabled for the recommender. If enabled, you can specify the columns from your Items dataset in your request for recommendations. Amazon Personalize returns this data for each item in the recommendation response.
     *
     *  If you enable metadata in recommendations, you will incur additional costs. For more information, see [Amazon Personalize pricing](https://aws.amazon.com/personalize/pricing/).
     */
    public val enableMetadataWithRecommendations: kotlin.Boolean? = builder.enableMetadataWithRecommendations
    /**
     * Specifies the exploration configuration hyperparameters, including `explorationWeight` and `explorationItemAgeCutOff`, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide `itemExplorationConfig` data only if your recommenders generate personalized recommendations for a user (not popular items or similar items).
     */
    public val itemExplorationConfig: Map<String, String>? = builder.itemExplorationConfig
    /**
     * Specifies the requested minimum provisioned recommendation requests per second that Amazon Personalize will support. A high `minRecommendationRequestsPerSecond` will increase your bill. We recommend starting with 1 for `minRecommendationRequestsPerSecond` (the default). Track your usage using Amazon CloudWatch metrics, and increase the `minRecommendationRequestsPerSecond` as necessary.
     */
    public val minRecommendationRequestsPerSecond: kotlin.Int? = builder.minRecommendationRequestsPerSecond
    /**
     * Specifies the training data configuration to use when creating a domain recommender.
     */
    public val trainingDataConfig: aws.sdk.kotlin.services.personalize.model.TrainingDataConfig? = builder.trainingDataConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.RecommenderConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommenderConfig(")
        append("enableMetadataWithRecommendations=$enableMetadataWithRecommendations,")
        append("itemExplorationConfig=$itemExplorationConfig,")
        append("minRecommendationRequestsPerSecond=$minRecommendationRequestsPerSecond,")
        append("trainingDataConfig=$trainingDataConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableMetadataWithRecommendations?.hashCode() ?: 0
        result = 31 * result + (itemExplorationConfig?.hashCode() ?: 0)
        result = 31 * result + (minRecommendationRequestsPerSecond ?: 0)
        result = 31 * result + (trainingDataConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommenderConfig

        if (enableMetadataWithRecommendations != other.enableMetadataWithRecommendations) return false
        if (itemExplorationConfig != other.itemExplorationConfig) return false
        if (minRecommendationRequestsPerSecond != other.minRecommendationRequestsPerSecond) return false
        if (trainingDataConfig != other.trainingDataConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.RecommenderConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Whether metadata with recommendations is enabled for the recommender. If enabled, you can specify the columns from your Items dataset in your request for recommendations. Amazon Personalize returns this data for each item in the recommendation response.
         *
         *  If you enable metadata in recommendations, you will incur additional costs. For more information, see [Amazon Personalize pricing](https://aws.amazon.com/personalize/pricing/).
         */
        public var enableMetadataWithRecommendations: kotlin.Boolean? = null
        /**
         * Specifies the exploration configuration hyperparameters, including `explorationWeight` and `explorationItemAgeCutOff`, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide `itemExplorationConfig` data only if your recommenders generate personalized recommendations for a user (not popular items or similar items).
         */
        public var itemExplorationConfig: Map<String, String>? = null
        /**
         * Specifies the requested minimum provisioned recommendation requests per second that Amazon Personalize will support. A high `minRecommendationRequestsPerSecond` will increase your bill. We recommend starting with 1 for `minRecommendationRequestsPerSecond` (the default). Track your usage using Amazon CloudWatch metrics, and increase the `minRecommendationRequestsPerSecond` as necessary.
         */
        public var minRecommendationRequestsPerSecond: kotlin.Int? = null
        /**
         * Specifies the training data configuration to use when creating a domain recommender.
         */
        public var trainingDataConfig: aws.sdk.kotlin.services.personalize.model.TrainingDataConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.RecommenderConfig) : this() {
            this.enableMetadataWithRecommendations = x.enableMetadataWithRecommendations
            this.itemExplorationConfig = x.itemExplorationConfig
            this.minRecommendationRequestsPerSecond = x.minRecommendationRequestsPerSecond
            this.trainingDataConfig = x.trainingDataConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.RecommenderConfig = RecommenderConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.TrainingDataConfig] inside the given [block]
         */
        public fun trainingDataConfig(block: aws.sdk.kotlin.services.personalize.model.TrainingDataConfig.Builder.() -> kotlin.Unit) {
            this.trainingDataConfig = aws.sdk.kotlin.services.personalize.model.TrainingDataConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
