// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A dataset group is a collection of related datasets (Item interactions, Users, Items, Actions, Action interactions). You create a dataset group by calling [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html). You then create a dataset and add it to a dataset group by calling [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html). The dataset group is used to create and train a solution by calling [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html). A dataset group can contain only one of each type of dataset.
 *
 * You can specify an Key Management Service (KMS) key to encrypt the datasets in the group.
 */
public class DatasetGroup private constructor(builder: Builder) {
    /**
     * The creation date and time (in Unix time) of the dataset group.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The Amazon Resource Name (ARN) of the dataset group.
     */
    public val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * The domain of a Domain dataset group.
     */
    public val domain: aws.sdk.kotlin.services.personalize.model.Domain? = builder.domain
    /**
     * If creating a dataset group fails, provides the reason why.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the datasets.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The last update date and time (in Unix time) of the dataset group.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the dataset group.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management Service (KMS) key. Supplying an IAM role is only valid when also specifying a KMS key.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The current status of the dataset group.
     *
     * A dataset group can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.DatasetGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetGroup(")
        append("creationDateTime=$creationDateTime,")
        append("datasetGroupArn=$datasetGroupArn,")
        append("domain=$domain,")
        append("failureReason=$failureReason,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (datasetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetGroup

        if (creationDateTime != other.creationDateTime) return false
        if (datasetGroupArn != other.datasetGroupArn) return false
        if (domain != other.domain) return false
        if (failureReason != other.failureReason) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.DatasetGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The creation date and time (in Unix time) of the dataset group.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset group.
         */
        public var datasetGroupArn: kotlin.String? = null
        /**
         * The domain of a Domain dataset group.
         */
        public var domain: aws.sdk.kotlin.services.personalize.model.Domain? = null
        /**
         * If creating a dataset group fails, provides the reason why.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the datasets.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The last update date and time (in Unix time) of the dataset group.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the dataset group.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management Service (KMS) key. Supplying an IAM role is only valid when also specifying a KMS key.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The current status of the dataset group.
         *
         * A dataset group can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         * + DELETE PENDING
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.DatasetGroup) : this() {
            this.creationDateTime = x.creationDateTime
            this.datasetGroupArn = x.datasetGroupArn
            this.domain = x.domain
            this.failureReason = x.failureReason
            this.kmsKeyArn = x.kmsKeyArn
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.roleArn = x.roleArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.DatasetGroup = DatasetGroup(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
