// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model



public class CreateDatasetImportJobRequest private constructor(builder: Builder) {
    /**
     * The Amazon S3 bucket that contains the training data to import.
     */
    public val dataSource: aws.sdk.kotlin.services.personalize.model.DataSource? = builder.dataSource
    /**
     * The ARN of the dataset that receives the imported data.
     */
    public val datasetArn: kotlin.String? = builder.datasetArn
    /**
     * Specify how to add the new records to an existing dataset. The default import mode is `FULL`. If you haven't imported bulk records into the dataset previously, you can only specify `FULL`.
     * + Specify `FULL` to overwrite all existing bulk data in your dataset. Data you imported individually is not replaced.
     * + Specify `INCREMENTAL` to append the new records to the existing data in your dataset. Amazon Personalize replaces any record with the same ID with the new one.
     */
    public val importMode: aws.sdk.kotlin.services.personalize.model.ImportMode? = builder.importMode
    /**
     * The name for the dataset import job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * If you created a metric attribution, specify whether to publish metrics for this import job to Amazon S3
     */
    public val publishAttributionMetricsToS3: kotlin.Boolean? = builder.publishAttributionMetricsToS3
    /**
     * The ARN of the IAM role that has permissions to read from the Amazon S3 data source.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) to apply to the dataset import job.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.CreateDatasetImportJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDatasetImportJobRequest(")
        append("dataSource=$dataSource,")
        append("datasetArn=$datasetArn,")
        append("importMode=$importMode,")
        append("jobName=$jobName,")
        append("publishAttributionMetricsToS3=$publishAttributionMetricsToS3,")
        append("roleArn=$roleArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSource?.hashCode() ?: 0
        result = 31 * result + (datasetArn?.hashCode() ?: 0)
        result = 31 * result + (importMode?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (publishAttributionMetricsToS3?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDatasetImportJobRequest

        if (dataSource != other.dataSource) return false
        if (datasetArn != other.datasetArn) return false
        if (importMode != other.importMode) return false
        if (jobName != other.jobName) return false
        if (publishAttributionMetricsToS3 != other.publishAttributionMetricsToS3) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.CreateDatasetImportJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon S3 bucket that contains the training data to import.
         */
        public var dataSource: aws.sdk.kotlin.services.personalize.model.DataSource? = null
        /**
         * The ARN of the dataset that receives the imported data.
         */
        public var datasetArn: kotlin.String? = null
        /**
         * Specify how to add the new records to an existing dataset. The default import mode is `FULL`. If you haven't imported bulk records into the dataset previously, you can only specify `FULL`.
         * + Specify `FULL` to overwrite all existing bulk data in your dataset. Data you imported individually is not replaced.
         * + Specify `INCREMENTAL` to append the new records to the existing data in your dataset. Amazon Personalize replaces any record with the same ID with the new one.
         */
        public var importMode: aws.sdk.kotlin.services.personalize.model.ImportMode? = null
        /**
         * The name for the dataset import job.
         */
        public var jobName: kotlin.String? = null
        /**
         * If you created a metric attribution, specify whether to publish metrics for this import job to Amazon S3
         */
        public var publishAttributionMetricsToS3: kotlin.Boolean? = null
        /**
         * The ARN of the IAM role that has permissions to read from the Amazon S3 data source.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) to apply to the dataset import job.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.CreateDatasetImportJobRequest) : this() {
            this.dataSource = x.dataSource
            this.datasetArn = x.datasetArn
            this.importMode = x.importMode
            this.jobName = x.jobName
            this.publishAttributionMetricsToS3 = x.publishAttributionMetricsToS3
            this.roleArn = x.roleArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.CreateDatasetImportJobRequest = CreateDatasetImportJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.DataSource] inside the given [block]
         */
        public fun dataSource(block: aws.sdk.kotlin.services.personalize.model.DataSource.Builder.() -> kotlin.Unit) {
            this.dataSource = aws.sdk.kotlin.services.personalize.model.DataSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
