// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information on a batch inference job.
 */
public class BatchInferenceJob private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the batch inference job.
     */
    public val batchInferenceJobArn: kotlin.String? = builder.batchInferenceJobArn
    /**
     * A string to string map of the configuration details of a batch inference job.
     */
    public val batchInferenceJobConfig: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobConfig? = builder.batchInferenceJobConfig
    /**
     * The job's mode.
     */
    public val batchInferenceJobMode: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobMode? = builder.batchInferenceJobMode
    /**
     * The time at which the batch inference job was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * If the batch inference job failed, the reason for the failure.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The ARN of the filter used on the batch inference job.
     */
    public val filterArn: kotlin.String? = builder.filterArn
    /**
     * The Amazon S3 path that leads to the input data used to generate the batch inference job.
     */
    public val jobInput: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobInput? = builder.jobInput
    /**
     * The name of the batch inference job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The Amazon S3 bucket that contains the output data generated by the batch inference job.
     */
    public val jobOutput: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobOutput? = builder.jobOutput
    /**
     * The time at which the batch inference job was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The number of recommendations generated by the batch inference job. This number includes the error messages generated for failed input records.
     */
    public val numResults: kotlin.Int? = builder.numResults
    /**
     * The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch inference job.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The Amazon Resource Name (ARN) of the solution version from which the batch inference job was created.
     */
    public val solutionVersionArn: kotlin.String? = builder.solutionVersionArn
    /**
     * The status of the batch inference job. The status is one of the following values:
     * + PENDING
     * + IN PROGRESS
     * + ACTIVE
     * + CREATE FAILED
     */
    public val status: kotlin.String? = builder.status
    /**
     * The job's theme generation settings.
     */
    public val themeGenerationConfig: aws.sdk.kotlin.services.personalize.model.ThemeGenerationConfig? = builder.themeGenerationConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.BatchInferenceJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchInferenceJob(")
        append("batchInferenceJobArn=$batchInferenceJobArn,")
        append("batchInferenceJobConfig=$batchInferenceJobConfig,")
        append("batchInferenceJobMode=$batchInferenceJobMode,")
        append("creationDateTime=$creationDateTime,")
        append("failureReason=$failureReason,")
        append("filterArn=$filterArn,")
        append("jobInput=$jobInput,")
        append("jobName=$jobName,")
        append("jobOutput=$jobOutput,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("numResults=$numResults,")
        append("roleArn=$roleArn,")
        append("solutionVersionArn=$solutionVersionArn,")
        append("status=$status,")
        append("themeGenerationConfig=$themeGenerationConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchInferenceJobArn?.hashCode() ?: 0
        result = 31 * result + (batchInferenceJobConfig?.hashCode() ?: 0)
        result = 31 * result + (batchInferenceJobMode?.hashCode() ?: 0)
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (filterArn?.hashCode() ?: 0)
        result = 31 * result + (jobInput?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobOutput?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (numResults ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (solutionVersionArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (themeGenerationConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchInferenceJob

        if (batchInferenceJobArn != other.batchInferenceJobArn) return false
        if (batchInferenceJobConfig != other.batchInferenceJobConfig) return false
        if (batchInferenceJobMode != other.batchInferenceJobMode) return false
        if (creationDateTime != other.creationDateTime) return false
        if (failureReason != other.failureReason) return false
        if (filterArn != other.filterArn) return false
        if (jobInput != other.jobInput) return false
        if (jobName != other.jobName) return false
        if (jobOutput != other.jobOutput) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (numResults != other.numResults) return false
        if (roleArn != other.roleArn) return false
        if (solutionVersionArn != other.solutionVersionArn) return false
        if (status != other.status) return false
        if (themeGenerationConfig != other.themeGenerationConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.BatchInferenceJob = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the batch inference job.
         */
        public var batchInferenceJobArn: kotlin.String? = null
        /**
         * A string to string map of the configuration details of a batch inference job.
         */
        public var batchInferenceJobConfig: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobConfig? = null
        /**
         * The job's mode.
         */
        public var batchInferenceJobMode: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobMode? = null
        /**
         * The time at which the batch inference job was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the batch inference job failed, the reason for the failure.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The ARN of the filter used on the batch inference job.
         */
        public var filterArn: kotlin.String? = null
        /**
         * The Amazon S3 path that leads to the input data used to generate the batch inference job.
         */
        public var jobInput: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobInput? = null
        /**
         * The name of the batch inference job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The Amazon S3 bucket that contains the output data generated by the batch inference job.
         */
        public var jobOutput: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobOutput? = null
        /**
         * The time at which the batch inference job was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of recommendations generated by the batch inference job. This number includes the error messages generated for failed input records.
         */
        public var numResults: kotlin.Int? = null
        /**
         * The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch inference job.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the solution version from which the batch inference job was created.
         */
        public var solutionVersionArn: kotlin.String? = null
        /**
         * The status of the batch inference job. The status is one of the following values:
         * + PENDING
         * + IN PROGRESS
         * + ACTIVE
         * + CREATE FAILED
         */
        public var status: kotlin.String? = null
        /**
         * The job's theme generation settings.
         */
        public var themeGenerationConfig: aws.sdk.kotlin.services.personalize.model.ThemeGenerationConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.BatchInferenceJob) : this() {
            this.batchInferenceJobArn = x.batchInferenceJobArn
            this.batchInferenceJobConfig = x.batchInferenceJobConfig
            this.batchInferenceJobMode = x.batchInferenceJobMode
            this.creationDateTime = x.creationDateTime
            this.failureReason = x.failureReason
            this.filterArn = x.filterArn
            this.jobInput = x.jobInput
            this.jobName = x.jobName
            this.jobOutput = x.jobOutput
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.numResults = x.numResults
            this.roleArn = x.roleArn
            this.solutionVersionArn = x.solutionVersionArn
            this.status = x.status
            this.themeGenerationConfig = x.themeGenerationConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.BatchInferenceJob = BatchInferenceJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.BatchInferenceJobConfig] inside the given [block]
         */
        public fun batchInferenceJobConfig(block: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobConfig.Builder.() -> kotlin.Unit) {
            this.batchInferenceJobConfig = aws.sdk.kotlin.services.personalize.model.BatchInferenceJobConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.BatchInferenceJobInput] inside the given [block]
         */
        public fun jobInput(block: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobInput.Builder.() -> kotlin.Unit) {
            this.jobInput = aws.sdk.kotlin.services.personalize.model.BatchInferenceJobInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.BatchInferenceJobOutput] inside the given [block]
         */
        public fun jobOutput(block: aws.sdk.kotlin.services.personalize.model.BatchInferenceJobOutput.Builder.() -> kotlin.Unit) {
            this.jobOutput = aws.sdk.kotlin.services.personalize.model.BatchInferenceJobOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.ThemeGenerationConfig] inside the given [block]
         */
        public fun themeGenerationConfig(block: aws.sdk.kotlin.services.personalize.model.ThemeGenerationConfig.Builder.() -> kotlin.Unit) {
            this.themeGenerationConfig = aws.sdk.kotlin.services.personalize.model.ThemeGenerationConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
