// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.serde

import aws.sdk.kotlin.services.personalize.model.CreateSchemaResponse
import aws.sdk.kotlin.services.personalize.model.PersonalizeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateSchemaOperationDeserializer: HttpDeserialize<CreateSchemaResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateSchemaResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateSchemaError(context, call)
        }
        val builder = CreateSchemaResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateSchemaOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateSchemaError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw PersonalizeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> PersonalizeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateSchemaOperationBody(builder: CreateSchemaResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SCHEMAARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("schemaArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SCHEMAARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SCHEMAARN_DESCRIPTOR.index -> builder.schemaArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
