// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model



/**
 * Describes the properties for hyperparameter optimization (HPO).
 */
public class HpoConfig private constructor(builder: Builder) {
    /**
     * The hyperparameters and their allowable ranges.
     */
    public val algorithmHyperParameterRanges: aws.sdk.kotlin.services.personalize.model.HyperParameterRanges? = builder.algorithmHyperParameterRanges
    /**
     * The metric to optimize during HPO.
     *
     * Amazon Personalize doesn't support configuring the `hpoObjective` at this time.
     */
    public val hpoObjective: aws.sdk.kotlin.services.personalize.model.HpoObjective? = builder.hpoObjective
    /**
     * Describes the resource configuration for HPO.
     */
    public val hpoResourceConfig: aws.sdk.kotlin.services.personalize.model.HpoResourceConfig? = builder.hpoResourceConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.HpoConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HpoConfig(")
        append("algorithmHyperParameterRanges=$algorithmHyperParameterRanges,")
        append("hpoObjective=$hpoObjective,")
        append("hpoResourceConfig=$hpoResourceConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmHyperParameterRanges?.hashCode() ?: 0
        result = 31 * result + (hpoObjective?.hashCode() ?: 0)
        result = 31 * result + (hpoResourceConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HpoConfig

        if (algorithmHyperParameterRanges != other.algorithmHyperParameterRanges) return false
        if (hpoObjective != other.hpoObjective) return false
        if (hpoResourceConfig != other.hpoResourceConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.HpoConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The hyperparameters and their allowable ranges.
         */
        public var algorithmHyperParameterRanges: aws.sdk.kotlin.services.personalize.model.HyperParameterRanges? = null
        /**
         * The metric to optimize during HPO.
         *
         * Amazon Personalize doesn't support configuring the `hpoObjective` at this time.
         */
        public var hpoObjective: aws.sdk.kotlin.services.personalize.model.HpoObjective? = null
        /**
         * Describes the resource configuration for HPO.
         */
        public var hpoResourceConfig: aws.sdk.kotlin.services.personalize.model.HpoResourceConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.HpoConfig) : this() {
            this.algorithmHyperParameterRanges = x.algorithmHyperParameterRanges
            this.hpoObjective = x.hpoObjective
            this.hpoResourceConfig = x.hpoResourceConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.HpoConfig = HpoConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.HyperParameterRanges] inside the given [block]
         */
        public fun algorithmHyperParameterRanges(block: aws.sdk.kotlin.services.personalize.model.HyperParameterRanges.Builder.() -> kotlin.Unit) {
            this.algorithmHyperParameterRanges = aws.sdk.kotlin.services.personalize.model.HyperParameterRanges.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.HpoObjective] inside the given [block]
         */
        public fun hpoObjective(block: aws.sdk.kotlin.services.personalize.model.HpoObjective.Builder.() -> kotlin.Unit) {
            this.hpoObjective = aws.sdk.kotlin.services.personalize.model.HpoObjective.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.HpoResourceConfig] inside the given [block]
         */
        public fun hpoResourceConfig(block: aws.sdk.kotlin.services.personalize.model.HpoResourceConfig.Builder.() -> kotlin.Unit) {
            this.hpoResourceConfig = aws.sdk.kotlin.services.personalize.model.HpoResourceConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
