// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the properties of an event tracker. For a complete listing, call the [DescribeEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html) API.
 */
public class EventTrackerSummary private constructor(builder: Builder) {
    /**
     * The date and time (in Unix time) that the event tracker was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The Amazon Resource Name (ARN) of the event tracker.
     */
    public val eventTrackerArn: kotlin.String? = builder.eventTrackerArn
    /**
     * The date and time (in Unix time) that the event tracker was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the event tracker.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of the event tracker.
     *
     * An event tracker can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.EventTrackerSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventTrackerSummary(")
        append("creationDateTime=$creationDateTime,")
        append("eventTrackerArn=$eventTrackerArn,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (eventTrackerArn?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventTrackerSummary

        if (creationDateTime != other.creationDateTime) return false
        if (eventTrackerArn != other.eventTrackerArn) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.EventTrackerSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time (in Unix time) that the event tracker was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the event tracker.
         */
        public var eventTrackerArn: kotlin.String? = null
        /**
         * The date and time (in Unix time) that the event tracker was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the event tracker.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the event tracker.
         *
         * An event tracker can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         * + DELETE PENDING > DELETE IN_PROGRESS
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.EventTrackerSummary) : this() {
            this.creationDateTime = x.creationDateTime
            this.eventTrackerArn = x.eventTrackerArn
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.EventTrackerSummary = EventTrackerSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
