// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model



/**
 * The configuration details of a campaign.
 */
public class CampaignConfig private constructor(builder: Builder) {
    /**
     * Whether metadata with recommendations is enabled for the campaign. If enabled, you can specify the columns from your Items dataset in your request for recommendations. Amazon Personalize returns this data for each item in the recommendation response. For information about enabling metadata for a campaign, see [Enabling metadata in recommendations for a campaign](https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata).
     *
     *  If you enable metadata in recommendations, you will incur additional costs. For more information, see [Amazon Personalize pricing](https://aws.amazon.com/personalize/pricing/).
     */
    public val enableMetadataWithRecommendations: kotlin.Boolean? = builder.enableMetadataWithRecommendations
    /**
     * Specifies the exploration configuration hyperparameters, including `explorationWeight` and `explorationItemAgeCutOff`, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide `itemExplorationConfig` data only if your solution uses the [User-Personalization](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html) recipe.
     */
    public val itemExplorationConfig: Map<String, String>? = builder.itemExplorationConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.CampaignConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CampaignConfig(")
        append("enableMetadataWithRecommendations=$enableMetadataWithRecommendations,")
        append("itemExplorationConfig=$itemExplorationConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableMetadataWithRecommendations?.hashCode() ?: 0
        result = 31 * result + (itemExplorationConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CampaignConfig

        if (enableMetadataWithRecommendations != other.enableMetadataWithRecommendations) return false
        if (itemExplorationConfig != other.itemExplorationConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.CampaignConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Whether metadata with recommendations is enabled for the campaign. If enabled, you can specify the columns from your Items dataset in your request for recommendations. Amazon Personalize returns this data for each item in the recommendation response. For information about enabling metadata for a campaign, see [Enabling metadata in recommendations for a campaign](https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata).
         *
         *  If you enable metadata in recommendations, you will incur additional costs. For more information, see [Amazon Personalize pricing](https://aws.amazon.com/personalize/pricing/).
         */
        public var enableMetadataWithRecommendations: kotlin.Boolean? = null
        /**
         * Specifies the exploration configuration hyperparameters, including `explorationWeight` and `explorationItemAgeCutOff`, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide `itemExplorationConfig` data only if your solution uses the [User-Personalization](https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html) recipe.
         */
        public var itemExplorationConfig: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.CampaignConfig) : this() {
            this.enableMetadataWithRecommendations = x.enableMetadataWithRecommendations
            this.itemExplorationConfig = x.itemExplorationConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.CampaignConfig = CampaignConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
