// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information on a recommendation filter, including its ARN, status, and filter expression.
 */
public class Filter private constructor(builder: Builder) {
    /**
     * The time at which the filter was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The ARN of the dataset group to which the filter belongs.
     */
    public val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * If the filter failed, the reason for its failure.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The ARN of the filter.
     */
    public val filterArn: kotlin.String? = builder.filterArn
    /**
     * Specifies the type of item interactions to filter out of recommendation results. The filter expression must follow specific format rules. For information about filter expression structure and syntax, see [Filter expressions](https://docs.aws.amazon.com/personalize/latest/dg/filter-expressions.html).
     */
    public val filterExpression: kotlin.String? = builder.filterExpression
    /**
     * The time at which the filter was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the filter.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of the filter.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.Filter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Filter(")
        append("creationDateTime=$creationDateTime,")
        append("datasetGroupArn=$datasetGroupArn,")
        append("failureReason=$failureReason,")
        append("filterArn=$filterArn,")
        append("filterExpression=*** Sensitive Data Redacted ***,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (datasetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (filterArn?.hashCode() ?: 0)
        result = 31 * result + (filterExpression?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Filter

        if (creationDateTime != other.creationDateTime) return false
        if (datasetGroupArn != other.datasetGroupArn) return false
        if (failureReason != other.failureReason) return false
        if (filterArn != other.filterArn) return false
        if (filterExpression != other.filterExpression) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.Filter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time at which the filter was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the dataset group to which the filter belongs.
         */
        public var datasetGroupArn: kotlin.String? = null
        /**
         * If the filter failed, the reason for its failure.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The ARN of the filter.
         */
        public var filterArn: kotlin.String? = null
        /**
         * Specifies the type of item interactions to filter out of recommendation results. The filter expression must follow specific format rules. For information about filter expression structure and syntax, see [Filter expressions](https://docs.aws.amazon.com/personalize/latest/dg/filter-expressions.html).
         */
        public var filterExpression: kotlin.String? = null
        /**
         * The time at which the filter was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the filter.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the filter.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.Filter) : this() {
            this.creationDateTime = x.creationDateTime
            this.datasetGroupArn = x.datasetGroupArn
            this.failureReason = x.failureReason
            this.filterArn = x.filterArn
            this.filterExpression = x.filterExpression
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.Filter = Filter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
