// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model



public class CreateCampaignRequest private constructor(builder: Builder) {
    /**
     * The configuration details of a campaign.
     */
    public val campaignConfig: aws.sdk.kotlin.services.personalize.model.CampaignConfig? = builder.campaignConfig
    /**
     * Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize will support. A high `minProvisionedTPS` will increase your bill. We recommend starting with 1 for `minProvisionedTPS` (the default). Track your usage using Amazon CloudWatch metrics, and increase the `minProvisionedTPS` as necessary.
     */
    public val minProvisionedTps: kotlin.Int? = builder.minProvisionedTps
    /**
     * A name for the new campaign. The campaign name must be unique within your account.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the solution version to deploy.
     */
    public val solutionVersionArn: kotlin.String? = builder.solutionVersionArn
    /**
     * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) to apply to the campaign.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.CreateCampaignRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCampaignRequest(")
        append("campaignConfig=$campaignConfig,")
        append("minProvisionedTps=$minProvisionedTps,")
        append("name=$name,")
        append("solutionVersionArn=$solutionVersionArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = campaignConfig?.hashCode() ?: 0
        result = 31 * result + (minProvisionedTps ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (solutionVersionArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCampaignRequest

        if (campaignConfig != other.campaignConfig) return false
        if (minProvisionedTps != other.minProvisionedTps) return false
        if (name != other.name) return false
        if (solutionVersionArn != other.solutionVersionArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.CreateCampaignRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The configuration details of a campaign.
         */
        public var campaignConfig: aws.sdk.kotlin.services.personalize.model.CampaignConfig? = null
        /**
         * Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize will support. A high `minProvisionedTPS` will increase your bill. We recommend starting with 1 for `minProvisionedTPS` (the default). Track your usage using Amazon CloudWatch metrics, and increase the `minProvisionedTPS` as necessary.
         */
        public var minProvisionedTps: kotlin.Int? = null
        /**
         * A name for the new campaign. The campaign name must be unique within your account.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the solution version to deploy.
         */
        public var solutionVersionArn: kotlin.String? = null
        /**
         * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) to apply to the campaign.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.CreateCampaignRequest) : this() {
            this.campaignConfig = x.campaignConfig
            this.minProvisionedTps = x.minProvisionedTps
            this.name = x.name
            this.solutionVersionArn = x.solutionVersionArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.CreateCampaignRequest = CreateCampaignRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.CampaignConfig] inside the given [block]
         */
        public fun campaignConfig(block: aws.sdk.kotlin.services.personalize.model.CampaignConfig.Builder.() -> kotlin.Unit) {
            this.campaignConfig = aws.sdk.kotlin.services.personalize.model.CampaignConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
