// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.personalize.auth.PersonalizeAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.personalize.auth.PersonalizeIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.personalize.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.personalize.model.*
import aws.sdk.kotlin.services.personalize.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext


public const val ServiceApiVersion: String = "2018-05-22"

internal class DefaultPersonalizeClient(override val config: PersonalizeClient.Config) : PersonalizeClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = PersonalizeIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "personalize")
        }
        toMap()
    }
    private val authSchemeAdapter = PersonalizeAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.personalize"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Generates batch recommendations based on a list of items or users stored in Amazon S3 and exports the recommendations to an Amazon S3 bucket.
     *
     * To generate batch recommendations, specify the ARN of a solution version and an Amazon S3 URI for the input and output data. For user personalization, popular items, and personalized ranking solutions, the batch inference job generates a list of recommended items for each user ID in the input file. For related items solutions, the job generates a list of recommended items for each item ID in the input file.
     *
     * For more information, see [Creating a batch inference job ](https://docs.aws.amazon.com/personalize/latest/dg/getting-batch-recommendations.html).
     *
     *  If you use the Similar-Items recipe, Amazon Personalize can add descriptive themes to batch recommendations. To generate themes, set the job's mode to `THEME_GENERATION` and specify the name of the field that contains item names in the input data.
     *
     *  For more information about generating themes, see [Batch recommendations with themes from Content Generator ](https://docs.aws.amazon.com/personalize/latest/dg/themed-batch-recommendations.html).
     *
     * You can't get batch recommendations with the Trending-Now or Next-Best-Action recipes.
     */
    override suspend fun createBatchInferenceJob(input: CreateBatchInferenceJobRequest): CreateBatchInferenceJobResponse {
        val op = SdkHttpOperation.build<CreateBatchInferenceJobRequest, CreateBatchInferenceJobResponse> {
            serializer = CreateBatchInferenceJobOperationSerializer()
            deserializer = CreateBatchInferenceJobOperationDeserializer()
            operationName = "CreateBatchInferenceJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a batch segment job. The operation can handle up to 50 million records and the input file must be in JSON format. For more information, see [Getting batch recommendations and user segments](https://docs.aws.amazon.com/personalize/latest/dg/recommendations-batch.html).
     */
    override suspend fun createBatchSegmentJob(input: CreateBatchSegmentJobRequest): CreateBatchSegmentJobResponse {
        val op = SdkHttpOperation.build<CreateBatchSegmentJobRequest, CreateBatchSegmentJobResponse> {
            serializer = CreateBatchSegmentJobOperationSerializer()
            deserializer = CreateBatchSegmentJobOperationDeserializer()
            operationName = "CreateBatchSegmentJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a campaign that deploys a solution version. When a client calls the [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) and [GetPersonalizedRanking](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html) APIs, a campaign is specified in the request.
     *
     * **Minimum Provisioned TPS and Auto-Scaling**
     *
     *  A high `minProvisionedTPS` will increase your bill. We recommend starting with 1 for `minProvisionedTPS` (the default). Track your usage using Amazon CloudWatch metrics, and increase the `minProvisionedTPS` as necessary.
     *
     * A transaction is a single `GetRecommendations` or `GetPersonalizedRanking` call. Transactions per second (TPS) is the throughput and unit of billing for Amazon Personalize. The minimum provisioned TPS (`minProvisionedTPS`) specifies the baseline throughput provisioned by Amazon Personalize, and thus, the minimum billing charge.
     *
     *  If your TPS increases beyond `minProvisionedTPS`, Amazon Personalize auto-scales the provisioned capacity up and down, but never below `minProvisionedTPS`. There's a short time delay while the capacity is increased that might cause loss of transactions.
     *
     * The actual TPS used is calculated as the average requests/second within a 5-minute window. You pay for maximum of either the minimum provisioned TPS or the actual TPS. We recommend starting with a low `minProvisionedTPS`, track your usage using Amazon CloudWatch metrics, and then increase the `minProvisionedTPS` as necessary.
     *
     * **Status**
     *
     * A campaign can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the campaign status, call [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html).
     *
     * Wait until the `status` of the campaign is `ACTIVE` before asking the campaign for recommendations.
     *
     * **Related APIs**
     * + [ListCampaigns](https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html)
     * + [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html)
     * + [UpdateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateCampaign.html)
     * + [DeleteCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteCampaign.html)
     */
    override suspend fun createCampaign(input: CreateCampaignRequest): CreateCampaignResponse {
        val op = SdkHttpOperation.build<CreateCampaignRequest, CreateCampaignResponse> {
            serializer = CreateCampaignOperationSerializer()
            deserializer = CreateCampaignOperationDeserializer()
            operationName = "CreateCampaign"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an empty dataset and adds it to the specified dataset group. Use [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html) to import your training data to a dataset.
     *
     * There are 5 types of datasets:
     * + Item interactions
     * + Items
     * + Users
     * + Action interactions
     * + Actions
     *
     * Each dataset type has an associated schema with required field types. Only the `Item interactions` dataset is required in order to train a model (also referred to as creating a solution).
     *
     * A dataset can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the status of the dataset, call [DescribeDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html).
     *
     * **Related APIs**
     * + [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html)
     * + [ListDatasets](https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasets.html)
     * + [DescribeDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html)
     * + [DeleteDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDataset.html)
     */
    override suspend fun createDataset(input: CreateDatasetRequest): CreateDatasetResponse {
        val op = SdkHttpOperation.build<CreateDatasetRequest, CreateDatasetResponse> {
            serializer = CreateDatasetOperationSerializer()
            deserializer = CreateDatasetOperationDeserializer()
            operationName = "CreateDataset"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a job that exports data from your dataset to an Amazon S3 bucket. To allow Amazon Personalize to export the training data, you must specify an service-linked IAM role that gives Amazon Personalize `PutObject` permissions for your Amazon S3 bucket. For information, see [Exporting a dataset](https://docs.aws.amazon.com/personalize/latest/dg/export-data.html) in the Amazon Personalize developer guide.
     *
     * **Status**
     *
     * A dataset export job can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     *
     *  To get the status of the export job, call [DescribeDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetExportJob.html), and specify the Amazon Resource Name (ARN) of the dataset export job. The dataset export is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the job failed.
     */
    override suspend fun createDatasetExportJob(input: CreateDatasetExportJobRequest): CreateDatasetExportJobResponse {
        val op = SdkHttpOperation.build<CreateDatasetExportJobRequest, CreateDatasetExportJobResponse> {
            serializer = CreateDatasetExportJobOperationSerializer()
            deserializer = CreateDatasetExportJobOperationDeserializer()
            operationName = "CreateDatasetExportJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an empty dataset group. A dataset group is a container for Amazon Personalize resources. A dataset group can contain at most three datasets, one for each type of dataset:
     * + Item interactions
     * + Items
     * + Users
     * + Actions
     * + Action interactions
     *
     *  A dataset group can be a Domain dataset group, where you specify a domain and use pre-configured resources like recommenders, or a Custom dataset group, where you use custom resources, such as a solution with a solution version, that you deploy with a campaign. If you start with a Domain dataset group, you can still add custom resources such as solutions and solution versions trained with recipes for custom use cases and deployed with campaigns.
     *
     * A dataset group can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING
     *
     * To get the status of the dataset group, call [DescribeDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html). If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the creation failed.
     *
     * You must wait until the `status` of the dataset group is `ACTIVE` before adding a dataset to the group.
     *
     * You can specify an Key Management Service (KMS) key to encrypt the datasets in the group. If you specify a KMS key, you must also include an Identity and Access Management (IAM) role that has permission to access the key.
     *
     * **APIs that require a dataset group ARN in the request**
     * + [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html)
     * + [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html)
     * + [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
     *
     * **Related APIs**
     * + [ListDatasetGroups](https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetGroups.html)
     * + [DescribeDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html)
     * + [DeleteDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDatasetGroup.html)
     */
    override suspend fun createDatasetGroup(input: CreateDatasetGroupRequest): CreateDatasetGroupResponse {
        val op = SdkHttpOperation.build<CreateDatasetGroupRequest, CreateDatasetGroupResponse> {
            serializer = CreateDatasetGroupOperationSerializer()
            deserializer = CreateDatasetGroupOperationDeserializer()
            operationName = "CreateDatasetGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a job that imports training data from your data source (an Amazon S3 bucket) to an Amazon Personalize dataset. To allow Amazon Personalize to import the training data, you must specify an IAM service role that has permission to read from the data source, as Amazon Personalize makes a copy of your data and processes it internally. For information on granting access to your Amazon S3 bucket, see [Giving Amazon Personalize Access to Amazon S3 Resources](https://docs.aws.amazon.com/personalize/latest/dg/granting-personalize-s3-access.html).
     *
     * If you already created a recommender or deployed a custom solution version with a campaign, how new bulk records influence recommendations depends on the domain use case or recipe that you use. For more information, see [How new data influences real-time recommendations](https://docs.aws.amazon.com/personalize/latest/dg/how-new-data-influences-recommendations.html).
     *
     * By default, a dataset import job replaces any existing data in the dataset that you imported in bulk. To add new records without replacing existing data, specify INCREMENTAL for the import mode in the CreateDatasetImportJob operation.
     *
     * **Status**
     *
     * A dataset import job can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     *
     * To get the status of the import job, call [DescribeDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html), providing the Amazon Resource Name (ARN) of the dataset import job. The dataset import is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the job failed.
     *
     * Importing takes time. You must wait until the status shows as ACTIVE before training a model using the dataset.
     *
     * **Related APIs**
     * + [ListDatasetImportJobs](https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetImportJobs.html)
     * + [DescribeDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html)
     */
    override suspend fun createDatasetImportJob(input: CreateDatasetImportJobRequest): CreateDatasetImportJobResponse {
        val op = SdkHttpOperation.build<CreateDatasetImportJobRequest, CreateDatasetImportJobResponse> {
            serializer = CreateDatasetImportJobOperationSerializer()
            deserializer = CreateDatasetImportJobOperationDeserializer()
            operationName = "CreateDatasetImportJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an event tracker that you use when adding event data to a specified dataset group using the [PutEvents](https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html) API.
     *
     * Only one event tracker can be associated with a dataset group. You will get an error if you call `CreateEventTracker` using the same dataset group as an existing event tracker.
     *
     * When you create an event tracker, the response includes a tracking ID, which you pass as a parameter when you use the [PutEvents](https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html) operation. Amazon Personalize then appends the event data to the Item interactions dataset of the dataset group you specify in your event tracker.
     *
     * The event tracker can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the status of the event tracker, call [DescribeEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html).
     *
     * The event tracker must be in the ACTIVE state before using the tracking ID.
     *
     * **Related APIs**
     * + [ListEventTrackers](https://docs.aws.amazon.com/personalize/latest/dg/API_ListEventTrackers.html)
     * + [DescribeEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html)
     * + [DeleteEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteEventTracker.html)
     */
    override suspend fun createEventTracker(input: CreateEventTrackerRequest): CreateEventTrackerResponse {
        val op = SdkHttpOperation.build<CreateEventTrackerRequest, CreateEventTrackerResponse> {
            serializer = CreateEventTrackerOperationSerializer()
            deserializer = CreateEventTrackerOperationDeserializer()
            operationName = "CreateEventTracker"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a recommendation filter. For more information, see [Filtering recommendations and user segments](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
     */
    override suspend fun createFilter(input: CreateFilterRequest): CreateFilterResponse {
        val op = SdkHttpOperation.build<CreateFilterRequest, CreateFilterResponse> {
            serializer = CreateFilterOperationSerializer()
            deserializer = CreateFilterOperationDeserializer()
            operationName = "CreateFilter"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a metric attribution. A metric attribution creates reports on the data that you import into Amazon Personalize. Depending on how you imported the data, you can view reports in Amazon CloudWatch or Amazon S3. For more information, see [Measuring impact of recommendations](https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html).
     */
    override suspend fun createMetricAttribution(input: CreateMetricAttributionRequest): CreateMetricAttributionResponse {
        val op = SdkHttpOperation.build<CreateMetricAttributionRequest, CreateMetricAttributionResponse> {
            serializer = CreateMetricAttributionOperationSerializer()
            deserializer = CreateMetricAttributionOperationDeserializer()
            operationName = "CreateMetricAttribution"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a recommender with the recipe (a Domain dataset group use case) you specify. You create recommenders for a Domain dataset group and specify the recommender's Amazon Resource Name (ARN) when you make a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request.
     *
     * **Minimum recommendation requests per second**
     *
     * A high `minRecommendationRequestsPerSecond` will increase your bill. We recommend starting with 1 for `minRecommendationRequestsPerSecond` (the default). Track your usage using Amazon CloudWatch metrics, and increase the `minRecommendationRequestsPerSecond` as necessary.
     *
     * When you create a recommender, you can configure the recommender's minimum recommendation requests per second. The minimum recommendation requests per second (`minRecommendationRequestsPerSecond`) specifies the baseline recommendation request throughput provisioned by Amazon Personalize. The default minRecommendationRequestsPerSecond is `1`. A recommendation request is a single `GetRecommendations` operation. Request throughput is measured in requests per second and Amazon Personalize uses your requests per second to derive your requests per hour and the price of your recommender usage.
     *
     *  If your requests per second increases beyond `minRecommendationRequestsPerSecond`, Amazon Personalize auto-scales the provisioned capacity up and down, but never below `minRecommendationRequestsPerSecond`. There's a short time delay while the capacity is increased that might cause loss of requests.
     *
     *  Your bill is the greater of either the minimum requests per hour (based on minRecommendationRequestsPerSecond) or the actual number of requests. The actual request throughput used is calculated as the average requests/second within a one-hour window. We recommend starting with the default `minRecommendationRequestsPerSecond`, track your usage using Amazon CloudWatch metrics, and then increase the `minRecommendationRequestsPerSecond` as necessary.
     *
     * **Status**
     *
     * A recommender can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS > ACTIVE
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the recommender status, call [DescribeRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html).
     *
     * Wait until the `status` of the recommender is `ACTIVE` before asking the recommender for recommendations.
     *
     * **Related APIs**
     * + [ListRecommenders](https://docs.aws.amazon.com/personalize/latest/dg/API_ListRecommenders.html)
     * + [DescribeRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html)
     * + [UpdateRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateRecommender.html)
     * + [DeleteRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteRecommender.html)
     */
    override suspend fun createRecommender(input: CreateRecommenderRequest): CreateRecommenderResponse {
        val op = SdkHttpOperation.build<CreateRecommenderRequest, CreateRecommenderResponse> {
            serializer = CreateRecommenderOperationSerializer()
            deserializer = CreateRecommenderOperationDeserializer()
            operationName = "CreateRecommender"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Personalize schema from the specified schema string. The schema you create must be in Avro JSON format.
     *
     * Amazon Personalize recognizes three schema variants. Each schema is associated with a dataset type and has a set of required field and keywords. If you are creating a schema for a dataset in a Domain dataset group, you provide the domain of the Domain dataset group. You specify a schema when you call [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     *
     * **Related APIs**
     * + [ListSchemas](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSchemas.html)
     * + [DescribeSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSchema.html)
     * + [DeleteSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSchema.html)
     */
    override suspend fun createSchema(input: CreateSchemaRequest): CreateSchemaResponse {
        val op = SdkHttpOperation.build<CreateSchemaRequest, CreateSchemaResponse> {
            serializer = CreateSchemaOperationSerializer()
            deserializer = CreateSchemaOperationDeserializer()
            operationName = "CreateSchema"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates the configuration for training a model. A trained model is known as a solution version. After the configuration is created, you train the model (create a solution version) by calling the [CreateSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html) operation. Every time you call `CreateSolutionVersion`, a new version of the solution is created.
     *
     * After creating a solution version, you check its accuracy by calling [GetSolutionMetrics](https://docs.aws.amazon.com/personalize/latest/dg/API_GetSolutionMetrics.html). When you are satisfied with the version, you deploy it using [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html). The campaign provides recommendations to a client through the [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) API.
     *
     * To train a model, Amazon Personalize requires training data and a recipe. The training data comes from the dataset group that you provide in the request. A recipe specifies the training algorithm and a feature transformation. You can specify one of the predefined recipes provided by Amazon Personalize.
     *
     * Amazon Personalize doesn't support configuring the `hpoObjective` for solution hyperparameter optimization at this time.
     *
     * **Status**
     *
     * A solution can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the status of the solution, call [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html). Wait until the status shows as ACTIVE before calling `CreateSolutionVersion`.
     *
     * **Related APIs**
     * + [ListSolutions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html)
     * + [CreateSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html)
     * + [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html)
     * + [DeleteSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html)
     *
     * + [ListSolutionVersions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html)
     * + [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html)
     */
    override suspend fun createSolution(input: CreateSolutionRequest): CreateSolutionResponse {
        val op = SdkHttpOperation.build<CreateSolutionRequest, CreateSolutionResponse> {
            serializer = CreateSolutionOperationSerializer()
            deserializer = CreateSolutionOperationDeserializer()
            operationName = "CreateSolution"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Trains or retrains an active solution in a Custom dataset group. A solution is created using the [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html) operation and must be in the ACTIVE state before calling `CreateSolutionVersion`. A new version of the solution is created every time you call this operation.
     *
     * **Status**
     *
     * A solution version can be in one of the following states:
     * + CREATE PENDING
     * + CREATE IN_PROGRESS
     * + ACTIVE
     * + CREATE FAILED
     * + CREATE STOPPING
     * + CREATE STOPPED
     *
     * To get the status of the version, call [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html). Wait until the status shows as ACTIVE before calling `CreateCampaign`.
     *
     * If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the job failed.
     *
     * **Related APIs**
     * + [ListSolutionVersions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html)
     * + [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html)
     * + [ListSolutions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html)
     * + [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
     * + [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html)
     * + [DeleteSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html)
     */
    override suspend fun createSolutionVersion(input: CreateSolutionVersionRequest): CreateSolutionVersionResponse {
        val op = SdkHttpOperation.build<CreateSolutionVersionRequest, CreateSolutionVersionResponse> {
            serializer = CreateSolutionVersionOperationSerializer()
            deserializer = CreateSolutionVersionOperationDeserializer()
            operationName = "CreateSolutionVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a campaign by deleting the solution deployment. The solution that the campaign is based on is not deleted and can be redeployed when needed. A deleted campaign can no longer be specified in a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request. For information on creating campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
     */
    override suspend fun deleteCampaign(input: DeleteCampaignRequest): DeleteCampaignResponse {
        val op = SdkHttpOperation.build<DeleteCampaignRequest, DeleteCampaignResponse> {
            serializer = DeleteCampaignOperationSerializer()
            deserializer = DeleteCampaignOperationDeserializer()
            operationName = "DeleteCampaign"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a dataset. You can't delete a dataset if an associated `DatasetImportJob` or `SolutionVersion` is in the CREATE PENDING or IN PROGRESS state. For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    override suspend fun deleteDataset(input: DeleteDatasetRequest): DeleteDatasetResponse {
        val op = SdkHttpOperation.build<DeleteDatasetRequest, DeleteDatasetResponse> {
            serializer = DeleteDatasetOperationSerializer()
            deserializer = DeleteDatasetOperationDeserializer()
            operationName = "DeleteDataset"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a dataset group. Before you delete a dataset group, you must delete the following:
     * + All associated event trackers.
     * + All associated solutions.
     * + All datasets in the dataset group.
     */
    override suspend fun deleteDatasetGroup(input: DeleteDatasetGroupRequest): DeleteDatasetGroupResponse {
        val op = SdkHttpOperation.build<DeleteDatasetGroupRequest, DeleteDatasetGroupResponse> {
            serializer = DeleteDatasetGroupOperationSerializer()
            deserializer = DeleteDatasetGroupOperationDeserializer()
            operationName = "DeleteDatasetGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the event tracker. Does not delete the dataset from the dataset group. For more information on event trackers, see [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
     */
    override suspend fun deleteEventTracker(input: DeleteEventTrackerRequest): DeleteEventTrackerResponse {
        val op = SdkHttpOperation.build<DeleteEventTrackerRequest, DeleteEventTrackerResponse> {
            serializer = DeleteEventTrackerOperationSerializer()
            deserializer = DeleteEventTrackerOperationDeserializer()
            operationName = "DeleteEventTracker"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a filter.
     */
    override suspend fun deleteFilter(input: DeleteFilterRequest): DeleteFilterResponse {
        val op = SdkHttpOperation.build<DeleteFilterRequest, DeleteFilterResponse> {
            serializer = DeleteFilterOperationSerializer()
            deserializer = DeleteFilterOperationDeserializer()
            operationName = "DeleteFilter"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a metric attribution.
     */
    override suspend fun deleteMetricAttribution(input: DeleteMetricAttributionRequest): DeleteMetricAttributionResponse {
        val op = SdkHttpOperation.build<DeleteMetricAttributionRequest, DeleteMetricAttributionResponse> {
            serializer = DeleteMetricAttributionOperationSerializer()
            deserializer = DeleteMetricAttributionOperationDeserializer()
            operationName = "DeleteMetricAttribution"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deactivates and removes a recommender. A deleted recommender can no longer be specified in a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request.
     */
    override suspend fun deleteRecommender(input: DeleteRecommenderRequest): DeleteRecommenderResponse {
        val op = SdkHttpOperation.build<DeleteRecommenderRequest, DeleteRecommenderResponse> {
            serializer = DeleteRecommenderOperationSerializer()
            deserializer = DeleteRecommenderOperationDeserializer()
            operationName = "DeleteRecommender"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a schema. Before deleting a schema, you must delete all datasets referencing the schema. For more information on schemas, see [CreateSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
     */
    override suspend fun deleteSchema(input: DeleteSchemaRequest): DeleteSchemaResponse {
        val op = SdkHttpOperation.build<DeleteSchemaRequest, DeleteSchemaResponse> {
            serializer = DeleteSchemaOperationSerializer()
            deserializer = DeleteSchemaOperationDeserializer()
            operationName = "DeleteSchema"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes all versions of a solution and the `Solution` object itself. Before deleting a solution, you must delete all campaigns based on the solution. To determine what campaigns are using the solution, call [ListCampaigns](https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html) and supply the Amazon Resource Name (ARN) of the solution. You can't delete a solution if an associated `SolutionVersion` is in the CREATE PENDING or IN PROGRESS state. For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
     */
    override suspend fun deleteSolution(input: DeleteSolutionRequest): DeleteSolutionResponse {
        val op = SdkHttpOperation.build<DeleteSolutionRequest, DeleteSolutionResponse> {
            serializer = DeleteSolutionOperationSerializer()
            deserializer = DeleteSolutionOperationDeserializer()
            operationName = "DeleteSolution"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the given algorithm.
     */
    override suspend fun describeAlgorithm(input: DescribeAlgorithmRequest): DescribeAlgorithmResponse {
        val op = SdkHttpOperation.build<DescribeAlgorithmRequest, DescribeAlgorithmResponse> {
            serializer = DescribeAlgorithmOperationSerializer()
            deserializer = DescribeAlgorithmOperationDeserializer()
            operationName = "DescribeAlgorithm"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the properties of a batch inference job including name, Amazon Resource Name (ARN), status, input and output configurations, and the ARN of the solution version used to generate the recommendations.
     */
    override suspend fun describeBatchInferenceJob(input: DescribeBatchInferenceJobRequest): DescribeBatchInferenceJobResponse {
        val op = SdkHttpOperation.build<DescribeBatchInferenceJobRequest, DescribeBatchInferenceJobResponse> {
            serializer = DescribeBatchInferenceJobOperationSerializer()
            deserializer = DescribeBatchInferenceJobOperationDeserializer()
            operationName = "DescribeBatchInferenceJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the properties of a batch segment job including name, Amazon Resource Name (ARN), status, input and output configurations, and the ARN of the solution version used to generate segments.
     */
    override suspend fun describeBatchSegmentJob(input: DescribeBatchSegmentJobRequest): DescribeBatchSegmentJobResponse {
        val op = SdkHttpOperation.build<DescribeBatchSegmentJobRequest, DescribeBatchSegmentJobResponse> {
            serializer = DescribeBatchSegmentJobOperationSerializer()
            deserializer = DescribeBatchSegmentJobOperationDeserializer()
            operationName = "DescribeBatchSegmentJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the given campaign, including its status.
     *
     * A campaign can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * When the `status` is `CREATE FAILED`, the response includes the `failureReason` key, which describes why.
     *
     * For more information on campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
     */
    override suspend fun describeCampaign(input: DescribeCampaignRequest): DescribeCampaignResponse {
        val op = SdkHttpOperation.build<DescribeCampaignRequest, DescribeCampaignResponse> {
            serializer = DescribeCampaignOperationSerializer()
            deserializer = DescribeCampaignOperationDeserializer()
            operationName = "DescribeCampaign"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the given dataset. For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    override suspend fun describeDataset(input: DescribeDatasetRequest): DescribeDatasetResponse {
        val op = SdkHttpOperation.build<DescribeDatasetRequest, DescribeDatasetResponse> {
            serializer = DescribeDatasetOperationSerializer()
            deserializer = DescribeDatasetOperationDeserializer()
            operationName = "DescribeDataset"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the dataset export job created by [CreateDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html), including the export job status.
     */
    override suspend fun describeDatasetExportJob(input: DescribeDatasetExportJobRequest): DescribeDatasetExportJobResponse {
        val op = SdkHttpOperation.build<DescribeDatasetExportJobRequest, DescribeDatasetExportJobResponse> {
            serializer = DescribeDatasetExportJobOperationSerializer()
            deserializer = DescribeDatasetExportJobOperationDeserializer()
            operationName = "DescribeDatasetExportJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the given dataset group. For more information on dataset groups, see [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html).
     */
    override suspend fun describeDatasetGroup(input: DescribeDatasetGroupRequest): DescribeDatasetGroupResponse {
        val op = SdkHttpOperation.build<DescribeDatasetGroupRequest, DescribeDatasetGroupResponse> {
            serializer = DescribeDatasetGroupOperationSerializer()
            deserializer = DescribeDatasetGroupOperationDeserializer()
            operationName = "DescribeDatasetGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the dataset import job created by [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html), including the import job status.
     */
    override suspend fun describeDatasetImportJob(input: DescribeDatasetImportJobRequest): DescribeDatasetImportJobResponse {
        val op = SdkHttpOperation.build<DescribeDatasetImportJobRequest, DescribeDatasetImportJobResponse> {
            serializer = DescribeDatasetImportJobOperationSerializer()
            deserializer = DescribeDatasetImportJobOperationDeserializer()
            operationName = "DescribeDatasetImportJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes an event tracker. The response includes the `trackingId` and `status` of the event tracker. For more information on event trackers, see [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
     */
    override suspend fun describeEventTracker(input: DescribeEventTrackerRequest): DescribeEventTrackerResponse {
        val op = SdkHttpOperation.build<DescribeEventTrackerRequest, DescribeEventTrackerResponse> {
            serializer = DescribeEventTrackerOperationSerializer()
            deserializer = DescribeEventTrackerOperationDeserializer()
            operationName = "DescribeEventTracker"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the given feature transformation.
     */
    override suspend fun describeFeatureTransformation(input: DescribeFeatureTransformationRequest): DescribeFeatureTransformationResponse {
        val op = SdkHttpOperation.build<DescribeFeatureTransformationRequest, DescribeFeatureTransformationResponse> {
            serializer = DescribeFeatureTransformationOperationSerializer()
            deserializer = DescribeFeatureTransformationOperationDeserializer()
            operationName = "DescribeFeatureTransformation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes a filter's properties.
     */
    override suspend fun describeFilter(input: DescribeFilterRequest): DescribeFilterResponse {
        val op = SdkHttpOperation.build<DescribeFilterRequest, DescribeFilterResponse> {
            serializer = DescribeFilterOperationSerializer()
            deserializer = DescribeFilterOperationDeserializer()
            operationName = "DescribeFilter"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes a metric attribution.
     */
    override suspend fun describeMetricAttribution(input: DescribeMetricAttributionRequest): DescribeMetricAttributionResponse {
        val op = SdkHttpOperation.build<DescribeMetricAttributionRequest, DescribeMetricAttributionResponse> {
            serializer = DescribeMetricAttributionOperationSerializer()
            deserializer = DescribeMetricAttributionOperationDeserializer()
            operationName = "DescribeMetricAttribution"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes a recipe.
     *
     * A recipe contains three items:
     * + An algorithm that trains a model.
     * + Hyperparameters that govern the training.
     * + Feature transformation information for modifying the input data before training.
     *
     * Amazon Personalize provides a set of predefined recipes. You specify a recipe when you create a solution with the [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html) API. `CreateSolution` trains a model by using the algorithm in the specified recipe and a training dataset. The solution, when deployed as a campaign, can provide recommendations using the [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) API.
     */
    override suspend fun describeRecipe(input: DescribeRecipeRequest): DescribeRecipeResponse {
        val op = SdkHttpOperation.build<DescribeRecipeRequest, DescribeRecipeResponse> {
            serializer = DescribeRecipeOperationSerializer()
            deserializer = DescribeRecipeOperationDeserializer()
            operationName = "DescribeRecipe"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the given recommender, including its status.
     *
     * A recommender can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS > ACTIVE
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * When the `status` is `CREATE FAILED`, the response includes the `failureReason` key, which describes why.
     *
     * The `modelMetrics` key is null when the recommender is being created or deleted.
     *
     * For more information on recommenders, see [CreateRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html).
     */
    override suspend fun describeRecommender(input: DescribeRecommenderRequest): DescribeRecommenderResponse {
        val op = SdkHttpOperation.build<DescribeRecommenderRequest, DescribeRecommenderResponse> {
            serializer = DescribeRecommenderOperationSerializer()
            deserializer = DescribeRecommenderOperationDeserializer()
            operationName = "DescribeRecommender"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes a schema. For more information on schemas, see [CreateSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
     */
    override suspend fun describeSchema(input: DescribeSchemaRequest): DescribeSchemaResponse {
        val op = SdkHttpOperation.build<DescribeSchemaRequest, DescribeSchemaResponse> {
            serializer = DescribeSchemaOperationSerializer()
            deserializer = DescribeSchemaOperationDeserializer()
            operationName = "DescribeSchema"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes a solution. For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
     */
    override suspend fun describeSolution(input: DescribeSolutionRequest): DescribeSolutionResponse {
        val op = SdkHttpOperation.build<DescribeSolutionRequest, DescribeSolutionResponse> {
            serializer = DescribeSolutionOperationSerializer()
            deserializer = DescribeSolutionOperationDeserializer()
            operationName = "DescribeSolution"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes a specific version of a solution. For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
     */
    override suspend fun describeSolutionVersion(input: DescribeSolutionVersionRequest): DescribeSolutionVersionResponse {
        val op = SdkHttpOperation.build<DescribeSolutionVersionRequest, DescribeSolutionVersionResponse> {
            serializer = DescribeSolutionVersionOperationSerializer()
            deserializer = DescribeSolutionVersionOperationDeserializer()
            operationName = "DescribeSolutionVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the metrics for the specified solution version.
     */
    override suspend fun getSolutionMetrics(input: GetSolutionMetricsRequest): GetSolutionMetricsResponse {
        val op = SdkHttpOperation.build<GetSolutionMetricsRequest, GetSolutionMetricsResponse> {
            serializer = GetSolutionMetricsOperationSerializer()
            deserializer = GetSolutionMetricsOperationDeserializer()
            operationName = "GetSolutionMetrics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the batch inference jobs that have been performed off of a solution version.
     */
    override suspend fun listBatchInferenceJobs(input: ListBatchInferenceJobsRequest): ListBatchInferenceJobsResponse {
        val op = SdkHttpOperation.build<ListBatchInferenceJobsRequest, ListBatchInferenceJobsResponse> {
            serializer = ListBatchInferenceJobsOperationSerializer()
            deserializer = ListBatchInferenceJobsOperationDeserializer()
            operationName = "ListBatchInferenceJobs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the batch segment jobs that have been performed off of a solution version that you specify.
     */
    override suspend fun listBatchSegmentJobs(input: ListBatchSegmentJobsRequest): ListBatchSegmentJobsResponse {
        val op = SdkHttpOperation.build<ListBatchSegmentJobsRequest, ListBatchSegmentJobsResponse> {
            serializer = ListBatchSegmentJobsOperationSerializer()
            deserializer = ListBatchSegmentJobsOperationDeserializer()
            operationName = "ListBatchSegmentJobs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of campaigns that use the given solution. When a solution is not specified, all the campaigns associated with the account are listed. The response provides the properties for each campaign, including the Amazon Resource Name (ARN). For more information on campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
     */
    override suspend fun listCampaigns(input: ListCampaignsRequest): ListCampaignsResponse {
        val op = SdkHttpOperation.build<ListCampaignsRequest, ListCampaignsResponse> {
            serializer = ListCampaignsOperationSerializer()
            deserializer = ListCampaignsOperationDeserializer()
            operationName = "ListCampaigns"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of dataset export jobs that use the given dataset. When a dataset is not specified, all the dataset export jobs associated with the account are listed. The response provides the properties for each dataset export job, including the Amazon Resource Name (ARN). For more information on dataset export jobs, see [CreateDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html). For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    override suspend fun listDatasetExportJobs(input: ListDatasetExportJobsRequest): ListDatasetExportJobsResponse {
        val op = SdkHttpOperation.build<ListDatasetExportJobsRequest, ListDatasetExportJobsResponse> {
            serializer = ListDatasetExportJobsOperationSerializer()
            deserializer = ListDatasetExportJobsOperationDeserializer()
            operationName = "ListDatasetExportJobs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of dataset groups. The response provides the properties for each dataset group, including the Amazon Resource Name (ARN). For more information on dataset groups, see [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html).
     */
    override suspend fun listDatasetGroups(input: ListDatasetGroupsRequest): ListDatasetGroupsResponse {
        val op = SdkHttpOperation.build<ListDatasetGroupsRequest, ListDatasetGroupsResponse> {
            serializer = ListDatasetGroupsOperationSerializer()
            deserializer = ListDatasetGroupsOperationDeserializer()
            operationName = "ListDatasetGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of dataset import jobs that use the given dataset. When a dataset is not specified, all the dataset import jobs associated with the account are listed. The response provides the properties for each dataset import job, including the Amazon Resource Name (ARN). For more information on dataset import jobs, see [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html). For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    override suspend fun listDatasetImportJobs(input: ListDatasetImportJobsRequest): ListDatasetImportJobsResponse {
        val op = SdkHttpOperation.build<ListDatasetImportJobsRequest, ListDatasetImportJobsResponse> {
            serializer = ListDatasetImportJobsOperationSerializer()
            deserializer = ListDatasetImportJobsOperationDeserializer()
            operationName = "ListDatasetImportJobs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of datasets contained in the given dataset group. The response provides the properties for each dataset, including the Amazon Resource Name (ARN). For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    override suspend fun listDatasets(input: ListDatasetsRequest): ListDatasetsResponse {
        val op = SdkHttpOperation.build<ListDatasetsRequest, ListDatasetsResponse> {
            serializer = ListDatasetsOperationSerializer()
            deserializer = ListDatasetsOperationDeserializer()
            operationName = "ListDatasets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of event trackers associated with the account. The response provides the properties for each event tracker, including the Amazon Resource Name (ARN) and tracking ID. For more information on event trackers, see [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
     */
    override suspend fun listEventTrackers(input: ListEventTrackersRequest): ListEventTrackersResponse {
        val op = SdkHttpOperation.build<ListEventTrackersRequest, ListEventTrackersResponse> {
            serializer = ListEventTrackersOperationSerializer()
            deserializer = ListEventTrackersOperationDeserializer()
            operationName = "ListEventTrackers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all filters that belong to a given dataset group.
     */
    override suspend fun listFilters(input: ListFiltersRequest): ListFiltersResponse {
        val op = SdkHttpOperation.build<ListFiltersRequest, ListFiltersResponse> {
            serializer = ListFiltersOperationSerializer()
            deserializer = ListFiltersOperationDeserializer()
            operationName = "ListFilters"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the metrics for the metric attribution.
     */
    override suspend fun listMetricAttributionMetrics(input: ListMetricAttributionMetricsRequest): ListMetricAttributionMetricsResponse {
        val op = SdkHttpOperation.build<ListMetricAttributionMetricsRequest, ListMetricAttributionMetricsResponse> {
            serializer = ListMetricAttributionMetricsOperationSerializer()
            deserializer = ListMetricAttributionMetricsOperationDeserializer()
            operationName = "ListMetricAttributionMetrics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists metric attributions.
     */
    override suspend fun listMetricAttributions(input: ListMetricAttributionsRequest): ListMetricAttributionsResponse {
        val op = SdkHttpOperation.build<ListMetricAttributionsRequest, ListMetricAttributionsResponse> {
            serializer = ListMetricAttributionsOperationSerializer()
            deserializer = ListMetricAttributionsOperationDeserializer()
            operationName = "ListMetricAttributions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of available recipes. The response provides the properties for each recipe, including the recipe's Amazon Resource Name (ARN).
     */
    override suspend fun listRecipes(input: ListRecipesRequest): ListRecipesResponse {
        val op = SdkHttpOperation.build<ListRecipesRequest, ListRecipesResponse> {
            serializer = ListRecipesOperationSerializer()
            deserializer = ListRecipesOperationDeserializer()
            operationName = "ListRecipes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of recommenders in a given Domain dataset group. When a Domain dataset group is not specified, all the recommenders associated with the account are listed. The response provides the properties for each recommender, including the Amazon Resource Name (ARN). For more information on recommenders, see [CreateRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html).
     */
    override suspend fun listRecommenders(input: ListRecommendersRequest): ListRecommendersResponse {
        val op = SdkHttpOperation.build<ListRecommendersRequest, ListRecommendersResponse> {
            serializer = ListRecommendersOperationSerializer()
            deserializer = ListRecommendersOperationDeserializer()
            operationName = "ListRecommenders"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of schemas associated with the account. The response provides the properties for each schema, including the Amazon Resource Name (ARN). For more information on schemas, see [CreateSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
     */
    override suspend fun listSchemas(input: ListSchemasRequest): ListSchemasResponse {
        val op = SdkHttpOperation.build<ListSchemasRequest, ListSchemasResponse> {
            serializer = ListSchemasOperationSerializer()
            deserializer = ListSchemasOperationDeserializer()
            operationName = "ListSchemas"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of solution versions for the given solution. When a solution is not specified, all the solution versions associated with the account are listed. The response provides the properties for each solution version, including the Amazon Resource Name (ARN).
     */
    override suspend fun listSolutionVersions(input: ListSolutionVersionsRequest): ListSolutionVersionsResponse {
        val op = SdkHttpOperation.build<ListSolutionVersionsRequest, ListSolutionVersionsResponse> {
            serializer = ListSolutionVersionsOperationSerializer()
            deserializer = ListSolutionVersionsOperationDeserializer()
            operationName = "ListSolutionVersions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of solutions that use the given dataset group. When a dataset group is not specified, all the solutions associated with the account are listed. The response provides the properties for each solution, including the Amazon Resource Name (ARN). For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
     */
    override suspend fun listSolutions(input: ListSolutionsRequest): ListSolutionsResponse {
        val op = SdkHttpOperation.build<ListSolutionsRequest, ListSolutionsResponse> {
            serializer = ListSolutionsOperationSerializer()
            deserializer = ListSolutionsOperationDeserializer()
            operationName = "ListSolutions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get a list of [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) attached to a resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a recommender that is INACTIVE. Starting a recommender does not create any new models, but resumes billing and automatic retraining for the recommender.
     */
    override suspend fun startRecommender(input: StartRecommenderRequest): StartRecommenderResponse {
        val op = SdkHttpOperation.build<StartRecommenderRequest, StartRecommenderResponse> {
            serializer = StartRecommenderOperationSerializer()
            deserializer = StartRecommenderOperationDeserializer()
            operationName = "StartRecommender"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops a recommender that is ACTIVE. Stopping a recommender halts billing and automatic retraining for the recommender.
     */
    override suspend fun stopRecommender(input: StopRecommenderRequest): StopRecommenderResponse {
        val op = SdkHttpOperation.build<StopRecommenderRequest, StopRecommenderResponse> {
            serializer = StopRecommenderOperationSerializer()
            deserializer = StopRecommenderOperationDeserializer()
            operationName = "StopRecommender"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops creating a solution version that is in a state of CREATE_PENDING or CREATE IN_PROGRESS.
     *
     * Depending on the current state of the solution version, the solution version state changes as follows:
     * + CREATE_PENDING > CREATE_STOPPEDor
     * + CREATE_IN_PROGRESS > CREATE_STOPPING > CREATE_STOPPED
     *
     * You are billed for all of the training completed up until you stop the solution version creation. You cannot resume creating a solution version once it has been stopped.
     */
    override suspend fun stopSolutionVersionCreation(input: StopSolutionVersionCreationRequest): StopSolutionVersionCreationResponse {
        val op = SdkHttpOperation.build<StopSolutionVersionCreationRequest, StopSolutionVersionCreationResponse> {
            serializer = StopSolutionVersionCreationOperationSerializer()
            deserializer = StopSolutionVersionCreationOperationDeserializer()
            operationName = "StopSolutionVersionCreation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Add a list of tags to a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Remove [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) that are attached to a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a campaign to deploy a retrained solution version with an existing campaign, change your campaign's `minProvisionedTPS`, or modify your campaign's configuration, such as the exploration configuration.
     *
     * To update a campaign, the campaign status must be ACTIVE or CREATE FAILED. Check the campaign status using the [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html) operation.
     *
     * You can still get recommendations from a campaign while an update is in progress. The campaign will use the previous solution version and campaign configuration to generate recommendations until the latest campaign update status is `Active`.
     *
     * For more information about updating a campaign, including code samples, see [Updating a campaign](https://docs.aws.amazon.com/personalize/latest/dg/update-campaigns.html). For more information about campaigns, see [Creating a campaign](https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html).
     */
    override suspend fun updateCampaign(input: UpdateCampaignRequest): UpdateCampaignResponse {
        val op = SdkHttpOperation.build<UpdateCampaignRequest, UpdateCampaignResponse> {
            serializer = UpdateCampaignOperationSerializer()
            deserializer = UpdateCampaignOperationDeserializer()
            operationName = "UpdateCampaign"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update a dataset to replace its schema with a new or existing one. For more information, see [Replacing a dataset's schema](https://docs.aws.amazon.com/personalize/latest/dg/updating-dataset-schema.html).
     */
    override suspend fun updateDataset(input: UpdateDatasetRequest): UpdateDatasetResponse {
        val op = SdkHttpOperation.build<UpdateDatasetRequest, UpdateDatasetResponse> {
            serializer = UpdateDatasetOperationSerializer()
            deserializer = UpdateDatasetOperationDeserializer()
            operationName = "UpdateDataset"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a metric attribution.
     */
    override suspend fun updateMetricAttribution(input: UpdateMetricAttributionRequest): UpdateMetricAttributionResponse {
        val op = SdkHttpOperation.build<UpdateMetricAttributionRequest, UpdateMetricAttributionResponse> {
            serializer = UpdateMetricAttributionOperationSerializer()
            deserializer = UpdateMetricAttributionOperationDeserializer()
            operationName = "UpdateMetricAttribution"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the recommender to modify the recommender configuration. If you update the recommender to modify the columns used in training, Amazon Personalize automatically starts a full retraining of the models backing your recommender. While the update completes, you can still get recommendations from the recommender. The recommender uses the previous configuration until the update completes. To track the status of this update, use the `latestRecommenderUpdate` returned in the [DescribeRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html) operation.
     */
    override suspend fun updateRecommender(input: UpdateRecommenderRequest): UpdateRecommenderResponse {
        val op = SdkHttpOperation.build<UpdateRecommenderRequest, UpdateRecommenderResponse> {
            serializer = UpdateRecommenderOperationSerializer()
            deserializer = UpdateRecommenderOperationDeserializer()
            operationName = "UpdateRecommender"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonPersonalize", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsentNotNull(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "personalize")
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
