// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information on a batch segment job.
 */
public class BatchSegmentJob private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the batch segment job.
     */
    public val batchSegmentJobArn: kotlin.String? = builder.batchSegmentJobArn
    /**
     * The time at which the batch segment job was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * If the batch segment job failed, the reason for the failure.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The ARN of the filter used on the batch segment job.
     */
    public val filterArn: kotlin.String? = builder.filterArn
    /**
     * The Amazon S3 path that leads to the input data used to generate the batch segment job.
     */
    public val jobInput: aws.sdk.kotlin.services.personalize.model.BatchSegmentJobInput? = builder.jobInput
    /**
     * The name of the batch segment job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The Amazon S3 bucket that contains the output data generated by the batch segment job.
     */
    public val jobOutput: aws.sdk.kotlin.services.personalize.model.BatchSegmentJobOutput? = builder.jobOutput
    /**
     * The time at which the batch segment job last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The number of predicted users generated by the batch segment job for each line of input data. The maximum number of users per segment is 5 million.
     */
    public val numResults: kotlin.Int? = builder.numResults
    /**
     * The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch segment job.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.
     */
    public val solutionVersionArn: kotlin.String? = builder.solutionVersionArn
    /**
     * The status of the batch segment job. The status is one of the following values:
     * + PENDING
     * + IN PROGRESS
     * + ACTIVE
     * + CREATE FAILED
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.BatchSegmentJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchSegmentJob(")
        append("batchSegmentJobArn=$batchSegmentJobArn,")
        append("creationDateTime=$creationDateTime,")
        append("failureReason=$failureReason,")
        append("filterArn=$filterArn,")
        append("jobInput=$jobInput,")
        append("jobName=$jobName,")
        append("jobOutput=$jobOutput,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("numResults=$numResults,")
        append("roleArn=$roleArn,")
        append("solutionVersionArn=$solutionVersionArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchSegmentJobArn?.hashCode() ?: 0
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (filterArn?.hashCode() ?: 0)
        result = 31 * result + (jobInput?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobOutput?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (numResults ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (solutionVersionArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchSegmentJob

        if (batchSegmentJobArn != other.batchSegmentJobArn) return false
        if (creationDateTime != other.creationDateTime) return false
        if (failureReason != other.failureReason) return false
        if (filterArn != other.filterArn) return false
        if (jobInput != other.jobInput) return false
        if (jobName != other.jobName) return false
        if (jobOutput != other.jobOutput) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (numResults != other.numResults) return false
        if (roleArn != other.roleArn) return false
        if (solutionVersionArn != other.solutionVersionArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.BatchSegmentJob = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the batch segment job.
         */
        public var batchSegmentJobArn: kotlin.String? = null
        /**
         * The time at which the batch segment job was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the batch segment job failed, the reason for the failure.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The ARN of the filter used on the batch segment job.
         */
        public var filterArn: kotlin.String? = null
        /**
         * The Amazon S3 path that leads to the input data used to generate the batch segment job.
         */
        public var jobInput: aws.sdk.kotlin.services.personalize.model.BatchSegmentJobInput? = null
        /**
         * The name of the batch segment job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The Amazon S3 bucket that contains the output data generated by the batch segment job.
         */
        public var jobOutput: aws.sdk.kotlin.services.personalize.model.BatchSegmentJobOutput? = null
        /**
         * The time at which the batch segment job last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of predicted users generated by the batch segment job for each line of input data. The maximum number of users per segment is 5 million.
         */
        public var numResults: kotlin.Int? = null
        /**
         * The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch segment job.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.
         */
        public var solutionVersionArn: kotlin.String? = null
        /**
         * The status of the batch segment job. The status is one of the following values:
         * + PENDING
         * + IN PROGRESS
         * + ACTIVE
         * + CREATE FAILED
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.BatchSegmentJob) : this() {
            this.batchSegmentJobArn = x.batchSegmentJobArn
            this.creationDateTime = x.creationDateTime
            this.failureReason = x.failureReason
            this.filterArn = x.filterArn
            this.jobInput = x.jobInput
            this.jobName = x.jobName
            this.jobOutput = x.jobOutput
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.numResults = x.numResults
            this.roleArn = x.roleArn
            this.solutionVersionArn = x.solutionVersionArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.BatchSegmentJob = BatchSegmentJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.BatchSegmentJobInput] inside the given [block]
         */
        public fun jobInput(block: aws.sdk.kotlin.services.personalize.model.BatchSegmentJobInput.Builder.() -> kotlin.Unit) {
            this.jobInput = aws.sdk.kotlin.services.personalize.model.BatchSegmentJobInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.BatchSegmentJobOutput] inside the given [block]
         */
        public fun jobOutput(block: aws.sdk.kotlin.services.personalize.model.BatchSegmentJobOutput.Builder.() -> kotlin.Unit) {
            this.jobOutput = aws.sdk.kotlin.services.personalize.model.BatchSegmentJobOutput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
