// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.personalize.auth.DefaultPersonalizeAuthSchemeProvider
import aws.sdk.kotlin.services.personalize.auth.PersonalizeAuthSchemeProvider
import aws.sdk.kotlin.services.personalize.endpoints.DefaultPersonalizeEndpointProvider
import aws.sdk.kotlin.services.personalize.endpoints.PersonalizeEndpointParameters
import aws.sdk.kotlin.services.personalize.endpoints.PersonalizeEndpointProvider
import aws.sdk.kotlin.services.personalize.model.CreateBatchInferenceJobRequest
import aws.sdk.kotlin.services.personalize.model.CreateBatchInferenceJobResponse
import aws.sdk.kotlin.services.personalize.model.CreateBatchSegmentJobRequest
import aws.sdk.kotlin.services.personalize.model.CreateBatchSegmentJobResponse
import aws.sdk.kotlin.services.personalize.model.CreateCampaignRequest
import aws.sdk.kotlin.services.personalize.model.CreateCampaignResponse
import aws.sdk.kotlin.services.personalize.model.CreateDatasetExportJobRequest
import aws.sdk.kotlin.services.personalize.model.CreateDatasetExportJobResponse
import aws.sdk.kotlin.services.personalize.model.CreateDatasetGroupRequest
import aws.sdk.kotlin.services.personalize.model.CreateDatasetGroupResponse
import aws.sdk.kotlin.services.personalize.model.CreateDatasetImportJobRequest
import aws.sdk.kotlin.services.personalize.model.CreateDatasetImportJobResponse
import aws.sdk.kotlin.services.personalize.model.CreateDatasetRequest
import aws.sdk.kotlin.services.personalize.model.CreateDatasetResponse
import aws.sdk.kotlin.services.personalize.model.CreateEventTrackerRequest
import aws.sdk.kotlin.services.personalize.model.CreateEventTrackerResponse
import aws.sdk.kotlin.services.personalize.model.CreateFilterRequest
import aws.sdk.kotlin.services.personalize.model.CreateFilterResponse
import aws.sdk.kotlin.services.personalize.model.CreateMetricAttributionRequest
import aws.sdk.kotlin.services.personalize.model.CreateMetricAttributionResponse
import aws.sdk.kotlin.services.personalize.model.CreateRecommenderRequest
import aws.sdk.kotlin.services.personalize.model.CreateRecommenderResponse
import aws.sdk.kotlin.services.personalize.model.CreateSchemaRequest
import aws.sdk.kotlin.services.personalize.model.CreateSchemaResponse
import aws.sdk.kotlin.services.personalize.model.CreateSolutionRequest
import aws.sdk.kotlin.services.personalize.model.CreateSolutionResponse
import aws.sdk.kotlin.services.personalize.model.CreateSolutionVersionRequest
import aws.sdk.kotlin.services.personalize.model.CreateSolutionVersionResponse
import aws.sdk.kotlin.services.personalize.model.DeleteCampaignRequest
import aws.sdk.kotlin.services.personalize.model.DeleteCampaignResponse
import aws.sdk.kotlin.services.personalize.model.DeleteDatasetGroupRequest
import aws.sdk.kotlin.services.personalize.model.DeleteDatasetGroupResponse
import aws.sdk.kotlin.services.personalize.model.DeleteDatasetRequest
import aws.sdk.kotlin.services.personalize.model.DeleteDatasetResponse
import aws.sdk.kotlin.services.personalize.model.DeleteEventTrackerRequest
import aws.sdk.kotlin.services.personalize.model.DeleteEventTrackerResponse
import aws.sdk.kotlin.services.personalize.model.DeleteFilterRequest
import aws.sdk.kotlin.services.personalize.model.DeleteFilterResponse
import aws.sdk.kotlin.services.personalize.model.DeleteMetricAttributionRequest
import aws.sdk.kotlin.services.personalize.model.DeleteMetricAttributionResponse
import aws.sdk.kotlin.services.personalize.model.DeleteRecommenderRequest
import aws.sdk.kotlin.services.personalize.model.DeleteRecommenderResponse
import aws.sdk.kotlin.services.personalize.model.DeleteSchemaRequest
import aws.sdk.kotlin.services.personalize.model.DeleteSchemaResponse
import aws.sdk.kotlin.services.personalize.model.DeleteSolutionRequest
import aws.sdk.kotlin.services.personalize.model.DeleteSolutionResponse
import aws.sdk.kotlin.services.personalize.model.DescribeAlgorithmRequest
import aws.sdk.kotlin.services.personalize.model.DescribeAlgorithmResponse
import aws.sdk.kotlin.services.personalize.model.DescribeBatchInferenceJobRequest
import aws.sdk.kotlin.services.personalize.model.DescribeBatchInferenceJobResponse
import aws.sdk.kotlin.services.personalize.model.DescribeBatchSegmentJobRequest
import aws.sdk.kotlin.services.personalize.model.DescribeBatchSegmentJobResponse
import aws.sdk.kotlin.services.personalize.model.DescribeCampaignRequest
import aws.sdk.kotlin.services.personalize.model.DescribeCampaignResponse
import aws.sdk.kotlin.services.personalize.model.DescribeDatasetExportJobRequest
import aws.sdk.kotlin.services.personalize.model.DescribeDatasetExportJobResponse
import aws.sdk.kotlin.services.personalize.model.DescribeDatasetGroupRequest
import aws.sdk.kotlin.services.personalize.model.DescribeDatasetGroupResponse
import aws.sdk.kotlin.services.personalize.model.DescribeDatasetImportJobRequest
import aws.sdk.kotlin.services.personalize.model.DescribeDatasetImportJobResponse
import aws.sdk.kotlin.services.personalize.model.DescribeDatasetRequest
import aws.sdk.kotlin.services.personalize.model.DescribeDatasetResponse
import aws.sdk.kotlin.services.personalize.model.DescribeEventTrackerRequest
import aws.sdk.kotlin.services.personalize.model.DescribeEventTrackerResponse
import aws.sdk.kotlin.services.personalize.model.DescribeFeatureTransformationRequest
import aws.sdk.kotlin.services.personalize.model.DescribeFeatureTransformationResponse
import aws.sdk.kotlin.services.personalize.model.DescribeFilterRequest
import aws.sdk.kotlin.services.personalize.model.DescribeFilterResponse
import aws.sdk.kotlin.services.personalize.model.DescribeMetricAttributionRequest
import aws.sdk.kotlin.services.personalize.model.DescribeMetricAttributionResponse
import aws.sdk.kotlin.services.personalize.model.DescribeRecipeRequest
import aws.sdk.kotlin.services.personalize.model.DescribeRecipeResponse
import aws.sdk.kotlin.services.personalize.model.DescribeRecommenderRequest
import aws.sdk.kotlin.services.personalize.model.DescribeRecommenderResponse
import aws.sdk.kotlin.services.personalize.model.DescribeSchemaRequest
import aws.sdk.kotlin.services.personalize.model.DescribeSchemaResponse
import aws.sdk.kotlin.services.personalize.model.DescribeSolutionRequest
import aws.sdk.kotlin.services.personalize.model.DescribeSolutionResponse
import aws.sdk.kotlin.services.personalize.model.DescribeSolutionVersionRequest
import aws.sdk.kotlin.services.personalize.model.DescribeSolutionVersionResponse
import aws.sdk.kotlin.services.personalize.model.GetSolutionMetricsRequest
import aws.sdk.kotlin.services.personalize.model.GetSolutionMetricsResponse
import aws.sdk.kotlin.services.personalize.model.ListBatchInferenceJobsRequest
import aws.sdk.kotlin.services.personalize.model.ListBatchInferenceJobsResponse
import aws.sdk.kotlin.services.personalize.model.ListBatchSegmentJobsRequest
import aws.sdk.kotlin.services.personalize.model.ListBatchSegmentJobsResponse
import aws.sdk.kotlin.services.personalize.model.ListCampaignsRequest
import aws.sdk.kotlin.services.personalize.model.ListCampaignsResponse
import aws.sdk.kotlin.services.personalize.model.ListDatasetExportJobsRequest
import aws.sdk.kotlin.services.personalize.model.ListDatasetExportJobsResponse
import aws.sdk.kotlin.services.personalize.model.ListDatasetGroupsRequest
import aws.sdk.kotlin.services.personalize.model.ListDatasetGroupsResponse
import aws.sdk.kotlin.services.personalize.model.ListDatasetImportJobsRequest
import aws.sdk.kotlin.services.personalize.model.ListDatasetImportJobsResponse
import aws.sdk.kotlin.services.personalize.model.ListDatasetsRequest
import aws.sdk.kotlin.services.personalize.model.ListDatasetsResponse
import aws.sdk.kotlin.services.personalize.model.ListEventTrackersRequest
import aws.sdk.kotlin.services.personalize.model.ListEventTrackersResponse
import aws.sdk.kotlin.services.personalize.model.ListFiltersRequest
import aws.sdk.kotlin.services.personalize.model.ListFiltersResponse
import aws.sdk.kotlin.services.personalize.model.ListMetricAttributionMetricsRequest
import aws.sdk.kotlin.services.personalize.model.ListMetricAttributionMetricsResponse
import aws.sdk.kotlin.services.personalize.model.ListMetricAttributionsRequest
import aws.sdk.kotlin.services.personalize.model.ListMetricAttributionsResponse
import aws.sdk.kotlin.services.personalize.model.ListRecipesRequest
import aws.sdk.kotlin.services.personalize.model.ListRecipesResponse
import aws.sdk.kotlin.services.personalize.model.ListRecommendersRequest
import aws.sdk.kotlin.services.personalize.model.ListRecommendersResponse
import aws.sdk.kotlin.services.personalize.model.ListSchemasRequest
import aws.sdk.kotlin.services.personalize.model.ListSchemasResponse
import aws.sdk.kotlin.services.personalize.model.ListSolutionVersionsRequest
import aws.sdk.kotlin.services.personalize.model.ListSolutionVersionsResponse
import aws.sdk.kotlin.services.personalize.model.ListSolutionsRequest
import aws.sdk.kotlin.services.personalize.model.ListSolutionsResponse
import aws.sdk.kotlin.services.personalize.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.personalize.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.personalize.model.StartRecommenderRequest
import aws.sdk.kotlin.services.personalize.model.StartRecommenderResponse
import aws.sdk.kotlin.services.personalize.model.StopRecommenderRequest
import aws.sdk.kotlin.services.personalize.model.StopRecommenderResponse
import aws.sdk.kotlin.services.personalize.model.StopSolutionVersionCreationRequest
import aws.sdk.kotlin.services.personalize.model.StopSolutionVersionCreationResponse
import aws.sdk.kotlin.services.personalize.model.TagResourceRequest
import aws.sdk.kotlin.services.personalize.model.TagResourceResponse
import aws.sdk.kotlin.services.personalize.model.UntagResourceRequest
import aws.sdk.kotlin.services.personalize.model.UntagResourceResponse
import aws.sdk.kotlin.services.personalize.model.UpdateCampaignRequest
import aws.sdk.kotlin.services.personalize.model.UpdateCampaignResponse
import aws.sdk.kotlin.services.personalize.model.UpdateDatasetRequest
import aws.sdk.kotlin.services.personalize.model.UpdateDatasetResponse
import aws.sdk.kotlin.services.personalize.model.UpdateMetricAttributionRequest
import aws.sdk.kotlin.services.personalize.model.UpdateMetricAttributionResponse
import aws.sdk.kotlin.services.personalize.model.UpdateRecommenderRequest
import aws.sdk.kotlin.services.personalize.model.UpdateRecommenderResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Personalize"
public const val SdkVersion: String = "1.0.21"
public const val ServiceApiVersion: String = "2018-05-22"

/**
 * Amazon Personalize is a machine learning service that makes it easy to add individualized recommendations to customers.
 */
public interface PersonalizeClient : SdkClient {
    /**
     * PersonalizeClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, PersonalizeClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Personalize",
                "PERSONALIZE",
                "personalize",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, PersonalizeClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): PersonalizeClient = DefaultPersonalizeClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: PersonalizeEndpointProvider = builder.endpointProvider ?: DefaultPersonalizeEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: PersonalizeAuthSchemeProvider = builder.authSchemeProvider ?: DefaultPersonalizeAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Personalize"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: PersonalizeEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: PersonalizeAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Generates batch recommendations based on a list of items or users stored in Amazon S3 and exports the recommendations to an Amazon S3 bucket.
     *
     * To generate batch recommendations, specify the ARN of a solution version and an Amazon S3 URI for the input and output data. For user personalization, popular items, and personalized ranking solutions, the batch inference job generates a list of recommended items for each user ID in the input file. For related items solutions, the job generates a list of recommended items for each item ID in the input file.
     *
     * For more information, see [Creating a batch inference job ](https://docs.aws.amazon.com/personalize/latest/dg/getting-batch-recommendations.html).
     *
     *  If you use the Similar-Items recipe, Amazon Personalize can add descriptive themes to batch recommendations. To generate themes, set the job's mode to `THEME_GENERATION` and specify the name of the field that contains item names in the input data.
     *
     *  For more information about generating themes, see [Batch recommendations with themes from Content Generator ](https://docs.aws.amazon.com/personalize/latest/dg/themed-batch-recommendations.html).
     *
     * You can't get batch recommendations with the Trending-Now or Next-Best-Action recipes.
     */
    public suspend fun createBatchInferenceJob(input: CreateBatchInferenceJobRequest): CreateBatchInferenceJobResponse

    /**
     * Creates a batch segment job. The operation can handle up to 50 million records and the input file must be in JSON format. For more information, see [Getting batch recommendations and user segments](https://docs.aws.amazon.com/personalize/latest/dg/recommendations-batch.html).
     */
    public suspend fun createBatchSegmentJob(input: CreateBatchSegmentJobRequest): CreateBatchSegmentJobResponse

    /**
     * Creates a campaign that deploys a solution version. When a client calls the [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) and [GetPersonalizedRanking](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html) APIs, a campaign is specified in the request.
     *
     * **Minimum Provisioned TPS and Auto-Scaling**
     *
     *  A high `minProvisionedTPS` will increase your bill. We recommend starting with 1 for `minProvisionedTPS` (the default). Track your usage using Amazon CloudWatch metrics, and increase the `minProvisionedTPS` as necessary.
     *
     * A transaction is a single `GetRecommendations` or `GetPersonalizedRanking` call. Transactions per second (TPS) is the throughput and unit of billing for Amazon Personalize. The minimum provisioned TPS (`minProvisionedTPS`) specifies the baseline throughput provisioned by Amazon Personalize, and thus, the minimum billing charge.
     *
     *  If your TPS increases beyond `minProvisionedTPS`, Amazon Personalize auto-scales the provisioned capacity up and down, but never below `minProvisionedTPS`. There's a short time delay while the capacity is increased that might cause loss of transactions.
     *
     * The actual TPS used is calculated as the average requests/second within a 5-minute window. You pay for maximum of either the minimum provisioned TPS or the actual TPS. We recommend starting with a low `minProvisionedTPS`, track your usage using Amazon CloudWatch metrics, and then increase the `minProvisionedTPS` as necessary.
     *
     * **Status**
     *
     * A campaign can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the campaign status, call [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html).
     *
     * Wait until the `status` of the campaign is `ACTIVE` before asking the campaign for recommendations.
     *
     * **Related APIs**
     * + [ListCampaigns](https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html)
     * + [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html)
     * + [UpdateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateCampaign.html)
     * + [DeleteCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteCampaign.html)
     */
    public suspend fun createCampaign(input: CreateCampaignRequest): CreateCampaignResponse

    /**
     * Creates an empty dataset and adds it to the specified dataset group. Use [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html) to import your training data to a dataset.
     *
     * There are 5 types of datasets:
     * + Item interactions
     * + Items
     * + Users
     * + Action interactions
     * + Actions
     *
     * Each dataset type has an associated schema with required field types. Only the `Item interactions` dataset is required in order to train a model (also referred to as creating a solution).
     *
     * A dataset can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the status of the dataset, call [DescribeDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html).
     *
     * **Related APIs**
     * + [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html)
     * + [ListDatasets](https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasets.html)
     * + [DescribeDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html)
     * + [DeleteDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDataset.html)
     */
    public suspend fun createDataset(input: CreateDatasetRequest): CreateDatasetResponse

    /**
     * Creates a job that exports data from your dataset to an Amazon S3 bucket. To allow Amazon Personalize to export the training data, you must specify an service-linked IAM role that gives Amazon Personalize `PutObject` permissions for your Amazon S3 bucket. For information, see [Exporting a dataset](https://docs.aws.amazon.com/personalize/latest/dg/export-data.html) in the Amazon Personalize developer guide.
     *
     * **Status**
     *
     * A dataset export job can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     *
     *  To get the status of the export job, call [DescribeDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetExportJob.html), and specify the Amazon Resource Name (ARN) of the dataset export job. The dataset export is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the job failed.
     */
    public suspend fun createDatasetExportJob(input: CreateDatasetExportJobRequest): CreateDatasetExportJobResponse

    /**
     * Creates an empty dataset group. A dataset group is a container for Amazon Personalize resources. A dataset group can contain at most three datasets, one for each type of dataset:
     * + Item interactions
     * + Items
     * + Users
     * + Actions
     * + Action interactions
     *
     *  A dataset group can be a Domain dataset group, where you specify a domain and use pre-configured resources like recommenders, or a Custom dataset group, where you use custom resources, such as a solution with a solution version, that you deploy with a campaign. If you start with a Domain dataset group, you can still add custom resources such as solutions and solution versions trained with recipes for custom use cases and deployed with campaigns.
     *
     * A dataset group can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING
     *
     * To get the status of the dataset group, call [DescribeDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html). If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the creation failed.
     *
     * You must wait until the `status` of the dataset group is `ACTIVE` before adding a dataset to the group.
     *
     * You can specify an Key Management Service (KMS) key to encrypt the datasets in the group. If you specify a KMS key, you must also include an Identity and Access Management (IAM) role that has permission to access the key.
     *
     * **APIs that require a dataset group ARN in the request**
     * + [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html)
     * + [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html)
     * + [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
     *
     * **Related APIs**
     * + [ListDatasetGroups](https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetGroups.html)
     * + [DescribeDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html)
     * + [DeleteDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDatasetGroup.html)
     */
    public suspend fun createDatasetGroup(input: CreateDatasetGroupRequest): CreateDatasetGroupResponse

    /**
     * Creates a job that imports training data from your data source (an Amazon S3 bucket) to an Amazon Personalize dataset. To allow Amazon Personalize to import the training data, you must specify an IAM service role that has permission to read from the data source, as Amazon Personalize makes a copy of your data and processes it internally. For information on granting access to your Amazon S3 bucket, see [Giving Amazon Personalize Access to Amazon S3 Resources](https://docs.aws.amazon.com/personalize/latest/dg/granting-personalize-s3-access.html).
     *
     * If you already created a recommender or deployed a custom solution version with a campaign, how new bulk records influence recommendations depends on the domain use case or recipe that you use. For more information, see [How new data influences real-time recommendations](https://docs.aws.amazon.com/personalize/latest/dg/how-new-data-influences-recommendations.html).
     *
     * By default, a dataset import job replaces any existing data in the dataset that you imported in bulk. To add new records without replacing existing data, specify INCREMENTAL for the import mode in the CreateDatasetImportJob operation.
     *
     * **Status**
     *
     * A dataset import job can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     *
     * To get the status of the import job, call [DescribeDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html), providing the Amazon Resource Name (ARN) of the dataset import job. The dataset import is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the job failed.
     *
     * Importing takes time. You must wait until the status shows as ACTIVE before training a model using the dataset.
     *
     * **Related APIs**
     * + [ListDatasetImportJobs](https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetImportJobs.html)
     * + [DescribeDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html)
     */
    public suspend fun createDatasetImportJob(input: CreateDatasetImportJobRequest): CreateDatasetImportJobResponse

    /**
     * Creates an event tracker that you use when adding event data to a specified dataset group using the [PutEvents](https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html) API.
     *
     * Only one event tracker can be associated with a dataset group. You will get an error if you call `CreateEventTracker` using the same dataset group as an existing event tracker.
     *
     * When you create an event tracker, the response includes a tracking ID, which you pass as a parameter when you use the [PutEvents](https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html) operation. Amazon Personalize then appends the event data to the Item interactions dataset of the dataset group you specify in your event tracker.
     *
     * The event tracker can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the status of the event tracker, call [DescribeEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html).
     *
     * The event tracker must be in the ACTIVE state before using the tracking ID.
     *
     * **Related APIs**
     * + [ListEventTrackers](https://docs.aws.amazon.com/personalize/latest/dg/API_ListEventTrackers.html)
     * + [DescribeEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html)
     * + [DeleteEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteEventTracker.html)
     */
    public suspend fun createEventTracker(input: CreateEventTrackerRequest): CreateEventTrackerResponse

    /**
     * Creates a recommendation filter. For more information, see [Filtering recommendations and user segments](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
     */
    public suspend fun createFilter(input: CreateFilterRequest): CreateFilterResponse

    /**
     * Creates a metric attribution. A metric attribution creates reports on the data that you import into Amazon Personalize. Depending on how you imported the data, you can view reports in Amazon CloudWatch or Amazon S3. For more information, see [Measuring impact of recommendations](https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html).
     */
    public suspend fun createMetricAttribution(input: CreateMetricAttributionRequest): CreateMetricAttributionResponse

    /**
     * Creates a recommender with the recipe (a Domain dataset group use case) you specify. You create recommenders for a Domain dataset group and specify the recommender's Amazon Resource Name (ARN) when you make a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request.
     *
     * **Minimum recommendation requests per second**
     *
     * A high `minRecommendationRequestsPerSecond` will increase your bill. We recommend starting with 1 for `minRecommendationRequestsPerSecond` (the default). Track your usage using Amazon CloudWatch metrics, and increase the `minRecommendationRequestsPerSecond` as necessary.
     *
     * When you create a recommender, you can configure the recommender's minimum recommendation requests per second. The minimum recommendation requests per second (`minRecommendationRequestsPerSecond`) specifies the baseline recommendation request throughput provisioned by Amazon Personalize. The default minRecommendationRequestsPerSecond is `1`. A recommendation request is a single `GetRecommendations` operation. Request throughput is measured in requests per second and Amazon Personalize uses your requests per second to derive your requests per hour and the price of your recommender usage.
     *
     *  If your requests per second increases beyond `minRecommendationRequestsPerSecond`, Amazon Personalize auto-scales the provisioned capacity up and down, but never below `minRecommendationRequestsPerSecond`. There's a short time delay while the capacity is increased that might cause loss of requests.
     *
     *  Your bill is the greater of either the minimum requests per hour (based on minRecommendationRequestsPerSecond) or the actual number of requests. The actual request throughput used is calculated as the average requests/second within a one-hour window. We recommend starting with the default `minRecommendationRequestsPerSecond`, track your usage using Amazon CloudWatch metrics, and then increase the `minRecommendationRequestsPerSecond` as necessary.
     *
     * **Status**
     *
     * A recommender can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS > ACTIVE
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the recommender status, call [DescribeRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html).
     *
     * Wait until the `status` of the recommender is `ACTIVE` before asking the recommender for recommendations.
     *
     * **Related APIs**
     * + [ListRecommenders](https://docs.aws.amazon.com/personalize/latest/dg/API_ListRecommenders.html)
     * + [DescribeRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html)
     * + [UpdateRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateRecommender.html)
     * + [DeleteRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteRecommender.html)
     */
    public suspend fun createRecommender(input: CreateRecommenderRequest): CreateRecommenderResponse

    /**
     * Creates an Amazon Personalize schema from the specified schema string. The schema you create must be in Avro JSON format.
     *
     * Amazon Personalize recognizes three schema variants. Each schema is associated with a dataset type and has a set of required field and keywords. If you are creating a schema for a dataset in a Domain dataset group, you provide the domain of the Domain dataset group. You specify a schema when you call [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     *
     * **Related APIs**
     * + [ListSchemas](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSchemas.html)
     * + [DescribeSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSchema.html)
     * + [DeleteSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSchema.html)
     */
    public suspend fun createSchema(input: CreateSchemaRequest): CreateSchemaResponse

    /**
     * Creates the configuration for training a model. A trained model is known as a solution version. After the configuration is created, you train the model (create a solution version) by calling the [CreateSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html) operation. Every time you call `CreateSolutionVersion`, a new version of the solution is created.
     *
     * After creating a solution version, you check its accuracy by calling [GetSolutionMetrics](https://docs.aws.amazon.com/personalize/latest/dg/API_GetSolutionMetrics.html). When you are satisfied with the version, you deploy it using [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html). The campaign provides recommendations to a client through the [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) API.
     *
     * To train a model, Amazon Personalize requires training data and a recipe. The training data comes from the dataset group that you provide in the request. A recipe specifies the training algorithm and a feature transformation. You can specify one of the predefined recipes provided by Amazon Personalize.
     *
     * Amazon Personalize doesn't support configuring the `hpoObjective` for solution hyperparameter optimization at this time.
     *
     * **Status**
     *
     * A solution can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * To get the status of the solution, call [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html). Wait until the status shows as ACTIVE before calling `CreateSolutionVersion`.
     *
     * **Related APIs**
     * + [ListSolutions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html)
     * + [CreateSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html)
     * + [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html)
     * + [DeleteSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html)
     *
     * + [ListSolutionVersions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html)
     * + [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html)
     */
    public suspend fun createSolution(input: CreateSolutionRequest): CreateSolutionResponse

    /**
     * Trains or retrains an active solution in a Custom dataset group. A solution is created using the [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html) operation and must be in the ACTIVE state before calling `CreateSolutionVersion`. A new version of the solution is created every time you call this operation.
     *
     * **Status**
     *
     * A solution version can be in one of the following states:
     * + CREATE PENDING
     * + CREATE IN_PROGRESS
     * + ACTIVE
     * + CREATE FAILED
     * + CREATE STOPPING
     * + CREATE STOPPED
     *
     * To get the status of the version, call [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html). Wait until the status shows as ACTIVE before calling `CreateCampaign`.
     *
     * If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the job failed.
     *
     * **Related APIs**
     * + [ListSolutionVersions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html)
     * + [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html)
     * + [ListSolutions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html)
     * + [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
     * + [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html)
     * + [DeleteSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html)
     */
    public suspend fun createSolutionVersion(input: CreateSolutionVersionRequest): CreateSolutionVersionResponse

    /**
     * Removes a campaign by deleting the solution deployment. The solution that the campaign is based on is not deleted and can be redeployed when needed. A deleted campaign can no longer be specified in a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request. For information on creating campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
     */
    public suspend fun deleteCampaign(input: DeleteCampaignRequest): DeleteCampaignResponse

    /**
     * Deletes a dataset. You can't delete a dataset if an associated `DatasetImportJob` or `SolutionVersion` is in the CREATE PENDING or IN PROGRESS state. For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    public suspend fun deleteDataset(input: DeleteDatasetRequest): DeleteDatasetResponse

    /**
     * Deletes a dataset group. Before you delete a dataset group, you must delete the following:
     * + All associated event trackers.
     * + All associated solutions.
     * + All datasets in the dataset group.
     */
    public suspend fun deleteDatasetGroup(input: DeleteDatasetGroupRequest): DeleteDatasetGroupResponse

    /**
     * Deletes the event tracker. Does not delete the dataset from the dataset group. For more information on event trackers, see [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
     */
    public suspend fun deleteEventTracker(input: DeleteEventTrackerRequest): DeleteEventTrackerResponse

    /**
     * Deletes a filter.
     */
    public suspend fun deleteFilter(input: DeleteFilterRequest): DeleteFilterResponse

    /**
     * Deletes a metric attribution.
     */
    public suspend fun deleteMetricAttribution(input: DeleteMetricAttributionRequest): DeleteMetricAttributionResponse

    /**
     * Deactivates and removes a recommender. A deleted recommender can no longer be specified in a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request.
     */
    public suspend fun deleteRecommender(input: DeleteRecommenderRequest): DeleteRecommenderResponse

    /**
     * Deletes a schema. Before deleting a schema, you must delete all datasets referencing the schema. For more information on schemas, see [CreateSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
     */
    public suspend fun deleteSchema(input: DeleteSchemaRequest): DeleteSchemaResponse

    /**
     * Deletes all versions of a solution and the `Solution` object itself. Before deleting a solution, you must delete all campaigns based on the solution. To determine what campaigns are using the solution, call [ListCampaigns](https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html) and supply the Amazon Resource Name (ARN) of the solution. You can't delete a solution if an associated `SolutionVersion` is in the CREATE PENDING or IN PROGRESS state. For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
     */
    public suspend fun deleteSolution(input: DeleteSolutionRequest): DeleteSolutionResponse

    /**
     * Describes the given algorithm.
     */
    public suspend fun describeAlgorithm(input: DescribeAlgorithmRequest): DescribeAlgorithmResponse

    /**
     * Gets the properties of a batch inference job including name, Amazon Resource Name (ARN), status, input and output configurations, and the ARN of the solution version used to generate the recommendations.
     */
    public suspend fun describeBatchInferenceJob(input: DescribeBatchInferenceJobRequest): DescribeBatchInferenceJobResponse

    /**
     * Gets the properties of a batch segment job including name, Amazon Resource Name (ARN), status, input and output configurations, and the ARN of the solution version used to generate segments.
     */
    public suspend fun describeBatchSegmentJob(input: DescribeBatchSegmentJobRequest): DescribeBatchSegmentJobResponse

    /**
     * Describes the given campaign, including its status.
     *
     * A campaign can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * When the `status` is `CREATE FAILED`, the response includes the `failureReason` key, which describes why.
     *
     * For more information on campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
     */
    public suspend fun describeCampaign(input: DescribeCampaignRequest): DescribeCampaignResponse

    /**
     * Describes the given dataset. For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    public suspend fun describeDataset(input: DescribeDatasetRequest): DescribeDatasetResponse

    /**
     * Describes the dataset export job created by [CreateDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html), including the export job status.
     */
    public suspend fun describeDatasetExportJob(input: DescribeDatasetExportJobRequest): DescribeDatasetExportJobResponse

    /**
     * Describes the given dataset group. For more information on dataset groups, see [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html).
     */
    public suspend fun describeDatasetGroup(input: DescribeDatasetGroupRequest): DescribeDatasetGroupResponse

    /**
     * Describes the dataset import job created by [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html), including the import job status.
     */
    public suspend fun describeDatasetImportJob(input: DescribeDatasetImportJobRequest): DescribeDatasetImportJobResponse

    /**
     * Describes an event tracker. The response includes the `trackingId` and `status` of the event tracker. For more information on event trackers, see [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
     */
    public suspend fun describeEventTracker(input: DescribeEventTrackerRequest): DescribeEventTrackerResponse

    /**
     * Describes the given feature transformation.
     */
    public suspend fun describeFeatureTransformation(input: DescribeFeatureTransformationRequest): DescribeFeatureTransformationResponse

    /**
     * Describes a filter's properties.
     */
    public suspend fun describeFilter(input: DescribeFilterRequest): DescribeFilterResponse

    /**
     * Describes a metric attribution.
     */
    public suspend fun describeMetricAttribution(input: DescribeMetricAttributionRequest): DescribeMetricAttributionResponse

    /**
     * Describes a recipe.
     *
     * A recipe contains three items:
     * + An algorithm that trains a model.
     * + Hyperparameters that govern the training.
     * + Feature transformation information for modifying the input data before training.
     *
     * Amazon Personalize provides a set of predefined recipes. You specify a recipe when you create a solution with the [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html) API. `CreateSolution` trains a model by using the algorithm in the specified recipe and a training dataset. The solution, when deployed as a campaign, can provide recommendations using the [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) API.
     */
    public suspend fun describeRecipe(input: DescribeRecipeRequest): DescribeRecipeResponse

    /**
     * Describes the given recommender, including its status.
     *
     * A recommender can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS > ACTIVE
     * + DELETE PENDING > DELETE IN_PROGRESS
     *
     * When the `status` is `CREATE FAILED`, the response includes the `failureReason` key, which describes why.
     *
     * The `modelMetrics` key is null when the recommender is being created or deleted.
     *
     * For more information on recommenders, see [CreateRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html).
     */
    public suspend fun describeRecommender(input: DescribeRecommenderRequest): DescribeRecommenderResponse

    /**
     * Describes a schema. For more information on schemas, see [CreateSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
     */
    public suspend fun describeSchema(input: DescribeSchemaRequest): DescribeSchemaResponse

    /**
     * Describes a solution. For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
     */
    public suspend fun describeSolution(input: DescribeSolutionRequest): DescribeSolutionResponse

    /**
     * Describes a specific version of a solution. For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
     */
    public suspend fun describeSolutionVersion(input: DescribeSolutionVersionRequest): DescribeSolutionVersionResponse

    /**
     * Gets the metrics for the specified solution version.
     */
    public suspend fun getSolutionMetrics(input: GetSolutionMetricsRequest): GetSolutionMetricsResponse

    /**
     * Gets a list of the batch inference jobs that have been performed off of a solution version.
     */
    public suspend fun listBatchInferenceJobs(input: ListBatchInferenceJobsRequest = ListBatchInferenceJobsRequest { }): ListBatchInferenceJobsResponse

    /**
     * Gets a list of the batch segment jobs that have been performed off of a solution version that you specify.
     */
    public suspend fun listBatchSegmentJobs(input: ListBatchSegmentJobsRequest = ListBatchSegmentJobsRequest { }): ListBatchSegmentJobsResponse

    /**
     * Returns a list of campaigns that use the given solution. When a solution is not specified, all the campaigns associated with the account are listed. The response provides the properties for each campaign, including the Amazon Resource Name (ARN). For more information on campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
     */
    public suspend fun listCampaigns(input: ListCampaignsRequest = ListCampaignsRequest { }): ListCampaignsResponse

    /**
     * Returns a list of dataset export jobs that use the given dataset. When a dataset is not specified, all the dataset export jobs associated with the account are listed. The response provides the properties for each dataset export job, including the Amazon Resource Name (ARN). For more information on dataset export jobs, see [CreateDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html). For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    public suspend fun listDatasetExportJobs(input: ListDatasetExportJobsRequest = ListDatasetExportJobsRequest { }): ListDatasetExportJobsResponse

    /**
     * Returns a list of dataset groups. The response provides the properties for each dataset group, including the Amazon Resource Name (ARN). For more information on dataset groups, see [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html).
     */
    public suspend fun listDatasetGroups(input: ListDatasetGroupsRequest = ListDatasetGroupsRequest { }): ListDatasetGroupsResponse

    /**
     * Returns a list of dataset import jobs that use the given dataset. When a dataset is not specified, all the dataset import jobs associated with the account are listed. The response provides the properties for each dataset import job, including the Amazon Resource Name (ARN). For more information on dataset import jobs, see [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html). For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    public suspend fun listDatasetImportJobs(input: ListDatasetImportJobsRequest = ListDatasetImportJobsRequest { }): ListDatasetImportJobsResponse

    /**
     * Returns the list of datasets contained in the given dataset group. The response provides the properties for each dataset, including the Amazon Resource Name (ARN). For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
     */
    public suspend fun listDatasets(input: ListDatasetsRequest = ListDatasetsRequest { }): ListDatasetsResponse

    /**
     * Returns the list of event trackers associated with the account. The response provides the properties for each event tracker, including the Amazon Resource Name (ARN) and tracking ID. For more information on event trackers, see [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
     */
    public suspend fun listEventTrackers(input: ListEventTrackersRequest = ListEventTrackersRequest { }): ListEventTrackersResponse

    /**
     * Lists all filters that belong to a given dataset group.
     */
    public suspend fun listFilters(input: ListFiltersRequest = ListFiltersRequest { }): ListFiltersResponse

    /**
     * Lists the metrics for the metric attribution.
     */
    public suspend fun listMetricAttributionMetrics(input: ListMetricAttributionMetricsRequest = ListMetricAttributionMetricsRequest { }): ListMetricAttributionMetricsResponse

    /**
     * Lists metric attributions.
     */
    public suspend fun listMetricAttributions(input: ListMetricAttributionsRequest = ListMetricAttributionsRequest { }): ListMetricAttributionsResponse

    /**
     * Returns a list of available recipes. The response provides the properties for each recipe, including the recipe's Amazon Resource Name (ARN).
     */
    public suspend fun listRecipes(input: ListRecipesRequest = ListRecipesRequest { }): ListRecipesResponse

    /**
     * Returns a list of recommenders in a given Domain dataset group. When a Domain dataset group is not specified, all the recommenders associated with the account are listed. The response provides the properties for each recommender, including the Amazon Resource Name (ARN). For more information on recommenders, see [CreateRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html).
     */
    public suspend fun listRecommenders(input: ListRecommendersRequest = ListRecommendersRequest { }): ListRecommendersResponse

    /**
     * Returns the list of schemas associated with the account. The response provides the properties for each schema, including the Amazon Resource Name (ARN). For more information on schemas, see [CreateSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
     */
    public suspend fun listSchemas(input: ListSchemasRequest = ListSchemasRequest { }): ListSchemasResponse

    /**
     * Returns a list of solution versions for the given solution. When a solution is not specified, all the solution versions associated with the account are listed. The response provides the properties for each solution version, including the Amazon Resource Name (ARN).
     */
    public suspend fun listSolutionVersions(input: ListSolutionVersionsRequest = ListSolutionVersionsRequest { }): ListSolutionVersionsResponse

    /**
     * Returns a list of solutions that use the given dataset group. When a dataset group is not specified, all the solutions associated with the account are listed. The response provides the properties for each solution, including the Amazon Resource Name (ARN). For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
     */
    public suspend fun listSolutions(input: ListSolutionsRequest = ListSolutionsRequest { }): ListSolutionsResponse

    /**
     * Get a list of [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) attached to a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Starts a recommender that is INACTIVE. Starting a recommender does not create any new models, but resumes billing and automatic retraining for the recommender.
     */
    public suspend fun startRecommender(input: StartRecommenderRequest): StartRecommenderResponse

    /**
     * Stops a recommender that is ACTIVE. Stopping a recommender halts billing and automatic retraining for the recommender.
     */
    public suspend fun stopRecommender(input: StopRecommenderRequest): StopRecommenderResponse

    /**
     * Stops creating a solution version that is in a state of CREATE_PENDING or CREATE IN_PROGRESS.
     *
     * Depending on the current state of the solution version, the solution version state changes as follows:
     * + CREATE_PENDING > CREATE_STOPPEDor
     * + CREATE_IN_PROGRESS > CREATE_STOPPING > CREATE_STOPPED
     *
     * You are billed for all of the training completed up until you stop the solution version creation. You cannot resume creating a solution version once it has been stopped.
     */
    public suspend fun stopSolutionVersionCreation(input: StopSolutionVersionCreationRequest): StopSolutionVersionCreationResponse

    /**
     * Add a list of tags to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Remove [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) that are attached to a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a campaign to deploy a retrained solution version with an existing campaign, change your campaign's `minProvisionedTPS`, or modify your campaign's configuration, such as the exploration configuration.
     *
     * To update a campaign, the campaign status must be ACTIVE or CREATE FAILED. Check the campaign status using the [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html) operation.
     *
     * You can still get recommendations from a campaign while an update is in progress. The campaign will use the previous solution version and campaign configuration to generate recommendations until the latest campaign update status is `Active`.
     *
     * For more information about updating a campaign, including code samples, see [Updating a campaign](https://docs.aws.amazon.com/personalize/latest/dg/update-campaigns.html). For more information about campaigns, see [Creating a campaign](https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html).
     */
    public suspend fun updateCampaign(input: UpdateCampaignRequest): UpdateCampaignResponse

    /**
     * Update a dataset to replace its schema with a new or existing one. For more information, see [Replacing a dataset's schema](https://docs.aws.amazon.com/personalize/latest/dg/updating-dataset-schema.html).
     */
    public suspend fun updateDataset(input: UpdateDatasetRequest): UpdateDatasetResponse

    /**
     * Updates a metric attribution.
     */
    public suspend fun updateMetricAttribution(input: UpdateMetricAttributionRequest = UpdateMetricAttributionRequest { }): UpdateMetricAttributionResponse

    /**
     * Updates the recommender to modify the recommender configuration. If you update the recommender to modify the columns used in training, Amazon Personalize automatically starts a full retraining of the models backing your recommender. While the update completes, you can still get recommendations from the recommender. The recommender uses the previous configuration until the update completes. To track the status of this update, use the `latestRecommenderUpdate` returned in the [DescribeRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html) operation.
     */
    public suspend fun updateRecommender(input: UpdateRecommenderRequest): UpdateRecommenderResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun PersonalizeClient.withConfig(block: PersonalizeClient.Config.Builder.() -> Unit): PersonalizeClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultPersonalizeClient(newConfig)
}

/**
 * Generates batch recommendations based on a list of items or users stored in Amazon S3 and exports the recommendations to an Amazon S3 bucket.
 *
 * To generate batch recommendations, specify the ARN of a solution version and an Amazon S3 URI for the input and output data. For user personalization, popular items, and personalized ranking solutions, the batch inference job generates a list of recommended items for each user ID in the input file. For related items solutions, the job generates a list of recommended items for each item ID in the input file.
 *
 * For more information, see [Creating a batch inference job ](https://docs.aws.amazon.com/personalize/latest/dg/getting-batch-recommendations.html).
 *
 *  If you use the Similar-Items recipe, Amazon Personalize can add descriptive themes to batch recommendations. To generate themes, set the job's mode to `THEME_GENERATION` and specify the name of the field that contains item names in the input data.
 *
 *  For more information about generating themes, see [Batch recommendations with themes from Content Generator ](https://docs.aws.amazon.com/personalize/latest/dg/themed-batch-recommendations.html).
 *
 * You can't get batch recommendations with the Trending-Now or Next-Best-Action recipes.
 */
public suspend inline fun PersonalizeClient.createBatchInferenceJob(crossinline block: CreateBatchInferenceJobRequest.Builder.() -> Unit): CreateBatchInferenceJobResponse = createBatchInferenceJob(CreateBatchInferenceJobRequest.Builder().apply(block).build())

/**
 * Creates a batch segment job. The operation can handle up to 50 million records and the input file must be in JSON format. For more information, see [Getting batch recommendations and user segments](https://docs.aws.amazon.com/personalize/latest/dg/recommendations-batch.html).
 */
public suspend inline fun PersonalizeClient.createBatchSegmentJob(crossinline block: CreateBatchSegmentJobRequest.Builder.() -> Unit): CreateBatchSegmentJobResponse = createBatchSegmentJob(CreateBatchSegmentJobRequest.Builder().apply(block).build())

/**
 * Creates a campaign that deploys a solution version. When a client calls the [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) and [GetPersonalizedRanking](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html) APIs, a campaign is specified in the request.
 *
 * **Minimum Provisioned TPS and Auto-Scaling**
 *
 *  A high `minProvisionedTPS` will increase your bill. We recommend starting with 1 for `minProvisionedTPS` (the default). Track your usage using Amazon CloudWatch metrics, and increase the `minProvisionedTPS` as necessary.
 *
 * A transaction is a single `GetRecommendations` or `GetPersonalizedRanking` call. Transactions per second (TPS) is the throughput and unit of billing for Amazon Personalize. The minimum provisioned TPS (`minProvisionedTPS`) specifies the baseline throughput provisioned by Amazon Personalize, and thus, the minimum billing charge.
 *
 *  If your TPS increases beyond `minProvisionedTPS`, Amazon Personalize auto-scales the provisioned capacity up and down, but never below `minProvisionedTPS`. There's a short time delay while the capacity is increased that might cause loss of transactions.
 *
 * The actual TPS used is calculated as the average requests/second within a 5-minute window. You pay for maximum of either the minimum provisioned TPS or the actual TPS. We recommend starting with a low `minProvisionedTPS`, track your usage using Amazon CloudWatch metrics, and then increase the `minProvisionedTPS` as necessary.
 *
 * **Status**
 *
 * A campaign can be in one of the following states:
 * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
 * + DELETE PENDING > DELETE IN_PROGRESS
 *
 * To get the campaign status, call [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html).
 *
 * Wait until the `status` of the campaign is `ACTIVE` before asking the campaign for recommendations.
 *
 * **Related APIs**
 * + [ListCampaigns](https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html)
 * + [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html)
 * + [UpdateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateCampaign.html)
 * + [DeleteCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteCampaign.html)
 */
public suspend inline fun PersonalizeClient.createCampaign(crossinline block: CreateCampaignRequest.Builder.() -> Unit): CreateCampaignResponse = createCampaign(CreateCampaignRequest.Builder().apply(block).build())

/**
 * Creates an empty dataset and adds it to the specified dataset group. Use [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html) to import your training data to a dataset.
 *
 * There are 5 types of datasets:
 * + Item interactions
 * + Items
 * + Users
 * + Action interactions
 * + Actions
 *
 * Each dataset type has an associated schema with required field types. Only the `Item interactions` dataset is required in order to train a model (also referred to as creating a solution).
 *
 * A dataset can be in one of the following states:
 * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
 * + DELETE PENDING > DELETE IN_PROGRESS
 *
 * To get the status of the dataset, call [DescribeDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html).
 *
 * **Related APIs**
 * + [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html)
 * + [ListDatasets](https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasets.html)
 * + [DescribeDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html)
 * + [DeleteDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDataset.html)
 */
public suspend inline fun PersonalizeClient.createDataset(crossinline block: CreateDatasetRequest.Builder.() -> Unit): CreateDatasetResponse = createDataset(CreateDatasetRequest.Builder().apply(block).build())

/**
 * Creates a job that exports data from your dataset to an Amazon S3 bucket. To allow Amazon Personalize to export the training data, you must specify an service-linked IAM role that gives Amazon Personalize `PutObject` permissions for your Amazon S3 bucket. For information, see [Exporting a dataset](https://docs.aws.amazon.com/personalize/latest/dg/export-data.html) in the Amazon Personalize developer guide.
 *
 * **Status**
 *
 * A dataset export job can be in one of the following states:
 * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
 *
 *  To get the status of the export job, call [DescribeDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetExportJob.html), and specify the Amazon Resource Name (ARN) of the dataset export job. The dataset export is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the job failed.
 */
public suspend inline fun PersonalizeClient.createDatasetExportJob(crossinline block: CreateDatasetExportJobRequest.Builder.() -> Unit): CreateDatasetExportJobResponse = createDatasetExportJob(CreateDatasetExportJobRequest.Builder().apply(block).build())

/**
 * Creates an empty dataset group. A dataset group is a container for Amazon Personalize resources. A dataset group can contain at most three datasets, one for each type of dataset:
 * + Item interactions
 * + Items
 * + Users
 * + Actions
 * + Action interactions
 *
 *  A dataset group can be a Domain dataset group, where you specify a domain and use pre-configured resources like recommenders, or a Custom dataset group, where you use custom resources, such as a solution with a solution version, that you deploy with a campaign. If you start with a Domain dataset group, you can still add custom resources such as solutions and solution versions trained with recipes for custom use cases and deployed with campaigns.
 *
 * A dataset group can be in one of the following states:
 * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
 * + DELETE PENDING
 *
 * To get the status of the dataset group, call [DescribeDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html). If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the creation failed.
 *
 * You must wait until the `status` of the dataset group is `ACTIVE` before adding a dataset to the group.
 *
 * You can specify an Key Management Service (KMS) key to encrypt the datasets in the group. If you specify a KMS key, you must also include an Identity and Access Management (IAM) role that has permission to access the key.
 *
 * **APIs that require a dataset group ARN in the request**
 * + [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html)
 * + [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html)
 * + [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
 *
 * **Related APIs**
 * + [ListDatasetGroups](https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetGroups.html)
 * + [DescribeDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html)
 * + [DeleteDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDatasetGroup.html)
 */
public suspend inline fun PersonalizeClient.createDatasetGroup(crossinline block: CreateDatasetGroupRequest.Builder.() -> Unit): CreateDatasetGroupResponse = createDatasetGroup(CreateDatasetGroupRequest.Builder().apply(block).build())

/**
 * Creates a job that imports training data from your data source (an Amazon S3 bucket) to an Amazon Personalize dataset. To allow Amazon Personalize to import the training data, you must specify an IAM service role that has permission to read from the data source, as Amazon Personalize makes a copy of your data and processes it internally. For information on granting access to your Amazon S3 bucket, see [Giving Amazon Personalize Access to Amazon S3 Resources](https://docs.aws.amazon.com/personalize/latest/dg/granting-personalize-s3-access.html).
 *
 * If you already created a recommender or deployed a custom solution version with a campaign, how new bulk records influence recommendations depends on the domain use case or recipe that you use. For more information, see [How new data influences real-time recommendations](https://docs.aws.amazon.com/personalize/latest/dg/how-new-data-influences-recommendations.html).
 *
 * By default, a dataset import job replaces any existing data in the dataset that you imported in bulk. To add new records without replacing existing data, specify INCREMENTAL for the import mode in the CreateDatasetImportJob operation.
 *
 * **Status**
 *
 * A dataset import job can be in one of the following states:
 * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
 *
 * To get the status of the import job, call [DescribeDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html), providing the Amazon Resource Name (ARN) of the dataset import job. The dataset import is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the job failed.
 *
 * Importing takes time. You must wait until the status shows as ACTIVE before training a model using the dataset.
 *
 * **Related APIs**
 * + [ListDatasetImportJobs](https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetImportJobs.html)
 * + [DescribeDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html)
 */
public suspend inline fun PersonalizeClient.createDatasetImportJob(crossinline block: CreateDatasetImportJobRequest.Builder.() -> Unit): CreateDatasetImportJobResponse = createDatasetImportJob(CreateDatasetImportJobRequest.Builder().apply(block).build())

/**
 * Creates an event tracker that you use when adding event data to a specified dataset group using the [PutEvents](https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html) API.
 *
 * Only one event tracker can be associated with a dataset group. You will get an error if you call `CreateEventTracker` using the same dataset group as an existing event tracker.
 *
 * When you create an event tracker, the response includes a tracking ID, which you pass as a parameter when you use the [PutEvents](https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html) operation. Amazon Personalize then appends the event data to the Item interactions dataset of the dataset group you specify in your event tracker.
 *
 * The event tracker can be in one of the following states:
 * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
 * + DELETE PENDING > DELETE IN_PROGRESS
 *
 * To get the status of the event tracker, call [DescribeEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html).
 *
 * The event tracker must be in the ACTIVE state before using the tracking ID.
 *
 * **Related APIs**
 * + [ListEventTrackers](https://docs.aws.amazon.com/personalize/latest/dg/API_ListEventTrackers.html)
 * + [DescribeEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html)
 * + [DeleteEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteEventTracker.html)
 */
public suspend inline fun PersonalizeClient.createEventTracker(crossinline block: CreateEventTrackerRequest.Builder.() -> Unit): CreateEventTrackerResponse = createEventTracker(CreateEventTrackerRequest.Builder().apply(block).build())

/**
 * Creates a recommendation filter. For more information, see [Filtering recommendations and user segments](https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
 */
public suspend inline fun PersonalizeClient.createFilter(crossinline block: CreateFilterRequest.Builder.() -> Unit): CreateFilterResponse = createFilter(CreateFilterRequest.Builder().apply(block).build())

/**
 * Creates a metric attribution. A metric attribution creates reports on the data that you import into Amazon Personalize. Depending on how you imported the data, you can view reports in Amazon CloudWatch or Amazon S3. For more information, see [Measuring impact of recommendations](https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html).
 */
public suspend inline fun PersonalizeClient.createMetricAttribution(crossinline block: CreateMetricAttributionRequest.Builder.() -> Unit): CreateMetricAttributionResponse = createMetricAttribution(CreateMetricAttributionRequest.Builder().apply(block).build())

/**
 * Creates a recommender with the recipe (a Domain dataset group use case) you specify. You create recommenders for a Domain dataset group and specify the recommender's Amazon Resource Name (ARN) when you make a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request.
 *
 * **Minimum recommendation requests per second**
 *
 * A high `minRecommendationRequestsPerSecond` will increase your bill. We recommend starting with 1 for `minRecommendationRequestsPerSecond` (the default). Track your usage using Amazon CloudWatch metrics, and increase the `minRecommendationRequestsPerSecond` as necessary.
 *
 * When you create a recommender, you can configure the recommender's minimum recommendation requests per second. The minimum recommendation requests per second (`minRecommendationRequestsPerSecond`) specifies the baseline recommendation request throughput provisioned by Amazon Personalize. The default minRecommendationRequestsPerSecond is `1`. A recommendation request is a single `GetRecommendations` operation. Request throughput is measured in requests per second and Amazon Personalize uses your requests per second to derive your requests per hour and the price of your recommender usage.
 *
 *  If your requests per second increases beyond `minRecommendationRequestsPerSecond`, Amazon Personalize auto-scales the provisioned capacity up and down, but never below `minRecommendationRequestsPerSecond`. There's a short time delay while the capacity is increased that might cause loss of requests.
 *
 *  Your bill is the greater of either the minimum requests per hour (based on minRecommendationRequestsPerSecond) or the actual number of requests. The actual request throughput used is calculated as the average requests/second within a one-hour window. We recommend starting with the default `minRecommendationRequestsPerSecond`, track your usage using Amazon CloudWatch metrics, and then increase the `minRecommendationRequestsPerSecond` as necessary.
 *
 * **Status**
 *
 * A recommender can be in one of the following states:
 * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
 * + STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS > ACTIVE
 * + DELETE PENDING > DELETE IN_PROGRESS
 *
 * To get the recommender status, call [DescribeRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html).
 *
 * Wait until the `status` of the recommender is `ACTIVE` before asking the recommender for recommendations.
 *
 * **Related APIs**
 * + [ListRecommenders](https://docs.aws.amazon.com/personalize/latest/dg/API_ListRecommenders.html)
 * + [DescribeRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html)
 * + [UpdateRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateRecommender.html)
 * + [DeleteRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteRecommender.html)
 */
public suspend inline fun PersonalizeClient.createRecommender(crossinline block: CreateRecommenderRequest.Builder.() -> Unit): CreateRecommenderResponse = createRecommender(CreateRecommenderRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Personalize schema from the specified schema string. The schema you create must be in Avro JSON format.
 *
 * Amazon Personalize recognizes three schema variants. Each schema is associated with a dataset type and has a set of required field and keywords. If you are creating a schema for a dataset in a Domain dataset group, you provide the domain of the Domain dataset group. You specify a schema when you call [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
 *
 * **Related APIs**
 * + [ListSchemas](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSchemas.html)
 * + [DescribeSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSchema.html)
 * + [DeleteSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSchema.html)
 */
public suspend inline fun PersonalizeClient.createSchema(crossinline block: CreateSchemaRequest.Builder.() -> Unit): CreateSchemaResponse = createSchema(CreateSchemaRequest.Builder().apply(block).build())

/**
 * Creates the configuration for training a model. A trained model is known as a solution version. After the configuration is created, you train the model (create a solution version) by calling the [CreateSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html) operation. Every time you call `CreateSolutionVersion`, a new version of the solution is created.
 *
 * After creating a solution version, you check its accuracy by calling [GetSolutionMetrics](https://docs.aws.amazon.com/personalize/latest/dg/API_GetSolutionMetrics.html). When you are satisfied with the version, you deploy it using [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html). The campaign provides recommendations to a client through the [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) API.
 *
 * To train a model, Amazon Personalize requires training data and a recipe. The training data comes from the dataset group that you provide in the request. A recipe specifies the training algorithm and a feature transformation. You can specify one of the predefined recipes provided by Amazon Personalize.
 *
 * Amazon Personalize doesn't support configuring the `hpoObjective` for solution hyperparameter optimization at this time.
 *
 * **Status**
 *
 * A solution can be in one of the following states:
 * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
 * + DELETE PENDING > DELETE IN_PROGRESS
 *
 * To get the status of the solution, call [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html). Wait until the status shows as ACTIVE before calling `CreateSolutionVersion`.
 *
 * **Related APIs**
 * + [ListSolutions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html)
 * + [CreateSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html)
 * + [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html)
 * + [DeleteSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html)
 *
 * + [ListSolutionVersions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html)
 * + [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html)
 */
public suspend inline fun PersonalizeClient.createSolution(crossinline block: CreateSolutionRequest.Builder.() -> Unit): CreateSolutionResponse = createSolution(CreateSolutionRequest.Builder().apply(block).build())

/**
 * Trains or retrains an active solution in a Custom dataset group. A solution is created using the [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html) operation and must be in the ACTIVE state before calling `CreateSolutionVersion`. A new version of the solution is created every time you call this operation.
 *
 * **Status**
 *
 * A solution version can be in one of the following states:
 * + CREATE PENDING
 * + CREATE IN_PROGRESS
 * + ACTIVE
 * + CREATE FAILED
 * + CREATE STOPPING
 * + CREATE STOPPED
 *
 * To get the status of the version, call [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html). Wait until the status shows as ACTIVE before calling `CreateCampaign`.
 *
 * If the status shows as CREATE FAILED, the response includes a `failureReason` key, which describes why the job failed.
 *
 * **Related APIs**
 * + [ListSolutionVersions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html)
 * + [DescribeSolutionVersion](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html)
 * + [ListSolutions](https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html)
 * + [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
 * + [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html)
 * + [DeleteSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html)
 */
public suspend inline fun PersonalizeClient.createSolutionVersion(crossinline block: CreateSolutionVersionRequest.Builder.() -> Unit): CreateSolutionVersionResponse = createSolutionVersion(CreateSolutionVersionRequest.Builder().apply(block).build())

/**
 * Removes a campaign by deleting the solution deployment. The solution that the campaign is based on is not deleted and can be redeployed when needed. A deleted campaign can no longer be specified in a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request. For information on creating campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
 */
public suspend inline fun PersonalizeClient.deleteCampaign(crossinline block: DeleteCampaignRequest.Builder.() -> Unit): DeleteCampaignResponse = deleteCampaign(DeleteCampaignRequest.Builder().apply(block).build())

/**
 * Deletes a dataset. You can't delete a dataset if an associated `DatasetImportJob` or `SolutionVersion` is in the CREATE PENDING or IN PROGRESS state. For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
 */
public suspend inline fun PersonalizeClient.deleteDataset(crossinline block: DeleteDatasetRequest.Builder.() -> Unit): DeleteDatasetResponse = deleteDataset(DeleteDatasetRequest.Builder().apply(block).build())

/**
 * Deletes a dataset group. Before you delete a dataset group, you must delete the following:
 * + All associated event trackers.
 * + All associated solutions.
 * + All datasets in the dataset group.
 */
public suspend inline fun PersonalizeClient.deleteDatasetGroup(crossinline block: DeleteDatasetGroupRequest.Builder.() -> Unit): DeleteDatasetGroupResponse = deleteDatasetGroup(DeleteDatasetGroupRequest.Builder().apply(block).build())

/**
 * Deletes the event tracker. Does not delete the dataset from the dataset group. For more information on event trackers, see [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
 */
public suspend inline fun PersonalizeClient.deleteEventTracker(crossinline block: DeleteEventTrackerRequest.Builder.() -> Unit): DeleteEventTrackerResponse = deleteEventTracker(DeleteEventTrackerRequest.Builder().apply(block).build())

/**
 * Deletes a filter.
 */
public suspend inline fun PersonalizeClient.deleteFilter(crossinline block: DeleteFilterRequest.Builder.() -> Unit): DeleteFilterResponse = deleteFilter(DeleteFilterRequest.Builder().apply(block).build())

/**
 * Deletes a metric attribution.
 */
public suspend inline fun PersonalizeClient.deleteMetricAttribution(crossinline block: DeleteMetricAttributionRequest.Builder.() -> Unit): DeleteMetricAttributionResponse = deleteMetricAttribution(DeleteMetricAttributionRequest.Builder().apply(block).build())

/**
 * Deactivates and removes a recommender. A deleted recommender can no longer be specified in a [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) request.
 */
public suspend inline fun PersonalizeClient.deleteRecommender(crossinline block: DeleteRecommenderRequest.Builder.() -> Unit): DeleteRecommenderResponse = deleteRecommender(DeleteRecommenderRequest.Builder().apply(block).build())

/**
 * Deletes a schema. Before deleting a schema, you must delete all datasets referencing the schema. For more information on schemas, see [CreateSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
 */
public suspend inline fun PersonalizeClient.deleteSchema(crossinline block: DeleteSchemaRequest.Builder.() -> Unit): DeleteSchemaResponse = deleteSchema(DeleteSchemaRequest.Builder().apply(block).build())

/**
 * Deletes all versions of a solution and the `Solution` object itself. Before deleting a solution, you must delete all campaigns based on the solution. To determine what campaigns are using the solution, call [ListCampaigns](https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html) and supply the Amazon Resource Name (ARN) of the solution. You can't delete a solution if an associated `SolutionVersion` is in the CREATE PENDING or IN PROGRESS state. For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
 */
public suspend inline fun PersonalizeClient.deleteSolution(crossinline block: DeleteSolutionRequest.Builder.() -> Unit): DeleteSolutionResponse = deleteSolution(DeleteSolutionRequest.Builder().apply(block).build())

/**
 * Describes the given algorithm.
 */
public suspend inline fun PersonalizeClient.describeAlgorithm(crossinline block: DescribeAlgorithmRequest.Builder.() -> Unit): DescribeAlgorithmResponse = describeAlgorithm(DescribeAlgorithmRequest.Builder().apply(block).build())

/**
 * Gets the properties of a batch inference job including name, Amazon Resource Name (ARN), status, input and output configurations, and the ARN of the solution version used to generate the recommendations.
 */
public suspend inline fun PersonalizeClient.describeBatchInferenceJob(crossinline block: DescribeBatchInferenceJobRequest.Builder.() -> Unit): DescribeBatchInferenceJobResponse = describeBatchInferenceJob(DescribeBatchInferenceJobRequest.Builder().apply(block).build())

/**
 * Gets the properties of a batch segment job including name, Amazon Resource Name (ARN), status, input and output configurations, and the ARN of the solution version used to generate segments.
 */
public suspend inline fun PersonalizeClient.describeBatchSegmentJob(crossinline block: DescribeBatchSegmentJobRequest.Builder.() -> Unit): DescribeBatchSegmentJobResponse = describeBatchSegmentJob(DescribeBatchSegmentJobRequest.Builder().apply(block).build())

/**
 * Describes the given campaign, including its status.
 *
 * A campaign can be in one of the following states:
 * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
 * + DELETE PENDING > DELETE IN_PROGRESS
 *
 * When the `status` is `CREATE FAILED`, the response includes the `failureReason` key, which describes why.
 *
 * For more information on campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
 */
public suspend inline fun PersonalizeClient.describeCampaign(crossinline block: DescribeCampaignRequest.Builder.() -> Unit): DescribeCampaignResponse = describeCampaign(DescribeCampaignRequest.Builder().apply(block).build())

/**
 * Describes the given dataset. For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
 */
public suspend inline fun PersonalizeClient.describeDataset(crossinline block: DescribeDatasetRequest.Builder.() -> Unit): DescribeDatasetResponse = describeDataset(DescribeDatasetRequest.Builder().apply(block).build())

/**
 * Describes the dataset export job created by [CreateDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html), including the export job status.
 */
public suspend inline fun PersonalizeClient.describeDatasetExportJob(crossinline block: DescribeDatasetExportJobRequest.Builder.() -> Unit): DescribeDatasetExportJobResponse = describeDatasetExportJob(DescribeDatasetExportJobRequest.Builder().apply(block).build())

/**
 * Describes the given dataset group. For more information on dataset groups, see [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html).
 */
public suspend inline fun PersonalizeClient.describeDatasetGroup(crossinline block: DescribeDatasetGroupRequest.Builder.() -> Unit): DescribeDatasetGroupResponse = describeDatasetGroup(DescribeDatasetGroupRequest.Builder().apply(block).build())

/**
 * Describes the dataset import job created by [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html), including the import job status.
 */
public suspend inline fun PersonalizeClient.describeDatasetImportJob(crossinline block: DescribeDatasetImportJobRequest.Builder.() -> Unit): DescribeDatasetImportJobResponse = describeDatasetImportJob(DescribeDatasetImportJobRequest.Builder().apply(block).build())

/**
 * Describes an event tracker. The response includes the `trackingId` and `status` of the event tracker. For more information on event trackers, see [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
 */
public suspend inline fun PersonalizeClient.describeEventTracker(crossinline block: DescribeEventTrackerRequest.Builder.() -> Unit): DescribeEventTrackerResponse = describeEventTracker(DescribeEventTrackerRequest.Builder().apply(block).build())

/**
 * Describes the given feature transformation.
 */
public suspend inline fun PersonalizeClient.describeFeatureTransformation(crossinline block: DescribeFeatureTransformationRequest.Builder.() -> Unit): DescribeFeatureTransformationResponse = describeFeatureTransformation(DescribeFeatureTransformationRequest.Builder().apply(block).build())

/**
 * Describes a filter's properties.
 */
public suspend inline fun PersonalizeClient.describeFilter(crossinline block: DescribeFilterRequest.Builder.() -> Unit): DescribeFilterResponse = describeFilter(DescribeFilterRequest.Builder().apply(block).build())

/**
 * Describes a metric attribution.
 */
public suspend inline fun PersonalizeClient.describeMetricAttribution(crossinline block: DescribeMetricAttributionRequest.Builder.() -> Unit): DescribeMetricAttributionResponse = describeMetricAttribution(DescribeMetricAttributionRequest.Builder().apply(block).build())

/**
 * Describes a recipe.
 *
 * A recipe contains three items:
 * + An algorithm that trains a model.
 * + Hyperparameters that govern the training.
 * + Feature transformation information for modifying the input data before training.
 *
 * Amazon Personalize provides a set of predefined recipes. You specify a recipe when you create a solution with the [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html) API. `CreateSolution` trains a model by using the algorithm in the specified recipe and a training dataset. The solution, when deployed as a campaign, can provide recommendations using the [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html) API.
 */
public suspend inline fun PersonalizeClient.describeRecipe(crossinline block: DescribeRecipeRequest.Builder.() -> Unit): DescribeRecipeResponse = describeRecipe(DescribeRecipeRequest.Builder().apply(block).build())

/**
 * Describes the given recommender, including its status.
 *
 * A recommender can be in one of the following states:
 * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
 * + STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS > ACTIVE
 * + DELETE PENDING > DELETE IN_PROGRESS
 *
 * When the `status` is `CREATE FAILED`, the response includes the `failureReason` key, which describes why.
 *
 * The `modelMetrics` key is null when the recommender is being created or deleted.
 *
 * For more information on recommenders, see [CreateRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html).
 */
public suspend inline fun PersonalizeClient.describeRecommender(crossinline block: DescribeRecommenderRequest.Builder.() -> Unit): DescribeRecommenderResponse = describeRecommender(DescribeRecommenderRequest.Builder().apply(block).build())

/**
 * Describes a schema. For more information on schemas, see [CreateSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
 */
public suspend inline fun PersonalizeClient.describeSchema(crossinline block: DescribeSchemaRequest.Builder.() -> Unit): DescribeSchemaResponse = describeSchema(DescribeSchemaRequest.Builder().apply(block).build())

/**
 * Describes a solution. For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
 */
public suspend inline fun PersonalizeClient.describeSolution(crossinline block: DescribeSolutionRequest.Builder.() -> Unit): DescribeSolutionResponse = describeSolution(DescribeSolutionRequest.Builder().apply(block).build())

/**
 * Describes a specific version of a solution. For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
 */
public suspend inline fun PersonalizeClient.describeSolutionVersion(crossinline block: DescribeSolutionVersionRequest.Builder.() -> Unit): DescribeSolutionVersionResponse = describeSolutionVersion(DescribeSolutionVersionRequest.Builder().apply(block).build())

/**
 * Gets the metrics for the specified solution version.
 */
public suspend inline fun PersonalizeClient.getSolutionMetrics(crossinline block: GetSolutionMetricsRequest.Builder.() -> Unit): GetSolutionMetricsResponse = getSolutionMetrics(GetSolutionMetricsRequest.Builder().apply(block).build())

/**
 * Gets a list of the batch inference jobs that have been performed off of a solution version.
 */
public suspend inline fun PersonalizeClient.listBatchInferenceJobs(crossinline block: ListBatchInferenceJobsRequest.Builder.() -> Unit): ListBatchInferenceJobsResponse = listBatchInferenceJobs(ListBatchInferenceJobsRequest.Builder().apply(block).build())

/**
 * Gets a list of the batch segment jobs that have been performed off of a solution version that you specify.
 */
public suspend inline fun PersonalizeClient.listBatchSegmentJobs(crossinline block: ListBatchSegmentJobsRequest.Builder.() -> Unit): ListBatchSegmentJobsResponse = listBatchSegmentJobs(ListBatchSegmentJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of campaigns that use the given solution. When a solution is not specified, all the campaigns associated with the account are listed. The response provides the properties for each campaign, including the Amazon Resource Name (ARN). For more information on campaigns, see [CreateCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
 */
public suspend inline fun PersonalizeClient.listCampaigns(crossinline block: ListCampaignsRequest.Builder.() -> Unit): ListCampaignsResponse = listCampaigns(ListCampaignsRequest.Builder().apply(block).build())

/**
 * Returns a list of dataset export jobs that use the given dataset. When a dataset is not specified, all the dataset export jobs associated with the account are listed. The response provides the properties for each dataset export job, including the Amazon Resource Name (ARN). For more information on dataset export jobs, see [CreateDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html). For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
 */
public suspend inline fun PersonalizeClient.listDatasetExportJobs(crossinline block: ListDatasetExportJobsRequest.Builder.() -> Unit): ListDatasetExportJobsResponse = listDatasetExportJobs(ListDatasetExportJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of dataset groups. The response provides the properties for each dataset group, including the Amazon Resource Name (ARN). For more information on dataset groups, see [CreateDatasetGroup](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html).
 */
public suspend inline fun PersonalizeClient.listDatasetGroups(crossinline block: ListDatasetGroupsRequest.Builder.() -> Unit): ListDatasetGroupsResponse = listDatasetGroups(ListDatasetGroupsRequest.Builder().apply(block).build())

/**
 * Returns a list of dataset import jobs that use the given dataset. When a dataset is not specified, all the dataset import jobs associated with the account are listed. The response provides the properties for each dataset import job, including the Amazon Resource Name (ARN). For more information on dataset import jobs, see [CreateDatasetImportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html). For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
 */
public suspend inline fun PersonalizeClient.listDatasetImportJobs(crossinline block: ListDatasetImportJobsRequest.Builder.() -> Unit): ListDatasetImportJobsResponse = listDatasetImportJobs(ListDatasetImportJobsRequest.Builder().apply(block).build())

/**
 * Returns the list of datasets contained in the given dataset group. The response provides the properties for each dataset, including the Amazon Resource Name (ARN). For more information on datasets, see [CreateDataset](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
 */
public suspend inline fun PersonalizeClient.listDatasets(crossinline block: ListDatasetsRequest.Builder.() -> Unit): ListDatasetsResponse = listDatasets(ListDatasetsRequest.Builder().apply(block).build())

/**
 * Returns the list of event trackers associated with the account. The response provides the properties for each event tracker, including the Amazon Resource Name (ARN) and tracking ID. For more information on event trackers, see [CreateEventTracker](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
 */
public suspend inline fun PersonalizeClient.listEventTrackers(crossinline block: ListEventTrackersRequest.Builder.() -> Unit): ListEventTrackersResponse = listEventTrackers(ListEventTrackersRequest.Builder().apply(block).build())

/**
 * Lists all filters that belong to a given dataset group.
 */
public suspend inline fun PersonalizeClient.listFilters(crossinline block: ListFiltersRequest.Builder.() -> Unit): ListFiltersResponse = listFilters(ListFiltersRequest.Builder().apply(block).build())

/**
 * Lists the metrics for the metric attribution.
 */
public suspend inline fun PersonalizeClient.listMetricAttributionMetrics(crossinline block: ListMetricAttributionMetricsRequest.Builder.() -> Unit): ListMetricAttributionMetricsResponse = listMetricAttributionMetrics(ListMetricAttributionMetricsRequest.Builder().apply(block).build())

/**
 * Lists metric attributions.
 */
public suspend inline fun PersonalizeClient.listMetricAttributions(crossinline block: ListMetricAttributionsRequest.Builder.() -> Unit): ListMetricAttributionsResponse = listMetricAttributions(ListMetricAttributionsRequest.Builder().apply(block).build())

/**
 * Returns a list of available recipes. The response provides the properties for each recipe, including the recipe's Amazon Resource Name (ARN).
 */
public suspend inline fun PersonalizeClient.listRecipes(crossinline block: ListRecipesRequest.Builder.() -> Unit): ListRecipesResponse = listRecipes(ListRecipesRequest.Builder().apply(block).build())

/**
 * Returns a list of recommenders in a given Domain dataset group. When a Domain dataset group is not specified, all the recommenders associated with the account are listed. The response provides the properties for each recommender, including the Amazon Resource Name (ARN). For more information on recommenders, see [CreateRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html).
 */
public suspend inline fun PersonalizeClient.listRecommenders(crossinline block: ListRecommendersRequest.Builder.() -> Unit): ListRecommendersResponse = listRecommenders(ListRecommendersRequest.Builder().apply(block).build())

/**
 * Returns the list of schemas associated with the account. The response provides the properties for each schema, including the Amazon Resource Name (ARN). For more information on schemas, see [CreateSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
 */
public suspend inline fun PersonalizeClient.listSchemas(crossinline block: ListSchemasRequest.Builder.() -> Unit): ListSchemasResponse = listSchemas(ListSchemasRequest.Builder().apply(block).build())

/**
 * Returns a list of solution versions for the given solution. When a solution is not specified, all the solution versions associated with the account are listed. The response provides the properties for each solution version, including the Amazon Resource Name (ARN).
 */
public suspend inline fun PersonalizeClient.listSolutionVersions(crossinline block: ListSolutionVersionsRequest.Builder.() -> Unit): ListSolutionVersionsResponse = listSolutionVersions(ListSolutionVersionsRequest.Builder().apply(block).build())

/**
 * Returns a list of solutions that use the given dataset group. When a dataset group is not specified, all the solutions associated with the account are listed. The response provides the properties for each solution, including the Amazon Resource Name (ARN). For more information on solutions, see [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
 */
public suspend inline fun PersonalizeClient.listSolutions(crossinline block: ListSolutionsRequest.Builder.() -> Unit): ListSolutionsResponse = listSolutions(ListSolutionsRequest.Builder().apply(block).build())

/**
 * Get a list of [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) attached to a resource.
 */
public suspend inline fun PersonalizeClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts a recommender that is INACTIVE. Starting a recommender does not create any new models, but resumes billing and automatic retraining for the recommender.
 */
public suspend inline fun PersonalizeClient.startRecommender(crossinline block: StartRecommenderRequest.Builder.() -> Unit): StartRecommenderResponse = startRecommender(StartRecommenderRequest.Builder().apply(block).build())

/**
 * Stops a recommender that is ACTIVE. Stopping a recommender halts billing and automatic retraining for the recommender.
 */
public suspend inline fun PersonalizeClient.stopRecommender(crossinline block: StopRecommenderRequest.Builder.() -> Unit): StopRecommenderResponse = stopRecommender(StopRecommenderRequest.Builder().apply(block).build())

/**
 * Stops creating a solution version that is in a state of CREATE_PENDING or CREATE IN_PROGRESS.
 *
 * Depending on the current state of the solution version, the solution version state changes as follows:
 * + CREATE_PENDING > CREATE_STOPPEDor
 * + CREATE_IN_PROGRESS > CREATE_STOPPING > CREATE_STOPPED
 *
 * You are billed for all of the training completed up until you stop the solution version creation. You cannot resume creating a solution version once it has been stopped.
 */
public suspend inline fun PersonalizeClient.stopSolutionVersionCreation(crossinline block: StopSolutionVersionCreationRequest.Builder.() -> Unit): StopSolutionVersionCreationResponse = stopSolutionVersionCreation(StopSolutionVersionCreationRequest.Builder().apply(block).build())

/**
 * Add a list of tags to a resource.
 */
public suspend inline fun PersonalizeClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Remove [tags](https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html) that are attached to a resource.
 */
public suspend inline fun PersonalizeClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a campaign to deploy a retrained solution version with an existing campaign, change your campaign's `minProvisionedTPS`, or modify your campaign's configuration, such as the exploration configuration.
 *
 * To update a campaign, the campaign status must be ACTIVE or CREATE FAILED. Check the campaign status using the [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html) operation.
 *
 * You can still get recommendations from a campaign while an update is in progress. The campaign will use the previous solution version and campaign configuration to generate recommendations until the latest campaign update status is `Active`.
 *
 * For more information about updating a campaign, including code samples, see [Updating a campaign](https://docs.aws.amazon.com/personalize/latest/dg/update-campaigns.html). For more information about campaigns, see [Creating a campaign](https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html).
 */
public suspend inline fun PersonalizeClient.updateCampaign(crossinline block: UpdateCampaignRequest.Builder.() -> Unit): UpdateCampaignResponse = updateCampaign(UpdateCampaignRequest.Builder().apply(block).build())

/**
 * Update a dataset to replace its schema with a new or existing one. For more information, see [Replacing a dataset's schema](https://docs.aws.amazon.com/personalize/latest/dg/updating-dataset-schema.html).
 */
public suspend inline fun PersonalizeClient.updateDataset(crossinline block: UpdateDatasetRequest.Builder.() -> Unit): UpdateDatasetResponse = updateDataset(UpdateDatasetRequest.Builder().apply(block).build())

/**
 * Updates a metric attribution.
 */
public suspend inline fun PersonalizeClient.updateMetricAttribution(crossinline block: UpdateMetricAttributionRequest.Builder.() -> Unit): UpdateMetricAttributionResponse = updateMetricAttribution(UpdateMetricAttributionRequest.Builder().apply(block).build())

/**
 * Updates the recommender to modify the recommender configuration. If you update the recommender to modify the columns used in training, Amazon Personalize automatically starts a full retraining of the models backing your recommender. While the update completes, you can still get recommendations from the recommender. The recommender uses the previous configuration until the update completes. To track the status of this update, use the `latestRecommenderUpdate` returned in the [DescribeRecommender](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html) operation.
 */
public suspend inline fun PersonalizeClient.updateRecommender(crossinline block: UpdateRecommenderRequest.Builder.() -> Unit): UpdateRecommenderResponse = updateRecommender(UpdateRecommenderRequest.Builder().apply(block).build())
