// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.transform

import aws.sdk.kotlin.services.personalize.model.CreateEventTrackerResponse
import aws.sdk.kotlin.services.personalize.model.PersonalizeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateEventTrackerOperationDeserializer: HttpDeserialize<CreateEventTrackerResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateEventTrackerResponse {
        if (!response.status.isSuccess()) {
            throwCreateEventTrackerError(context, response)
        }
        val builder = CreateEventTrackerResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateEventTrackerOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateEventTrackerError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw PersonalizeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceInUseException" -> ResourceInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyTagsException" -> TooManyTagsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> PersonalizeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateEventTrackerOperationBody(builder: CreateEventTrackerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EVENTTRACKERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("eventTrackerArn"))
    val TRACKINGID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("trackingId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EVENTTRACKERARN_DESCRIPTOR)
        field(TRACKINGID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EVENTTRACKERARN_DESCRIPTOR.index -> builder.eventTrackerArn = deserializeString()
                TRACKINGID_DESCRIPTOR.index -> builder.trackingId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
