// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the properties of a solution. For a complete listing, call the [DescribeSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html) API.
 */
public class SolutionSummary private constructor(builder: Builder) {
    /**
     * The date and time (in Unix time) that the solution was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The date and time (in Unix time) that the solution was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the solution.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the recipe used by the solution.
     */
    public val recipeArn: kotlin.String? = builder.recipeArn
    /**
     * The Amazon Resource Name (ARN) of the solution.
     */
    public val solutionArn: kotlin.String? = builder.solutionArn
    /**
     * The status of the solution.
     *
     * A solution can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.SolutionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SolutionSummary(")
        append("creationDateTime=$creationDateTime,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("recipeArn=$recipeArn,")
        append("solutionArn=$solutionArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (recipeArn?.hashCode() ?: 0)
        result = 31 * result + (solutionArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SolutionSummary

        if (creationDateTime != other.creationDateTime) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (recipeArn != other.recipeArn) return false
        if (solutionArn != other.solutionArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.SolutionSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time (in Unix time) that the solution was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time (in Unix time) that the solution was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the solution.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the recipe used by the solution.
         */
        public var recipeArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the solution.
         */
        public var solutionArn: kotlin.String? = null
        /**
         * The status of the solution.
         *
         * A solution can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         * + DELETE PENDING > DELETE IN_PROGRESS
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.SolutionSummary) : this() {
            this.creationDateTime = x.creationDateTime
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.recipeArn = x.recipeArn
            this.solutionArn = x.solutionArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.SolutionSummary = SolutionSummary(this)
    }
}
