// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the properties of the recommender.
 */
public class RecommenderSummary private constructor(builder: Builder) {
    /**
     * The date and time (in Unix format) that the recommender was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The Amazon Resource Name (ARN) of the Domain dataset group that contains the recommender.
     */
    public val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * The date and time (in Unix format) that the recommender was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the recommender.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case) that the recommender was created for.
     */
    public val recipeArn: kotlin.String? = builder.recipeArn
    /**
     * The Amazon Resource Name (ARN) of the recommender.
     */
    public val recommenderArn: kotlin.String? = builder.recommenderArn
    /**
     * The configuration details of the recommender.
     */
    public val recommenderConfig: aws.sdk.kotlin.services.personalize.model.RecommenderConfig? = builder.recommenderConfig
    /**
     * The status of the recommender. A recommender can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS > ACTIVE
     * + DELETE PENDING > DELETE IN_PROGRESS
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.RecommenderSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommenderSummary(")
        append("creationDateTime=$creationDateTime,")
        append("datasetGroupArn=$datasetGroupArn,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("recipeArn=$recipeArn,")
        append("recommenderArn=$recommenderArn,")
        append("recommenderConfig=$recommenderConfig,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (datasetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (recipeArn?.hashCode() ?: 0)
        result = 31 * result + (recommenderArn?.hashCode() ?: 0)
        result = 31 * result + (recommenderConfig?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommenderSummary

        if (creationDateTime != other.creationDateTime) return false
        if (datasetGroupArn != other.datasetGroupArn) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (recipeArn != other.recipeArn) return false
        if (recommenderArn != other.recommenderArn) return false
        if (recommenderConfig != other.recommenderConfig) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.RecommenderSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time (in Unix format) that the recommender was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the Domain dataset group that contains the recommender.
         */
        public var datasetGroupArn: kotlin.String? = null
        /**
         * The date and time (in Unix format) that the recommender was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the recommender.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case) that the recommender was created for.
         */
        public var recipeArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the recommender.
         */
        public var recommenderArn: kotlin.String? = null
        /**
         * The configuration details of the recommender.
         */
        public var recommenderConfig: aws.sdk.kotlin.services.personalize.model.RecommenderConfig? = null
        /**
         * The status of the recommender. A recommender can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         * + STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS > ACTIVE
         * + DELETE PENDING > DELETE IN_PROGRESS
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.RecommenderSummary) : this() {
            this.creationDateTime = x.creationDateTime
            this.datasetGroupArn = x.datasetGroupArn
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.recipeArn = x.recipeArn
            this.recommenderArn = x.recommenderArn
            this.recommenderConfig = x.recommenderConfig
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.RecommenderSummary = RecommenderSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.RecommenderConfig] inside the given [block]
         */
        public fun recommenderConfig(block: aws.sdk.kotlin.services.personalize.model.RecommenderConfig.Builder.() -> kotlin.Unit) {
            this.recommenderConfig = aws.sdk.kotlin.services.personalize.model.RecommenderConfig.invoke(block)
        }
    }
}
