// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the properties of a recipe. For a complete listing, call the [DescribeRecipe](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecipe.html) API.
 */
public class RecipeSummary private constructor(builder: Builder) {
    /**
     * The date and time (in Unix time) that the recipe was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The domain of the recipe (if the recipe is a Domain dataset group use case).
     */
    public val domain: aws.sdk.kotlin.services.personalize.model.Domain? = builder.domain
    /**
     * The date and time (in Unix time) that the recipe was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the recipe.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the recipe.
     */
    public val recipeArn: kotlin.String? = builder.recipeArn
    /**
     * The status of the recipe.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.RecipeSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecipeSummary(")
        append("creationDateTime=$creationDateTime,")
        append("domain=$domain,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("recipeArn=$recipeArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (recipeArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecipeSummary

        if (creationDateTime != other.creationDateTime) return false
        if (domain != other.domain) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (recipeArn != other.recipeArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.RecipeSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time (in Unix time) that the recipe was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The domain of the recipe (if the recipe is a Domain dataset group use case).
         */
        public var domain: aws.sdk.kotlin.services.personalize.model.Domain? = null
        /**
         * The date and time (in Unix time) that the recipe was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the recipe.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the recipe.
         */
        public var recipeArn: kotlin.String? = null
        /**
         * The status of the recipe.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.RecipeSummary) : this() {
            this.creationDateTime = x.creationDateTime
            this.domain = x.domain
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.recipeArn = x.recipeArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.RecipeSummary = RecipeSummary(this)
    }
}
