// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about a recipe. Each recipe provides an algorithm that Amazon Personalize uses in model training when you use the [CreateSolution](https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html) operation.
 */
public class Recipe private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the algorithm that Amazon Personalize uses to train the model.
     */
    public val algorithmArn: kotlin.String? = builder.algorithmArn
    /**
     * The date and time (in Unix format) that the recipe was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The description of the recipe.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ARN of the FeatureTransformation object.
     */
    public val featureTransformationArn: kotlin.String? = builder.featureTransformationArn
    /**
     * The date and time (in Unix format) that the recipe was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the recipe.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the recipe.
     */
    public val recipeArn: kotlin.String? = builder.recipeArn
    /**
     * One of the following values:
     * + PERSONALIZED_RANKING
     * + RELATED_ITEMS
     * + USER_PERSONALIZATION
     */
    public val recipeType: kotlin.String? = builder.recipeType
    /**
     * The status of the recipe.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.Recipe = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Recipe(")
        append("algorithmArn=$algorithmArn,")
        append("creationDateTime=$creationDateTime,")
        append("description=$description,")
        append("featureTransformationArn=$featureTransformationArn,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("recipeArn=$recipeArn,")
        append("recipeType=$recipeType,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmArn?.hashCode() ?: 0
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (featureTransformationArn?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (recipeArn?.hashCode() ?: 0)
        result = 31 * result + (recipeType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Recipe

        if (algorithmArn != other.algorithmArn) return false
        if (creationDateTime != other.creationDateTime) return false
        if (description != other.description) return false
        if (featureTransformationArn != other.featureTransformationArn) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (recipeArn != other.recipeArn) return false
        if (recipeType != other.recipeType) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.Recipe = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the algorithm that Amazon Personalize uses to train the model.
         */
        public var algorithmArn: kotlin.String? = null
        /**
         * The date and time (in Unix format) that the recipe was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the recipe.
         */
        public var description: kotlin.String? = null
        /**
         * The ARN of the FeatureTransformation object.
         */
        public var featureTransformationArn: kotlin.String? = null
        /**
         * The date and time (in Unix format) that the recipe was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the recipe.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the recipe.
         */
        public var recipeArn: kotlin.String? = null
        /**
         * One of the following values:
         * + PERSONALIZED_RANKING
         * + RELATED_ITEMS
         * + USER_PERSONALIZATION
         */
        public var recipeType: kotlin.String? = null
        /**
         * The status of the recipe.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.Recipe) : this() {
            this.algorithmArn = x.algorithmArn
            this.creationDateTime = x.creationDateTime
            this.description = x.description
            this.featureTransformationArn = x.featureTransformationArn
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.recipeArn = x.recipeArn
            this.recipeType = x.recipeType
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.Recipe = Recipe(this)
    }
}
