// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information on a metric attribution. A metric attribution creates reports on the data that you import into Amazon Personalize. Depending on how you import the data, you can view reports in Amazon CloudWatch or Amazon S3. For more information, see [Measuring impact of recommendations](https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html).
 */
public class MetricAttribution private constructor(builder: Builder) {
    /**
     * The metric attribution's creation date time.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The metric attribution's dataset group Amazon Resource Name (ARN).
     */
    public val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * The metric attribution's failure reason.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The metric attribution's last updated date time.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The metric attribution's Amazon Resource Name (ARN).
     */
    public val metricAttributionArn: kotlin.String? = builder.metricAttributionArn
    /**
     * The metric attribution's output configuration.
     */
    public val metricsOutputConfig: aws.sdk.kotlin.services.personalize.model.MetricAttributionOutput? = builder.metricsOutputConfig
    /**
     * The metric attribution's name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The metric attribution's status.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.MetricAttribution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricAttribution(")
        append("creationDateTime=$creationDateTime,")
        append("datasetGroupArn=$datasetGroupArn,")
        append("failureReason=$failureReason,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("metricAttributionArn=$metricAttributionArn,")
        append("metricsOutputConfig=$metricsOutputConfig,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (datasetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (metricAttributionArn?.hashCode() ?: 0)
        result = 31 * result + (metricsOutputConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricAttribution

        if (creationDateTime != other.creationDateTime) return false
        if (datasetGroupArn != other.datasetGroupArn) return false
        if (failureReason != other.failureReason) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (metricAttributionArn != other.metricAttributionArn) return false
        if (metricsOutputConfig != other.metricsOutputConfig) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.MetricAttribution = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The metric attribution's creation date time.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The metric attribution's dataset group Amazon Resource Name (ARN).
         */
        public var datasetGroupArn: kotlin.String? = null
        /**
         * The metric attribution's failure reason.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The metric attribution's last updated date time.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The metric attribution's Amazon Resource Name (ARN).
         */
        public var metricAttributionArn: kotlin.String? = null
        /**
         * The metric attribution's output configuration.
         */
        public var metricsOutputConfig: aws.sdk.kotlin.services.personalize.model.MetricAttributionOutput? = null
        /**
         * The metric attribution's name.
         */
        public var name: kotlin.String? = null
        /**
         * The metric attribution's status.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.MetricAttribution) : this() {
            this.creationDateTime = x.creationDateTime
            this.datasetGroupArn = x.datasetGroupArn
            this.failureReason = x.failureReason
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.metricAttributionArn = x.metricAttributionArn
            this.metricsOutputConfig = x.metricsOutputConfig
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.MetricAttribution = MetricAttribution(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.MetricAttributionOutput] inside the given [block]
         */
        public fun metricsOutputConfig(block: aws.sdk.kotlin.services.personalize.model.MetricAttributionOutput.Builder.() -> kotlin.Unit) {
            this.metricsOutputConfig = aws.sdk.kotlin.services.personalize.model.MetricAttributionOutput.invoke(block)
        }
    }
}
