// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides feature transformation information. Feature transformation is the process of modifying raw input data into a form more suitable for model training.
 */
public class FeatureTransformation private constructor(builder: Builder) {
    /**
     * The creation date and time (in Unix time) of the feature transformation.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * Provides the default parameters for feature transformation.
     */
    public val defaultParameters: Map<String, String>? = builder.defaultParameters
    /**
     * The Amazon Resource Name (ARN) of the FeatureTransformation object.
     */
    public val featureTransformationArn: kotlin.String? = builder.featureTransformationArn
    /**
     * The last update date and time (in Unix time) of the feature transformation.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the feature transformation.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of the feature transformation.
     *
     * A feature transformation can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.FeatureTransformation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FeatureTransformation(")
        append("creationDateTime=$creationDateTime,")
        append("defaultParameters=$defaultParameters,")
        append("featureTransformationArn=$featureTransformationArn,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (defaultParameters?.hashCode() ?: 0)
        result = 31 * result + (featureTransformationArn?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FeatureTransformation

        if (creationDateTime != other.creationDateTime) return false
        if (defaultParameters != other.defaultParameters) return false
        if (featureTransformationArn != other.featureTransformationArn) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.FeatureTransformation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The creation date and time (in Unix time) of the feature transformation.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Provides the default parameters for feature transformation.
         */
        public var defaultParameters: Map<String, String>? = null
        /**
         * The Amazon Resource Name (ARN) of the FeatureTransformation object.
         */
        public var featureTransformationArn: kotlin.String? = null
        /**
         * The last update date and time (in Unix time) of the feature transformation.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the feature transformation.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the feature transformation.
         *
         * A feature transformation can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.FeatureTransformation) : this() {
            this.creationDateTime = x.creationDateTime
            this.defaultParameters = x.defaultParameters
            this.featureTransformationArn = x.featureTransformationArn
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.FeatureTransformation = FeatureTransformation(this)
    }
}
