// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model



/**
 * Provides the name and default range of a integer-valued hyperparameter and whether the hyperparameter is tunable. A tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).
 */
public class DefaultIntegerHyperParameterRange private constructor(builder: Builder) {
    /**
     * Indicates whether the hyperparameter is tunable.
     */
    public val isTunable: kotlin.Boolean = builder.isTunable
    /**
     * The maximum allowable value for the hyperparameter.
     */
    public val maxValue: kotlin.Int = builder.maxValue
    /**
     * The minimum allowable value for the hyperparameter.
     */
    public val minValue: kotlin.Int = builder.minValue
    /**
     * The name of the hyperparameter.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.DefaultIntegerHyperParameterRange = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DefaultIntegerHyperParameterRange(")
        append("isTunable=$isTunable,")
        append("maxValue=$maxValue,")
        append("minValue=$minValue,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTunable.hashCode()
        result = 31 * result + (maxValue)
        result = 31 * result + (minValue)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DefaultIntegerHyperParameterRange

        if (isTunable != other.isTunable) return false
        if (maxValue != other.maxValue) return false
        if (minValue != other.minValue) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.DefaultIntegerHyperParameterRange = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the hyperparameter is tunable.
         */
        public var isTunable: kotlin.Boolean = false
        /**
         * The maximum allowable value for the hyperparameter.
         */
        public var maxValue: kotlin.Int = 0
        /**
         * The minimum allowable value for the hyperparameter.
         */
        public var minValue: kotlin.Int = 0
        /**
         * The name of the hyperparameter.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.DefaultIntegerHyperParameterRange) : this() {
            this.isTunable = x.isTunable
            this.maxValue = x.maxValue
            this.minValue = x.minValue
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.DefaultIntegerHyperParameterRange = DefaultIntegerHyperParameterRange(this)
    }
}
