// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the properties of a dataset schema. For a complete listing, call the [DescribeSchema](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSchema.html) API.
 */
public class DatasetSchemaSummary private constructor(builder: Builder) {
    /**
     * The date and time (in Unix time) that the schema was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The domain of a schema that you created for a dataset in a Domain dataset group.
     */
    public val domain: aws.sdk.kotlin.services.personalize.model.Domain? = builder.domain
    /**
     * The date and time (in Unix time) that the schema was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the schema.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the schema.
     */
    public val schemaArn: kotlin.String? = builder.schemaArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.DatasetSchemaSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetSchemaSummary(")
        append("creationDateTime=$creationDateTime,")
        append("domain=$domain,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("schemaArn=$schemaArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (schemaArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetSchemaSummary

        if (creationDateTime != other.creationDateTime) return false
        if (domain != other.domain) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (schemaArn != other.schemaArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.DatasetSchemaSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time (in Unix time) that the schema was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The domain of a schema that you created for a dataset in a Domain dataset group.
         */
        public var domain: aws.sdk.kotlin.services.personalize.model.Domain? = null
        /**
         * The date and time (in Unix time) that the schema was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the schema.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the schema.
         */
        public var schemaArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.DatasetSchemaSummary) : this() {
            this.creationDateTime = x.creationDateTime
            this.domain = x.domain
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.schemaArn = x.schemaArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.DatasetSchemaSummary = DatasetSchemaSummary(this)
    }
}
