// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A truncated version of the [BatchSegmentJob](https://docs.aws.amazon.com/personalize/latest/dg/API_BatchSegmentJob.html) datatype. [ListBatchSegmentJobs](https://docs.aws.amazon.com/personalize/latest/dg/API_ListBatchSegmentJobs.html) operation returns a list of batch segment job summaries.
 */
public class BatchSegmentJobSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the batch segment job.
     */
    public val batchSegmentJobArn: kotlin.String? = builder.batchSegmentJobArn
    /**
     * The time at which the batch segment job was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * If the batch segment job failed, the reason for the failure.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The name of the batch segment job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The time at which the batch segment job was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.
     */
    public val solutionVersionArn: kotlin.String? = builder.solutionVersionArn
    /**
     * The status of the batch segment job. The status is one of the following values:
     * + PENDING
     * + IN PROGRESS
     * + ACTIVE
     * + CREATE FAILED
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.BatchSegmentJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchSegmentJobSummary(")
        append("batchSegmentJobArn=$batchSegmentJobArn,")
        append("creationDateTime=$creationDateTime,")
        append("failureReason=$failureReason,")
        append("jobName=$jobName,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("solutionVersionArn=$solutionVersionArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchSegmentJobArn?.hashCode() ?: 0
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (solutionVersionArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchSegmentJobSummary

        if (batchSegmentJobArn != other.batchSegmentJobArn) return false
        if (creationDateTime != other.creationDateTime) return false
        if (failureReason != other.failureReason) return false
        if (jobName != other.jobName) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (solutionVersionArn != other.solutionVersionArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.BatchSegmentJobSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the batch segment job.
         */
        public var batchSegmentJobArn: kotlin.String? = null
        /**
         * The time at which the batch segment job was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the batch segment job failed, the reason for the failure.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The name of the batch segment job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The time at which the batch segment job was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.
         */
        public var solutionVersionArn: kotlin.String? = null
        /**
         * The status of the batch segment job. The status is one of the following values:
         * + PENDING
         * + IN PROGRESS
         * + ACTIVE
         * + CREATE FAILED
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.BatchSegmentJobSummary) : this() {
            this.batchSegmentJobArn = x.batchSegmentJobArn
            this.creationDateTime = x.creationDateTime
            this.failureReason = x.failureReason
            this.jobName = x.jobName
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.solutionVersionArn = x.solutionVersionArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.BatchSegmentJobSummary = BatchSegmentJobSummary(this)
    }
}
