// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a custom algorithm.
 */
public class Algorithm private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the algorithm.
     */
    public val algorithmArn: kotlin.String? = builder.algorithmArn
    /**
     * The URI of the Docker container for the algorithm image.
     */
    public val algorithmImage: aws.sdk.kotlin.services.personalize.model.AlgorithmImage? = builder.algorithmImage
    /**
     * The date and time (in Unix time) that the algorithm was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * Specifies the default hyperparameters, their ranges, and whether they are tunable. A tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).
     */
    public val defaultHyperParameterRanges: aws.sdk.kotlin.services.personalize.model.DefaultHyperParameterRanges? = builder.defaultHyperParameterRanges
    /**
     * Specifies the default hyperparameters.
     */
    public val defaultHyperParameters: Map<String, String>? = builder.defaultHyperParameters
    /**
     * Specifies the default maximum number of training jobs and parallel training jobs.
     */
    public val defaultResourceConfig: Map<String, String>? = builder.defaultResourceConfig
    /**
     * The date and time (in Unix time) that the algorithm was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the algorithm.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the role.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The training input mode.
     */
    public val trainingInputMode: kotlin.String? = builder.trainingInputMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.Algorithm = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Algorithm(")
        append("algorithmArn=$algorithmArn,")
        append("algorithmImage=$algorithmImage,")
        append("creationDateTime=$creationDateTime,")
        append("defaultHyperParameterRanges=$defaultHyperParameterRanges,")
        append("defaultHyperParameters=$defaultHyperParameters,")
        append("defaultResourceConfig=$defaultResourceConfig,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("trainingInputMode=$trainingInputMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmArn?.hashCode() ?: 0
        result = 31 * result + (algorithmImage?.hashCode() ?: 0)
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (defaultHyperParameterRanges?.hashCode() ?: 0)
        result = 31 * result + (defaultHyperParameters?.hashCode() ?: 0)
        result = 31 * result + (defaultResourceConfig?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (trainingInputMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Algorithm

        if (algorithmArn != other.algorithmArn) return false
        if (algorithmImage != other.algorithmImage) return false
        if (creationDateTime != other.creationDateTime) return false
        if (defaultHyperParameterRanges != other.defaultHyperParameterRanges) return false
        if (defaultHyperParameters != other.defaultHyperParameters) return false
        if (defaultResourceConfig != other.defaultResourceConfig) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (trainingInputMode != other.trainingInputMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.Algorithm = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the algorithm.
         */
        public var algorithmArn: kotlin.String? = null
        /**
         * The URI of the Docker container for the algorithm image.
         */
        public var algorithmImage: aws.sdk.kotlin.services.personalize.model.AlgorithmImage? = null
        /**
         * The date and time (in Unix time) that the algorithm was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the default hyperparameters, their ranges, and whether they are tunable. A tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).
         */
        public var defaultHyperParameterRanges: aws.sdk.kotlin.services.personalize.model.DefaultHyperParameterRanges? = null
        /**
         * Specifies the default hyperparameters.
         */
        public var defaultHyperParameters: Map<String, String>? = null
        /**
         * Specifies the default maximum number of training jobs and parallel training jobs.
         */
        public var defaultResourceConfig: Map<String, String>? = null
        /**
         * The date and time (in Unix time) that the algorithm was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the algorithm.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the role.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The training input mode.
         */
        public var trainingInputMode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.Algorithm) : this() {
            this.algorithmArn = x.algorithmArn
            this.algorithmImage = x.algorithmImage
            this.creationDateTime = x.creationDateTime
            this.defaultHyperParameterRanges = x.defaultHyperParameterRanges
            this.defaultHyperParameters = x.defaultHyperParameters
            this.defaultResourceConfig = x.defaultResourceConfig
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.roleArn = x.roleArn
            this.trainingInputMode = x.trainingInputMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.Algorithm = Algorithm(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.AlgorithmImage] inside the given [block]
         */
        public fun algorithmImage(block: aws.sdk.kotlin.services.personalize.model.AlgorithmImage.Builder.() -> kotlin.Unit) {
            this.algorithmImage = aws.sdk.kotlin.services.personalize.model.AlgorithmImage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.DefaultHyperParameterRanges] inside the given [block]
         */
        public fun defaultHyperParameterRanges(block: aws.sdk.kotlin.services.personalize.model.DefaultHyperParameterRanges.Builder.() -> kotlin.Unit) {
            this.defaultHyperParameterRanges = aws.sdk.kotlin.services.personalize.model.DefaultHyperParameterRanges.invoke(block)
        }
    }
}
