// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model



/**
 * Provides the name and default range of a continuous hyperparameter and whether the hyperparameter is tunable. A tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).
 */
public class DefaultContinuousHyperParameterRange private constructor(builder: Builder) {
    /**
     * Whether the hyperparameter is tunable.
     */
    public val isTunable: kotlin.Boolean = builder.isTunable
    /**
     * The maximum allowable value for the hyperparameter.
     */
    public val maxValue: kotlin.Double = builder.maxValue
    /**
     * The minimum allowable value for the hyperparameter.
     */
    public val minValue: kotlin.Double = builder.minValue
    /**
     * The name of the hyperparameter.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.DefaultContinuousHyperParameterRange = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DefaultContinuousHyperParameterRange(")
        append("isTunable=$isTunable,")
        append("maxValue=$maxValue,")
        append("minValue=$minValue,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTunable.hashCode()
        result = 31 * result + (maxValue.hashCode())
        result = 31 * result + (minValue.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DefaultContinuousHyperParameterRange

        if (isTunable != other.isTunable) return false
        if (maxValue != other.maxValue) return false
        if (minValue != other.minValue) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.DefaultContinuousHyperParameterRange = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Whether the hyperparameter is tunable.
         */
        public var isTunable: kotlin.Boolean = false
        /**
         * The maximum allowable value for the hyperparameter.
         */
        public var maxValue: kotlin.Double = 0.0
        /**
         * The minimum allowable value for the hyperparameter.
         */
        public var minValue: kotlin.Double = 0.0
        /**
         * The name of the hyperparameter.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.DefaultContinuousHyperParameterRange) : this() {
            this.isTunable = x.isTunable
            this.maxValue = x.maxValue
            this.minValue = x.minValue
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.DefaultContinuousHyperParameterRange = DefaultContinuousHyperParameterRange(this)
    }
}
