// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the properties of a dataset export job. For a complete listing, call the [DescribeDatasetExportJob](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetExportJob.html) API.
 */
public class DatasetExportJobSummary private constructor(builder: Builder) {
    /**
     * The date and time (in Unix time) that the dataset export job was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The Amazon Resource Name (ARN) of the dataset export job.
     */
    public val datasetExportJobArn: kotlin.String? = builder.datasetExportJobArn
    /**
     * If a dataset export job fails, the reason behind the failure.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The name of the dataset export job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The date and time (in Unix time) that the dataset export job status was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The status of the dataset export job.
     *
     * A dataset export job can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.DatasetExportJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetExportJobSummary(")
        append("creationDateTime=$creationDateTime,")
        append("datasetExportJobArn=$datasetExportJobArn,")
        append("failureReason=$failureReason,")
        append("jobName=$jobName,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (datasetExportJobArn?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetExportJobSummary

        if (creationDateTime != other.creationDateTime) return false
        if (datasetExportJobArn != other.datasetExportJobArn) return false
        if (failureReason != other.failureReason) return false
        if (jobName != other.jobName) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.DatasetExportJobSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time (in Unix time) that the dataset export job was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the dataset export job.
         */
        public var datasetExportJobArn: kotlin.String? = null
        /**
         * If a dataset export job fails, the reason behind the failure.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The name of the dataset export job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The date and time (in Unix time) that the dataset export job status was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the dataset export job.
         *
         * A dataset export job can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.DatasetExportJobSummary) : this() {
            this.creationDateTime = x.creationDateTime
            this.datasetExportJobArn = x.datasetExportJobArn
            this.failureReason = x.failureReason
            this.jobName = x.jobName
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.DatasetExportJobSummary = DatasetExportJobSummary(this)
    }
}
