// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model



public class CreateSolutionRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
     */
    public val datasetGroupArn: kotlin.String? = builder.datasetGroupArn
    /**
     * When your have multiple event types (using an `EVENT_TYPE` schema field), this parameter specifies which event type (for example, 'click' or 'like') is used for training the model.
     *
     * If you do not provide an `eventType`, Amazon Personalize will use all interactions for training with equal weight regardless of type.
     */
    public val eventType: kotlin.String? = builder.eventType
    /**
     * The name for the solution.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Whether to perform automated machine learning (AutoML). The default is `false`. For this case, you must specify `recipeArn`.
     *
     * When set to `true`, Amazon Personalize analyzes your training data and selects the optimal USER_PERSONALIZATION recipe and hyperparameters. In this case, you must omit `recipeArn`. Amazon Personalize determines the optimal recipe by running tests with different values for the hyperparameters. AutoML lengthens the training process as compared to selecting a specific recipe.
     */
    public val performAutoMl: kotlin.Boolean = builder.performAutoMl
    /**
     * Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe. The default is `false`.
     *
     * When performing AutoML, this parameter is always `true` and you should not set it to `false`.
     */
    public val performHpo: kotlin.Boolean? = builder.performHpo
    /**
     * The ARN of the recipe to use for model training. Only specified when `performAutoML` is false.
     */
    public val recipeArn: kotlin.String? = builder.recipeArn
    /**
     * The configuration to use with the solution. When `performAutoML` is set to true, Amazon Personalize only evaluates the `autoMLConfig` section of the solution configuration.
     *
     * Amazon Personalize doesn't support configuring the `hpoObjective` at this time.
     */
    public val solutionConfig: aws.sdk.kotlin.services.personalize.model.SolutionConfig? = builder.solutionConfig
    /**
     * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html) to apply to the solution.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.CreateSolutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSolutionRequest(")
        append("datasetGroupArn=$datasetGroupArn,")
        append("eventType=$eventType,")
        append("name=$name,")
        append("performAutoMl=$performAutoMl,")
        append("performHpo=$performHpo,")
        append("recipeArn=$recipeArn,")
        append("solutionConfig=$solutionConfig,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = datasetGroupArn?.hashCode() ?: 0
        result = 31 * result + (eventType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (performAutoMl.hashCode())
        result = 31 * result + (performHpo?.hashCode() ?: 0)
        result = 31 * result + (recipeArn?.hashCode() ?: 0)
        result = 31 * result + (solutionConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSolutionRequest

        if (datasetGroupArn != other.datasetGroupArn) return false
        if (eventType != other.eventType) return false
        if (name != other.name) return false
        if (performAutoMl != other.performAutoMl) return false
        if (performHpo != other.performHpo) return false
        if (recipeArn != other.recipeArn) return false
        if (solutionConfig != other.solutionConfig) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.CreateSolutionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
         */
        public var datasetGroupArn: kotlin.String? = null
        /**
         * When your have multiple event types (using an `EVENT_TYPE` schema field), this parameter specifies which event type (for example, 'click' or 'like') is used for training the model.
         *
         * If you do not provide an `eventType`, Amazon Personalize will use all interactions for training with equal weight regardless of type.
         */
        public var eventType: kotlin.String? = null
        /**
         * The name for the solution.
         */
        public var name: kotlin.String? = null
        /**
         * Whether to perform automated machine learning (AutoML). The default is `false`. For this case, you must specify `recipeArn`.
         *
         * When set to `true`, Amazon Personalize analyzes your training data and selects the optimal USER_PERSONALIZATION recipe and hyperparameters. In this case, you must omit `recipeArn`. Amazon Personalize determines the optimal recipe by running tests with different values for the hyperparameters. AutoML lengthens the training process as compared to selecting a specific recipe.
         */
        public var performAutoMl: kotlin.Boolean = false
        /**
         * Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe. The default is `false`.
         *
         * When performing AutoML, this parameter is always `true` and you should not set it to `false`.
         */
        public var performHpo: kotlin.Boolean? = null
        /**
         * The ARN of the recipe to use for model training. Only specified when `performAutoML` is false.
         */
        public var recipeArn: kotlin.String? = null
        /**
         * The configuration to use with the solution. When `performAutoML` is set to true, Amazon Personalize only evaluates the `autoMLConfig` section of the solution configuration.
         *
         * Amazon Personalize doesn't support configuring the `hpoObjective` at this time.
         */
        public var solutionConfig: aws.sdk.kotlin.services.personalize.model.SolutionConfig? = null
        /**
         * A list of [tags](https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html) to apply to the solution.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.CreateSolutionRequest) : this() {
            this.datasetGroupArn = x.datasetGroupArn
            this.eventType = x.eventType
            this.name = x.name
            this.performAutoMl = x.performAutoMl
            this.performHpo = x.performHpo
            this.recipeArn = x.recipeArn
            this.solutionConfig = x.solutionConfig
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.CreateSolutionRequest = CreateSolutionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.personalize.model.SolutionConfig] inside the given [block]
         */
        public fun solutionConfig(block: aws.sdk.kotlin.services.personalize.model.SolutionConfig.Builder.() -> kotlin.Unit) {
            this.solutionConfig = aws.sdk.kotlin.services.personalize.model.SolutionConfig.invoke(block)
        }
    }
}
