// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.personalize.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of the properties of a campaign. For a complete listing, call the [DescribeCampaign](https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html) API.
 */
public class CampaignSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the campaign.
     */
    public val campaignArn: kotlin.String? = builder.campaignArn
    /**
     * The date and time (in Unix time) that the campaign was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * If a campaign fails, the reason behind the failure.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The date and time (in Unix time) that the campaign was last updated.
     */
    public val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The name of the campaign.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of the campaign.
     *
     * A campaign can be in one of the following states:
     * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
     * + DELETE PENDING > DELETE IN_PROGRESS
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.personalize.model.CampaignSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CampaignSummary(")
        append("campaignArn=$campaignArn,")
        append("creationDateTime=$creationDateTime,")
        append("failureReason=$failureReason,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = campaignArn?.hashCode() ?: 0
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CampaignSummary

        if (campaignArn != other.campaignArn) return false
        if (creationDateTime != other.creationDateTime) return false
        if (failureReason != other.failureReason) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.personalize.model.CampaignSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the campaign.
         */
        public var campaignArn: kotlin.String? = null
        /**
         * The date and time (in Unix time) that the campaign was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If a campaign fails, the reason behind the failure.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The date and time (in Unix time) that the campaign was last updated.
         */
        public var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the campaign.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the campaign.
         *
         * A campaign can be in one of the following states:
         * + CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
         * + DELETE PENDING > DELETE IN_PROGRESS
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.personalize.model.CampaignSummary) : this() {
            this.campaignArn = x.campaignArn
            this.creationDateTime = x.creationDateTime
            this.failureReason = x.failureReason
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.personalize.model.CampaignSummary = CampaignSummary(this)
    }
}
