// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pcaconnectorscep.paginators

import aws.sdk.kotlin.services.pcaconnectorscep.PcaConnectorScepClient
import aws.sdk.kotlin.services.pcaconnectorscep.model.ChallengeMetadataSummary
import aws.sdk.kotlin.services.pcaconnectorscep.model.ConnectorSummary
import aws.sdk.kotlin.services.pcaconnectorscep.model.ListChallengeMetadataRequest
import aws.sdk.kotlin.services.pcaconnectorscep.model.ListChallengeMetadataResponse
import aws.sdk.kotlin.services.pcaconnectorscep.model.ListConnectorsRequest
import aws.sdk.kotlin.services.pcaconnectorscep.model.ListConnectorsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListChallengeMetadataResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChallengeMetadataRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChallengeMetadataResponse]
 */
public fun PcaConnectorScepClient.listChallengeMetadataPaginated(initialRequest: ListChallengeMetadataRequest): Flow<ListChallengeMetadataResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChallengeMetadataPaginated.listChallengeMetadata(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChallengeMetadataResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChallengeMetadataResponse]
 */
public fun PcaConnectorScepClient.listChallengeMetadataPaginated(block: ListChallengeMetadataRequest.Builder.() -> Unit): Flow<ListChallengeMetadataResponse> =
    listChallengeMetadataPaginated(ListChallengeMetadataRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listChallengeMetadataPaginated]
 * to access the nested member [ChallengeMetadataSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ChallengeMetadataSummary]
 */
@JvmName("listChallengeMetadataResponseChallengeMetadataSummary")
public fun Flow<ListChallengeMetadataResponse>.challenges(): Flow<ChallengeMetadataSummary> =
    transform() { response ->
        response.challenges?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListConnectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConnectorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConnectorsResponse]
 */
public fun PcaConnectorScepClient.listConnectorsPaginated(initialRequest: ListConnectorsRequest = ListConnectorsRequest { }): Flow<ListConnectorsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConnectorsPaginated.listConnectors(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListConnectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConnectorsResponse]
 */
public fun PcaConnectorScepClient.listConnectorsPaginated(block: ListConnectorsRequest.Builder.() -> Unit): Flow<ListConnectorsResponse> =
    listConnectorsPaginated(ListConnectorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listConnectorsPaginated]
 * to access the nested member [ConnectorSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ConnectorSummary]
 */
@JvmName("listConnectorsResponseConnectorSummary")
public fun Flow<ListConnectorsResponse>.connectors(): Flow<ConnectorSummary> =
    transform() { response ->
        response.connectors?.forEach {
            emit(it)
        }
    }
