// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pcaconnectorscep.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains configuration details for use with Microsoft Intune. For information about using Connector for SCEP for Microsoft Intune, see [Using Connector for SCEP for Microsoft Intune](https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html).
 *
 * When you use Connector for SCEP for Microsoft Intune, certain functionalities are enabled by accessing Microsoft Intune through the Microsoft API. Your use of the Connector for SCEP and accompanying Amazon Web Services services doesn't remove your need to have a valid license for your use of the Microsoft Intune service. You should also review the [Microsoft Intune® App Protection Policies](https://learn.microsoft.com/en-us/mem/intune/apps/app-protection-policy).
 */
public class IntuneConfiguration private constructor(builder: Builder) {
    /**
     * The directory (tenant) ID from your Microsoft Entra ID app registration.
     */
    public val azureApplicationId: kotlin.String = requireNotNull(builder.azureApplicationId) { "A non-null value must be provided for azureApplicationId" }
    /**
     * The primary domain from your Microsoft Entra ID app registration.
     */
    public val domain: kotlin.String = requireNotNull(builder.domain) { "A non-null value must be provided for domain" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pcaconnectorscep.model.IntuneConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IntuneConfiguration(")
        append("azureApplicationId=$azureApplicationId,")
        append("domain=$domain")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = azureApplicationId.hashCode()
        result = 31 * result + (domain.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IntuneConfiguration

        if (azureApplicationId != other.azureApplicationId) return false
        if (domain != other.domain) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pcaconnectorscep.model.IntuneConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The directory (tenant) ID from your Microsoft Entra ID app registration.
         */
        public var azureApplicationId: kotlin.String? = null
        /**
         * The primary domain from your Microsoft Entra ID app registration.
         */
        public var domain: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pcaconnectorscep.model.IntuneConfiguration) : this() {
            this.azureApplicationId = x.azureApplicationId
            this.domain = x.domain
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pcaconnectorscep.model.IntuneConfiguration = IntuneConfiguration(this)

        internal fun correctErrors(): Builder {
            if (azureApplicationId == null) azureApplicationId = ""
            if (domain == null) domain = ""
            return this
        }
    }
}
