// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pcaconnectorscep.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateChallengeRequest private constructor(builder: Builder) {
    /**
     * Custom string that can be used to distinguish between calls to the [CreateChallenge](https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_CreateChallenge.html) action. Client tokens for `CreateChallenge` time out after five minutes. Therefore, if you call `CreateChallenge` multiple times with the same client token within five minutes, Connector for SCEP recognizes that you are requesting only one challenge and will only respond with one. If you change the client token for each call, Connector for SCEP recognizes that you are requesting multiple challenge passwords.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The Amazon Resource Name (ARN) of the connector that you want to create a challenge for.
     */
    public val connectorArn: kotlin.String? = builder.connectorArn
    /**
     * The key-value pairs to associate with the resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pcaconnectorscep.model.CreateChallengeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateChallengeRequest(")
        append("clientToken=$clientToken,")
        append("connectorArn=$connectorArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (connectorArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateChallengeRequest

        if (clientToken != other.clientToken) return false
        if (connectorArn != other.connectorArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pcaconnectorscep.model.CreateChallengeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Custom string that can be used to distinguish between calls to the [CreateChallenge](https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_CreateChallenge.html) action. Client tokens for `CreateChallenge` time out after five minutes. Therefore, if you call `CreateChallenge` multiple times with the same client token within five minutes, Connector for SCEP recognizes that you are requesting only one challenge and will only respond with one. If you change the client token for each call, Connector for SCEP recognizes that you are requesting multiple challenge passwords.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the connector that you want to create a challenge for.
         */
        public var connectorArn: kotlin.String? = null
        /**
         * The key-value pairs to associate with the resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pcaconnectorscep.model.CreateChallengeRequest) : this() {
            this.clientToken = x.clientToken
            this.connectorArn = x.connectorArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pcaconnectorscep.model.CreateChallengeRequest = CreateChallengeRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
