// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pcaconnectorscep.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Lists the Amazon Web Services Private CA SCEP connectors belonging to your Amazon Web Services account.
 */
public class ConnectorSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the connector.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The Amazon Resource Name (ARN) of the connector's associated certificate authority.
     */
    public val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * The date and time that the challenge was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The connector's HTTPS public SCEP URL.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * Contains settings relevant to the mobile device management system that you chose for the connector. If you didn't configure `MobileDeviceManagement`, then the connector is for general-purpose use and this object is empty.
     */
    public val mobileDeviceManagement: aws.sdk.kotlin.services.pcaconnectorscep.model.MobileDeviceManagement? = builder.mobileDeviceManagement
    /**
     * Contains OpenID Connect (OIDC) parameters for use with Microsoft Intune.
     */
    public val openIdConfiguration: aws.sdk.kotlin.services.pcaconnectorscep.model.OpenIdConfiguration? = builder.openIdConfiguration
    /**
     * The connector's status. Status can be creating, active, deleting, or failed.
     */
    public val status: aws.sdk.kotlin.services.pcaconnectorscep.model.ConnectorStatus? = builder.status
    /**
     * Information about why connector creation failed, if status is `FAILED`.
     */
    public val statusReason: aws.sdk.kotlin.services.pcaconnectorscep.model.ConnectorStatusReason? = builder.statusReason
    /**
     * The connector type.
     */
    public val type: aws.sdk.kotlin.services.pcaconnectorscep.model.ConnectorType? = builder.type
    /**
     * The date and time that the challenge was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pcaconnectorscep.model.ConnectorSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectorSummary(")
        append("arn=$arn,")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("createdAt=$createdAt,")
        append("endpoint=$endpoint,")
        append("mobileDeviceManagement=$mobileDeviceManagement,")
        append("openIdConfiguration=$openIdConfiguration,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("type=$type,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (certificateAuthorityArn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (mobileDeviceManagement?.hashCode() ?: 0)
        result = 31 * result + (openIdConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConnectorSummary

        if (arn != other.arn) return false
        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (createdAt != other.createdAt) return false
        if (endpoint != other.endpoint) return false
        if (mobileDeviceManagement != other.mobileDeviceManagement) return false
        if (openIdConfiguration != other.openIdConfiguration) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pcaconnectorscep.model.ConnectorSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the connector.
         */
        public var arn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the connector's associated certificate authority.
         */
        public var certificateAuthorityArn: kotlin.String? = null
        /**
         * The date and time that the challenge was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The connector's HTTPS public SCEP URL.
         */
        public var endpoint: kotlin.String? = null
        /**
         * Contains settings relevant to the mobile device management system that you chose for the connector. If you didn't configure `MobileDeviceManagement`, then the connector is for general-purpose use and this object is empty.
         */
        public var mobileDeviceManagement: aws.sdk.kotlin.services.pcaconnectorscep.model.MobileDeviceManagement? = null
        /**
         * Contains OpenID Connect (OIDC) parameters for use with Microsoft Intune.
         */
        public var openIdConfiguration: aws.sdk.kotlin.services.pcaconnectorscep.model.OpenIdConfiguration? = null
        /**
         * The connector's status. Status can be creating, active, deleting, or failed.
         */
        public var status: aws.sdk.kotlin.services.pcaconnectorscep.model.ConnectorStatus? = null
        /**
         * Information about why connector creation failed, if status is `FAILED`.
         */
        public var statusReason: aws.sdk.kotlin.services.pcaconnectorscep.model.ConnectorStatusReason? = null
        /**
         * The connector type.
         */
        public var type: aws.sdk.kotlin.services.pcaconnectorscep.model.ConnectorType? = null
        /**
         * The date and time that the challenge was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pcaconnectorscep.model.ConnectorSummary) : this() {
            this.arn = x.arn
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.createdAt = x.createdAt
            this.endpoint = x.endpoint
            this.mobileDeviceManagement = x.mobileDeviceManagement
            this.openIdConfiguration = x.openIdConfiguration
            this.status = x.status
            this.statusReason = x.statusReason
            this.type = x.type
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pcaconnectorscep.model.ConnectorSummary = ConnectorSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.pcaconnectorscep.model.OpenIdConfiguration] inside the given [block]
         */
        public fun openIdConfiguration(block: aws.sdk.kotlin.services.pcaconnectorscep.model.OpenIdConfiguration.Builder.() -> kotlin.Unit) {
            this.openIdConfiguration = aws.sdk.kotlin.services.pcaconnectorscep.model.OpenIdConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
