// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pcaconnectorscep

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.pcaconnectorscep.auth.DefaultPcaConnectorScepAuthSchemeProvider
import aws.sdk.kotlin.services.pcaconnectorscep.auth.PcaConnectorScepAuthSchemeProvider
import aws.sdk.kotlin.services.pcaconnectorscep.endpoints.DefaultPcaConnectorScepEndpointProvider
import aws.sdk.kotlin.services.pcaconnectorscep.endpoints.PcaConnectorScepEndpointParameters
import aws.sdk.kotlin.services.pcaconnectorscep.endpoints.PcaConnectorScepEndpointProvider
import aws.sdk.kotlin.services.pcaconnectorscep.model.CreateChallengeRequest
import aws.sdk.kotlin.services.pcaconnectorscep.model.CreateChallengeResponse
import aws.sdk.kotlin.services.pcaconnectorscep.model.CreateConnectorRequest
import aws.sdk.kotlin.services.pcaconnectorscep.model.CreateConnectorResponse
import aws.sdk.kotlin.services.pcaconnectorscep.model.DeleteChallengeRequest
import aws.sdk.kotlin.services.pcaconnectorscep.model.DeleteChallengeResponse
import aws.sdk.kotlin.services.pcaconnectorscep.model.DeleteConnectorRequest
import aws.sdk.kotlin.services.pcaconnectorscep.model.DeleteConnectorResponse
import aws.sdk.kotlin.services.pcaconnectorscep.model.GetChallengeMetadataRequest
import aws.sdk.kotlin.services.pcaconnectorscep.model.GetChallengeMetadataResponse
import aws.sdk.kotlin.services.pcaconnectorscep.model.GetChallengePasswordRequest
import aws.sdk.kotlin.services.pcaconnectorscep.model.GetChallengePasswordResponse
import aws.sdk.kotlin.services.pcaconnectorscep.model.GetConnectorRequest
import aws.sdk.kotlin.services.pcaconnectorscep.model.GetConnectorResponse
import aws.sdk.kotlin.services.pcaconnectorscep.model.ListChallengeMetadataRequest
import aws.sdk.kotlin.services.pcaconnectorscep.model.ListChallengeMetadataResponse
import aws.sdk.kotlin.services.pcaconnectorscep.model.ListConnectorsRequest
import aws.sdk.kotlin.services.pcaconnectorscep.model.ListConnectorsResponse
import aws.sdk.kotlin.services.pcaconnectorscep.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.pcaconnectorscep.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.pcaconnectorscep.model.TagResourceRequest
import aws.sdk.kotlin.services.pcaconnectorscep.model.TagResourceResponse
import aws.sdk.kotlin.services.pcaconnectorscep.model.UntagResourceRequest
import aws.sdk.kotlin.services.pcaconnectorscep.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Pca Connector Scep"
public const val SdkVersion: String = "1.3.79"
public const val ServiceApiVersion: String = "2018-05-10"

/**
 * Connector for SCEP creates a connector between Amazon Web Services Private CA and your SCEP-enabled clients and devices. For more information, see [Connector for SCEP](https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep.html) in the *Amazon Web Services Private CA User Guide*.
 */
public interface PcaConnectorScepClient : SdkClient {
    /**
     * PcaConnectorScepClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, PcaConnectorScepClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "PcaConnectorScep",
                "PCA_CONNECTOR_SCEP",
                "pca_connector_scep",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, PcaConnectorScepClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): PcaConnectorScepClient = DefaultPcaConnectorScepClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: PcaConnectorScepEndpointProvider = builder.endpointProvider ?: DefaultPcaConnectorScepEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: PcaConnectorScepAuthSchemeProvider = builder.authSchemeProvider ?: DefaultPcaConnectorScepAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Pca Connector Scep"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: PcaConnectorScepEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: PcaConnectorScepAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * For general-purpose connectors. Creates a *challenge password* for the specified connector. The SCEP protocol uses a challenge password to authenticate a request before issuing a certificate from a certificate authority (CA). Your SCEP clients include the challenge password as part of their certificate request to Connector for SCEP. To retrieve the connector Amazon Resource Names (ARNs) for the connectors in your account, call [ListConnectors](https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_ListConnectors.html).
     *
     * To create additional challenge passwords for the connector, call `CreateChallenge` again. We recommend frequently rotating your challenge passwords.
     */
    public suspend fun createChallenge(input: CreateChallengeRequest): CreateChallengeResponse

    /**
     * Creates a SCEP connector. A SCEP connector links Amazon Web Services Private Certificate Authority to your SCEP-compatible devices and mobile device management (MDM) systems. Before you create a connector, you must complete a set of prerequisites, including creation of a private certificate authority (CA) to use with this connector. For more information, see [Connector for SCEP prerequisites](https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-prerequisites.html).
     */
    public suspend fun createConnector(input: CreateConnectorRequest): CreateConnectorResponse

    /**
     * Deletes the specified [Challenge](https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Challenge.html).
     */
    public suspend fun deleteChallenge(input: DeleteChallengeRequest): DeleteChallengeResponse

    /**
     * Deletes the specified [Connector](https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Connector.html). This operation also deletes any challenges associated with the connector.
     */
    public suspend fun deleteConnector(input: DeleteConnectorRequest): DeleteConnectorResponse

    /**
     * Retrieves the metadata for the specified [Challenge](https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Challenge.html).
     */
    public suspend fun getChallengeMetadata(input: GetChallengeMetadataRequest): GetChallengeMetadataResponse

    /**
     * Retrieves the challenge password for the specified [Challenge](https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Challenge.html).
     */
    public suspend fun getChallengePassword(input: GetChallengePasswordRequest): GetChallengePasswordResponse

    /**
     * Retrieves details about the specified [Connector](https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Connector.html). Calling this action returns important details about the connector, such as the public SCEP URL where your clients can request certificates.
     */
    public suspend fun getConnector(input: GetConnectorRequest): GetConnectorResponse

    /**
     * Retrieves the challenge metadata for the specified ARN.
     */
    public suspend fun listChallengeMetadata(input: ListChallengeMetadataRequest): ListChallengeMetadataResponse

    /**
     * Lists the connectors belonging to your Amazon Web Services account.
     */
    public suspend fun listConnectors(input: ListConnectorsRequest = ListConnectorsRequest { }): ListConnectorsResponse

    /**
     * Retrieves the tags associated with the specified resource. Tags are key-value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds one or more tags to your resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from your resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun PcaConnectorScepClient.withConfig(block: PcaConnectorScepClient.Config.Builder.() -> Unit): PcaConnectorScepClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultPcaConnectorScepClient(newConfig)
}

/**
 * For general-purpose connectors. Creates a *challenge password* for the specified connector. The SCEP protocol uses a challenge password to authenticate a request before issuing a certificate from a certificate authority (CA). Your SCEP clients include the challenge password as part of their certificate request to Connector for SCEP. To retrieve the connector Amazon Resource Names (ARNs) for the connectors in your account, call [ListConnectors](https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_ListConnectors.html).
 *
 * To create additional challenge passwords for the connector, call `CreateChallenge` again. We recommend frequently rotating your challenge passwords.
 */
public suspend inline fun PcaConnectorScepClient.createChallenge(crossinline block: CreateChallengeRequest.Builder.() -> Unit): CreateChallengeResponse = createChallenge(CreateChallengeRequest.Builder().apply(block).build())

/**
 * Creates a SCEP connector. A SCEP connector links Amazon Web Services Private Certificate Authority to your SCEP-compatible devices and mobile device management (MDM) systems. Before you create a connector, you must complete a set of prerequisites, including creation of a private certificate authority (CA) to use with this connector. For more information, see [Connector for SCEP prerequisites](https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-prerequisites.html).
 */
public suspend inline fun PcaConnectorScepClient.createConnector(crossinline block: CreateConnectorRequest.Builder.() -> Unit): CreateConnectorResponse = createConnector(CreateConnectorRequest.Builder().apply(block).build())

/**
 * Deletes the specified [Challenge](https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Challenge.html).
 */
public suspend inline fun PcaConnectorScepClient.deleteChallenge(crossinline block: DeleteChallengeRequest.Builder.() -> Unit): DeleteChallengeResponse = deleteChallenge(DeleteChallengeRequest.Builder().apply(block).build())

/**
 * Deletes the specified [Connector](https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Connector.html). This operation also deletes any challenges associated with the connector.
 */
public suspend inline fun PcaConnectorScepClient.deleteConnector(crossinline block: DeleteConnectorRequest.Builder.() -> Unit): DeleteConnectorResponse = deleteConnector(DeleteConnectorRequest.Builder().apply(block).build())

/**
 * Retrieves the metadata for the specified [Challenge](https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Challenge.html).
 */
public suspend inline fun PcaConnectorScepClient.getChallengeMetadata(crossinline block: GetChallengeMetadataRequest.Builder.() -> Unit): GetChallengeMetadataResponse = getChallengeMetadata(GetChallengeMetadataRequest.Builder().apply(block).build())

/**
 * Retrieves the challenge password for the specified [Challenge](https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Challenge.html).
 */
public suspend inline fun PcaConnectorScepClient.getChallengePassword(crossinline block: GetChallengePasswordRequest.Builder.() -> Unit): GetChallengePasswordResponse = getChallengePassword(GetChallengePasswordRequest.Builder().apply(block).build())

/**
 * Retrieves details about the specified [Connector](https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Connector.html). Calling this action returns important details about the connector, such as the public SCEP URL where your clients can request certificates.
 */
public suspend inline fun PcaConnectorScepClient.getConnector(crossinline block: GetConnectorRequest.Builder.() -> Unit): GetConnectorResponse = getConnector(GetConnectorRequest.Builder().apply(block).build())

/**
 * Retrieves the challenge metadata for the specified ARN.
 */
public suspend inline fun PcaConnectorScepClient.listChallengeMetadata(crossinline block: ListChallengeMetadataRequest.Builder.() -> Unit): ListChallengeMetadataResponse = listChallengeMetadata(ListChallengeMetadataRequest.Builder().apply(block).build())

/**
 * Lists the connectors belonging to your Amazon Web Services account.
 */
public suspend inline fun PcaConnectorScepClient.listConnectors(crossinline block: ListConnectorsRequest.Builder.() -> Unit): ListConnectorsResponse = listConnectors(ListConnectorsRequest.Builder().apply(block).build())

/**
 * Retrieves the tags associated with the specified resource. Tags are key-value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
 */
public suspend inline fun PcaConnectorScepClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to your resource.
 */
public suspend inline fun PcaConnectorScepClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from your resource.
 */
public suspend inline fun PcaConnectorScepClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
