// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.outposts.serde

import aws.sdk.kotlin.services.outposts.model.Address
import aws.sdk.kotlin.services.outposts.model.AddressType
import aws.sdk.kotlin.services.outposts.model.UpdateSiteAddressRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateSiteAddressOperationSerializer: HttpSerializer.NonStreaming<UpdateSiteAddressRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateSiteAddressRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.siteId) { "siteId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("sites"))
                add(PercentEncoding.SmithyLabel.encode(input.siteId))
                add(PercentEncoding.Path.encode("address"))
            }
        }

        val payload = serializeUpdateSiteAddressOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateSiteAddressOperationBody(context: ExecutionContext, input: UpdateSiteAddressRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Address"))
    val ADDRESSTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AddressType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDRESS_DESCRIPTOR)
        field(ADDRESSTYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.address?.let { field(ADDRESS_DESCRIPTOR, it, ::serializeAddressDocument) }
        input.addressType?.let { field(ADDRESSTYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
